# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.menstrual_cycle_response import MenstrualCycleResponse
from .raw_client import AsyncRawMenstrualCycleClient, RawMenstrualCycleClient


class MenstrualCycleClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMenstrualCycleClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMenstrualCycleClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMenstrualCycleClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[dt.date] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MenstrualCycleResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : dt.date

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[dt.date]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MenstrualCycleResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        import datetime
        client = Vital(api_key="YOUR_API_KEY", )
        client.menstrual_cycle.get(user_id='user_id', start_date=datetime.date.fromisoformat("2023-01-15", ), )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncMenstrualCycleClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMenstrualCycleClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMenstrualCycleClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMenstrualCycleClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[dt.date] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MenstrualCycleResponse:
        """
        Parameters
        ----------
        user_id : str

        start_date : dt.date

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[dt.date]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MenstrualCycleResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import datetime
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.menstrual_cycle.get(user_id='user_id', start_date=datetime.date.fromisoformat("2023-01-15", ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data
