# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.menstrual_cycle_response import MenstrualCycleResponse


class RawMenstrualCycleClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[dt.date] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MenstrualCycleResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : dt.date

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[dt.date]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MenstrualCycleResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/summary/menstrual_cycle/{jsonable_encoder(user_id)}",
            method="GET",
            params={
                "provider": provider,
                "start_date": str(start_date),
                "end_date": str(end_date) if end_date is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MenstrualCycleResponse,
                    parse_obj_as(
                        type_=MenstrualCycleResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMenstrualCycleClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[dt.date] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MenstrualCycleResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : dt.date

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[dt.date]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MenstrualCycleResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/summary/menstrual_cycle/{jsonable_encoder(user_id)}",
            method="GET",
            params={
                "provider": provider,
                "start_date": str(start_date),
                "end_date": str(end_date) if end_date is not None else None,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MenstrualCycleResponse,
                    parse_obj_as(
                        type_=MenstrualCycleResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
