# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.resend_webhook_response import ResendWebhookResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawOrderClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def resend_events(
        self,
        *,
        order_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        start_at: typing.Optional[dt.datetime] = OMIT,
        end_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ResendWebhookResponse]:
        """
        Replay a webhook for a given set of orders

        Parameters
        ----------
        order_ids : typing.Optional[typing.Sequence[str]]

        start_at : typing.Optional[dt.datetime]

        end_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResendWebhookResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/resend_events",
            method="POST",
            json={
                "order_ids": order_ids,
                "start_at": start_at,
                "end_at": end_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResendWebhookResponse,
                    parse_obj_as(
                        type_=ResendWebhookResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawOrderClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def resend_events(
        self,
        *,
        order_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        start_at: typing.Optional[dt.datetime] = OMIT,
        end_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ResendWebhookResponse]:
        """
        Replay a webhook for a given set of orders

        Parameters
        ----------
        order_ids : typing.Optional[typing.Sequence[str]]

        start_at : typing.Optional[dt.datetime]

        end_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResendWebhookResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/resend_events",
            method="POST",
            json={
                "order_ids": order_ids,
                "start_at": start_at,
                "end_at": end_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResendWebhookResponse,
                    parse_obj_as(
                        type_=ResendWebhookResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
