# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_source import ClientFacingSource


class ClientFacingBody(UniversalBaseModel):
    id: str
    user_id: str = pydantic.Field()
    """
    User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.
    """

    date: dt.datetime = pydantic.Field()
    """
    Date of the specified record, formatted as ISO8601 datetime string in UTC 00:00. Deprecated in favour of calendar_date.
    """

    calendar_date: dt.date = pydantic.Field()
    """
    Date of the summary in the YYYY-mm-dd format.
    """

    weight: typing.Optional[float] = pydantic.Field(default=None)
    """
    Weight in kg::kg
    """

    fat: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total body fat percentage::perc
    """

    water_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Water percentage in the body::perc
    """

    muscle_mass_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Muscle mass percentage in the body::perc
    """

    visceral_fat_index: typing.Optional[float] = pydantic.Field(default=None)
    """
    Visceral fat index::scalar
    """

    bone_mass_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Bone mass percentage in the body::perc
    """

    body_mass_index: typing.Optional[float] = None
    lean_body_mass_kilogram: typing.Optional[float] = None
    waist_circumference_centimeter: typing.Optional[float] = None
    source: ClientFacingSource
    created_at: dt.datetime
    updated_at: dt.datetime

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
