# فهرس التوثيق الشامل - ZyraCrypt

## مرحباً بك في توثيق ZyraCrypt 🔒

هذا الفهرس الشامل يوجهك عبر جميع جوانب مكتبة ZyraCrypt للتشفير المتقدم.

## 📚 دليل التصفح السريع

### للمبتدئين

إذا كنت جديداً على ZyraCrypt، ابدأ من هنا:

1. **[دليل البداية والتثبيت](01-getting-started.md)** 
   - التثبيت والإعداد
   - المثال الأول
   - التحقق من التثبيت

2. **[التشفير الأساسي](02-basic-encryption.md)**
   - التشفير المتماثل (AES, ChaCha20)
   - التشفير غير المتماثل (RSA, ECDSA)
   - أمثلة عملية بسيطة

3. **[إدارة المفاتيح](03-key-management.md)**
   - توليد المفاتيح
   - اشتقاق من كلمات المرور
   - التخزين الآمن

### للمستخدمين المتوسطين

بعد إتقان الأساسيات:

4. **[الميزات المتقدمة](04-advanced-features.md)**
   - التوقيعات العتبية
   - الحوسبة متعددة الأطراف (MPC)
   - المقاومة للهجمات الجانبية

5. **[التشفير ما بعد الكم](05-post-quantum.md)**
   - Kyber & Dilithium
   - التشفير الهجين
   - الأمان المستقبلي

6. **[أمثلة عملية](06-examples.md)**
   - أنظمة مصادقة كاملة
   - تطبيقات حقيقية
   - سيناريوهات شاملة

### للمحترفين

للاستخدام المتقدم والإنتاج:

7. **[مرجع API الكامل](07-api-reference.md)**
   - جميع الوحدات والدوال
   - المعاملات والقيم المرجعة
   - أنواع البيانات

8. **[أفضل الممارسات الأمنية](08-security-best-practices.md)**
   - قواعد الأمان الذهبية
   - الأخطاء الشائعة
   - قائمة المراجعة الأمنية

9. **[حماية البيانات](09-data-protection.md)**
   - الضغط والإخفاء
   - إدارة الأنواع
   - المعالجة الآمنة للذاكرة

10. **[الأمان المتخصص](10-specialized-security.md)**
    - تشفير الملفات
    - الإخفاء التشفيري (Steganography)
    - الحذف الآمن
    - إدارة الجلسات

11. **[التشفير وسلسلة الكتل](11-blockchain-crypto.md)**
    - وظائف Blockchain
    - إثبات العمل
    - المعاملات الموقعة

### للدعم وحل المشاكل

عندما تواجه مشاكل:

12. **[استكشاف الأخطاء](12-troubleshooting.md)**
    - الأخطاء الشائعة والحلول
    - نصائح التصحيح
    - جدول الأخطاء السريع

13. **[الأسئلة الشائعة](13-faq.md)**
    - أسئلة عامة
    - أسئلة تقنية
    - أسئلة الأداء

### للنشر والإنتاج

14. **[دليل النشر](14-deployment-guide.md)**
    - إعداد الإنتاج
    - نشر على السحابة (AWS, Docker, K8s)
    - المراقبة والنسخ الاحتياطي

15. **[دليل الترحيل](15-migration-guide.md)** *(قريباً)*
    - الترحيل من إصدارات سابقة
    - تحديث الخوارزميات
    - إستراتيجيات الترحيل

## 🎯 البحث السريع

### حسب الموضوع

#### التشفير
- [AES-GCM](02-basic-encryption.md#1-التشفير-باستخدام-aes-gcm)
- [ChaCha20](02-basic-encryption.md#2-التشفير-باستخدام-chacha20-poly1305)
- [RSA](02-basic-encryption.md#1-التشفير-بـ-rsa)
- [ECDSA](02-basic-encryption.md#2-التوقيع-الرقمي-بـ-ecdsa)
- [Hybrid PQC](05-post-quantum.md#التشفير-الهجين-hybrid-cryptography)

#### إدارة المفاتيح
- [توليد المفاتيح](03-key-management.md#توليد-المفاتيح)
- [اشتقاق من كلمات المرور](03-key-management.md#2-اشتقاق-المفاتيح-من-كلمات-المرور)
- [التخزين الآمن](03-key-management.md#تخزين-المفاتيح-الآمن)
- [تدوير المفاتيح](03-key-management.md#تدوير-المفاتيح-key-rotation)

#### الميزات المتقدمة
- [Threshold Signatures](04-advanced-features.md#1-التوقيعات-العتبية-threshold-signatures)
- [MPC](04-advanced-features.md#2-الحوسبة-الآمنة-متعددة-الأطراف-mpc)
- [Side-Channel Protection](04-advanced-features.md#3-المقاومة-للهجمات-الجانبية)
- [Algorithm Agility](04-advanced-features.md#4-مرونة-الخوارزميات-algorithm-agility)

#### التطبيقات العملية
- [نظام مصادقة](06-examples.md#المثال-1-نظام-مصادقة-آمن)
- [تشفير ملفات](06-examples.md#المثال-2-تشفير-الملفات-الآمن)
- [API آمن](06-examples.md#المثال-3-api-آمن-للبيانات-الحساسة)
- [نظام رسائل](06-examples.md#المثال-5-نظام-رسائل-مشفرة-من-نهاية-إلى-نهاية)

### حسب حالة الاستخدام

| الحالة | الدليل المناسب |
|--------|----------------|
| تشفير بيانات بسيطة | [التشفير الأساسي](02-basic-encryption.md) |
| تأمين كلمات المرور | [إدارة المفاتيح](03-key-management.md#إدارة-كلمات-المرور) |
| معاملات تحتاج عدة موافقات | [التوقيعات العتبية](04-advanced-features.md#1-التوقيعات-العتبية-threshold-signatures) |
| حماية من الحواسيب الكمية | [التشفير الكمي](05-post-quantum.md) |
| إخفاء بيانات في صور | [Steganography](10-specialized-security.md#الإخفاء-التشفيري---steganography) |
| حذف آمن للملفات | [الحذف الآمن](10-specialized-security.md#الحذف-الآمن-securedeletionunit) |
| بناء blockchain | [Blockchain](11-blockchain-crypto.md) |
| نشر في الإنتاج | [دليل النشر](14-deployment-guide.md) |

## 🔍 البحث حسب الخوارزمية

### خوارزميات متماثلة
- **AES-256-GCM**: [الوثائق](02-basic-encryption.md#1-التشفير-باستخدام-aes-gcm) | [API](07-api-reference.md#symmetricencryption)
- **ChaCha20-Poly1305**: [الوثائق](02-basic-encryption.md#2-التشفير-باستخدام-chacha20-poly1305) | [API](07-api-reference.md#encrypt_chacha20_poly1305)

### خوارزميات غير متماثلة
- **RSA-2048/4096**: [الوثائق](02-basic-encryption.md#1-التشفير-بـ-rsa) | [API](07-api-reference.md#asymmetricencryption)
- **ECDSA**: [الوثائق](02-basic-encryption.md#2-التوقيع-الرقمي-بـ-ecdsa) | [API](07-api-reference.md#sign_ecdsa)
- **ECDH**: [الوثائق](02-basic-encryption.md#3-تبادل-المفاتيح-بـ-ecdh) | [API](07-api-reference.md#keyexchange)

### خوارزميات كمية
- **Kyber**: [الوثائق](05-post-quantum.md#1-kyber-تبادل-المفاتيح) | [API](07-api-reference.md#postquantumcryptographyunit)
- **Dilithium**: [الوثائق](05-post-quantum.md#2-dilithium-التوقيعات-الرقمية) | [API](07-api-reference.md#sign)

### KDF
- **Argon2**: [الوثائق](03-key-management.md#استخدام-argon2-الأفضل) | [API](07-api-reference.md#enhancedkdf)
- **Scrypt**: [الوثائق](03-key-management.md#استخدام-scrypt) 
- **PBKDF2**: [الوثائق](03-key-management.md#استخدام-pbkdf2)

## 📊 المخططات والجداول المرجعية

### مقارنة الخوارزميات

| الخوارزمية | السرعة | الأمان | الحجم | الاستخدام |
|-----------|--------|--------|-------|-----------|
| AES-GCM | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | صغير | البيانات العامة |
| ChaCha20 | ⭐⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | صغير | الأجهزة المحمولة |
| RSA-2048 | ⭐⭐ | ⭐⭐⭐⭐ | كبير | تشفير المفاتيح |
| ECDSA | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | صغير | التوقيعات |
| Kyber | ⭐⭐⭐⭐ | ⭐⭐⭐⭐⭐ | متوسط | المستقبل الآمن |

### مستويات الأمان

| المستوى | الطول | الاستخدام | الخوارزمية |
|---------|-------|-----------|-----------|
| 128-bit | 16 بايت | قياسي | AES-128 |
| 192-bit | 24 بايت | حساس | AES-192 |
| 256-bit | 32 بايت | سري جداً | AES-256 |

## 🚀 مسارات التعلم الموصى بها

### المسار 1: المطور المبتدئ
```
1. دليل البداية (01)
   ↓
2. التشفير الأساسي (02)
   ↓
3. إدارة المفاتيح (03)
   ↓
4. أمثلة عملية (06)
   ↓
5. أفضل الممارسات (08)
```

### المسار 2: مهندس الأمان
```
1. دليل البداية (01)
   ↓
2. إدارة المفاتيح (03)
   ↓
3. الميزات المتقدمة (04)
   ↓
4. التشفير الكمي (05)
   ↓
5. أفضل الممارسات (08)
   ↓
6. مرجع API (07)
```

### المسار 3: مهندس DevOps
```
1. دليل البداية (01)
   ↓
2. التشفير الأساسي (02)
   ↓
3. إدارة المفاتيح (03)
   ↓
4. دليل النشر (14)
   ↓
5. استكشاف الأخطاء (12)
```

### المسار 4: مطور Blockchain
```
1. دليل البداية (01)
   ↓
2. التشفير الأساسي (02)
   ↓
3. الميزات المتقدمة (04)
   ↓
4. Blockchain (11)
   ↓
5. أمثلة عملية (06)
```

## 📖 الموارد الإضافية

### ملفات مهمة
- **README.md**: نظرة عامة على المشروع
- **LICENSE**: رخصة MIT
- **CONTRIBUTING.md**: دليل المساهمة *(قريباً)*

### أدوات مساعدة
- **اختبارات**: `test_advanced_features.py`
- **أمثلة**: مجلد `examples/` *(قريباً)*

### روابط خارجية
- [NIST Cryptographic Standards](https://csrc.nist.gov/)
- [OWASP Cryptographic Storage](https://cheatsheetseries.owasp.org/cheatsheets/Cryptographic_Storage_Cheat_Sheet.html)
- [Post-Quantum Cryptography](https://csrc.nist.gov/projects/post-quantum-cryptography)

## 🆘 الحصول على المساعدة

### داخل التوثيق
1. **[استكشاف الأخطاء](12-troubleshooting.md)** - حلول للمشاكل الشائعة
2. **[الأسئلة الشائعة](13-faq.md)** - إجابات سريعة
3. **[مرجع API](07-api-reference.md)** - وثائق تقنية مفصلة

### خارج التوثيق
- **GitHub Issues**: للإبلاغ عن مشاكل
- **Discussions**: للأسئلة العامة
- **Security**: للمشاكل الأمنية (خاص)

## ✨ ملاحظات مهمة

### رموز الحالة
- ✅ **مكتمل**: الوثائق جاهزة وشاملة
- 🚧 **قيد العمل**: قد تحتاج لتحديثات
- 📅 **قريباً**: سيتم إضافتها لاحقاً

### الإصدار الحالي
- **ZyraCrypt**: v2.0.0
- **التوثيق**: آخر تحديث 2024
- **Python**: 3.10+

## 🎉 ابدأ الآن!

مستعد للبدء؟ اختر نقطة البداية:

- 🌟 **مبتدئ؟** [ابدأ من هنا](01-getting-started.md)
- 💼 **محترف؟** [الميزات المتقدمة](04-advanced-features.md)
- 🚀 **جاهز للنشر؟** [دليل النشر](14-deployment-guide.md)
- 🔍 **تبحث عن شيء محدد؟** استخدم الفهرس أعلاه

---

**تم بواسطة Alqudimi Systems**  
**ZyraCrypt v2.0.0 - Enterprise-Grade Cryptography for Python**

---

*آخر تحديث: 2024 | جميع الحقوق محفوظة تحت رخصة MIT*
