# دليل البداية والتثبيت

## مرحباً بك في ZyraCrypt 🔒

ZyraCrypt هي مكتبة تشفير متقدمة ومؤسسية مصممة لتوفير أعلى مستويات الأمان في تطبيقات Python. توفر المكتبة مجموعة شاملة من الأدوات التشفيرية الحديثة بما في ذلك التشفير الكمي المستقبلي.

## المتطلبات الأساسية

قبل البدء، تأكد من توفر المتطلبات التالية:

- **Python**: الإصدار 3.10 أو أحدث
- **pip**: مدير الحزم (يأتي مع Python)
- **نظام التشغيل**: Linux, macOS, أو Windows

## التثبيت

### الطريقة الأولى: التثبيت من المصدر

```bash
# استنساخ المستودع
git clone https://github.com/yourusername/zyracrypt.git
cd zyracrypt

# التثبيت في وضع التطوير
pip install -e .
```

### الطريقة الثانية: التثبيت مع أدوات التطوير

```bash
# تثبيت المكتبة مع أدوات الاختبار
pip install -e ".[dev]"
```

## التحقق من التثبيت

بعد التثبيت، يمكنك التحقق من نجاح العملية:

```python
# افتح Python Shell
python3

# جرب استيراد المكتبة
>>> from core_cryptography.encryption_framework import EncryptionFramework
>>> framework = EncryptionFramework()
>>> print("تم التثبيت بنجاح!")
```

## التبعيات المثبتة تلقائياً

عند تثبيت ZyraCrypt، يتم تثبيت المكتبات التالية تلقائياً:

| المكتبة | الإصدار | الوصف |
|---------|---------|--------|
| cryptography | ≥46.0.2 | المكتبة الأساسية للتشفير |
| pynacl | ≥1.6.0 | تشفير حديث (NaCl) |
| argon2-cffi | ≥25.1.0 | تشفير كلمات المرور بـ Argon2 |
| liboqs-python | ≥0.14.1 | التشفير الكمي المستقبلي |
| flask | ≥3.1.2 | إطار العمل للواجهات البرمجية |
| flask-cors | ≥6.0.1 | دعم CORS |
| pillow | ≥11.3.0 | معالجة الصور (للإخفاء التشفيري) |

## المثال الأول: التشفير البسيط

لنبدأ بمثال بسيط لتشفير وفك تشفير البيانات:

```python
from core_cryptography.encryption_framework import EncryptionFramework

# إنشاء كائن التشفير
framework = EncryptionFramework()

# المفتاح (32 بايت لـ AES-256)
key = b"مفتاح-تشفير-سري-32-بايت-هنا!"

# البيانات المراد تشفيرها
data = b"معلومات سرية للغاية"

# عملية التشفير
algorithm, iv, ciphertext, tag = framework.encrypt(data, key, "AES-GCM")
print(f"تم التشفير باستخدام: {algorithm}")

# فك التشفير
decrypted = framework.decrypt(algorithm, key, iv, ciphertext, tag)
print(f"البيانات المفككة: {decrypted.decode('utf-8')}")
```

## الخطوات القادمة

الآن بعد أن قمت بتثبيت المكتبة بنجاح، يمكنك:

1. **التعرف على التشفير الأساسي**: اقرأ [دليل التشفير الأساسي](02-basic-encryption.md)
2. **إدارة المفاتيح**: تعلم كيفية إدارة المفاتيح بأمان في [دليل إدارة المفاتيح](03-key-management.md)
3. **الميزات المتقدمة**: استكشف الميزات المتقدمة في [دليل الميزات المتقدمة](04-advanced-features.md)
4. **أمثلة عملية**: شاهد أمثلة كاملة في [دليل الأمثلة](06-examples.md)

## تشغيل الاختبارات

للتحقق من أن كل شيء يعمل بشكل صحيح:

```bash
python test_advanced_features.py
```

يجب أن ترى نتيجة تشير إلى نجاح 6 من 7 اختبارات (85.7%).

## هيكل المشروع

```
zyracrypt/
├── core_cryptography/          # خوارزميات التشفير الأساسية
├── key_management/             # إدارة المفاتيح
├── advanced_features/          # الميزات المتقدمة
├── data_protection/            # حماية البيانات
├── specialized_security/       # الأمان المتخصص
└── post_quantum_cryptography/  # التشفير الكمي
```

## الحصول على المساعدة

إذا واجهت أي مشاكل:

1. راجع [مرجع API الكامل](07-api-reference.md)
2. اطلع على [الأمثلة العملية](06-examples.md)
3. راجع [أفضل الممارسات الأمنية](08-security-best-practices.md)

## ملاحظات مهمة

⚠️ **تحذيرات أمنية:**

- استخدم دائماً مفاتيح عشوائية آمنة بالطول المناسب
- لا تعيد استخدام نفس IV/Nonce مع نفس المفتاح
- احفظ المفاتيح بشكل آمن وقم بتدويرها بانتظام
- حافظ على تحديث المكتبات باستمرار

---

**تم الإنشاء بواسطة Alqudimi Systems**
