#!/usr/bin/env python
# coding=utf-8
"""The setup script."""
import setuptools
from base1x.version import project_version

from trader1x import __author__

try:
    from setuptools import find_packages, setup
except ImportError:
    from distutils.core import find_packages, setup


latest, author = project_version()
__version__ = latest

def parse_requirements(filename):
    line_iter = (line.strip() for line in open(filename))
    return [line for line in line_iter if line and not line.startswith("#")]


with open("README.md", encoding="utf-8") as readme_file:
    readme = readme_file.read()

with open("CHANGELOG.md", encoding="utf-8") as history_file:
    history = history_file.read()

requirements = parse_requirements("requirements.txt")
test_requirements = requirements

setuptools.setup(
    name="quant1x-trader",
    description="Quant1X程序化自动化交易",
    author_email="wangfengxy@sina.cn",
    url="https://gitee.com/quant1x/trader",
    version=__version__,
    author=__author__,
    long_description=readme,
    packages=setuptools.find_packages(include=["trader1x", "trader1x.*"]),
    include_package_data=True,
    install_requires=requirements,
    license="MIT license",
    zip_safe=False,
    keywords="quant1x auto trader",
    entry_points={
        "console_scripts": [
            "quant1x-auto-trader=trader1x.auto:auto_trader",
            "quant1x-qmt=trader1x.qmt:main",
            "quant1x-qmt-proxy=trader1x.proxy:main",
        ]
    },
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    data_files=[
        # ('xtquant', ['xtquant/xtdata.ini', 'xtquant/xtdata.log4cxx']),
    ],
    package_data={
        '': ['*.dll', '*.pyd', '*.ini', '*.log4cxx'],
    },
    test_suite="tests",
    tests_require=test_requirements,
    setup_requires=requirements,
)
