# Tutorials

Step-by-step guides for accomplishing specific tasks with JaxARC.

## Available Tutorials

::::{grid} 1 2 2 2
:gutter: 2

:::{grid-item-card} 📦 Downloading Datasets
:link: downloading-datasets
:link-type: doc

Learn how to download and access different ARC datasets
:::

:::{grid-item-card} 👁️ Visualizing Tasks
:link: visualizing-tasks
:link-type: doc

Understand and debug tasks through visualization
:::

:::{grid-item-card} 🤖 Creating Agents
:link: creating-agents
:link-type: doc

Build baseline and custom agents for ARC tasks
:::

:::{grid-item-card} 🔧 Using Wrappers
:link: using-wrappers
:link-type: doc

Transform observations and rewards with wrappers
:::

::::

## Prerequisites

Before starting these tutorials, make sure you've completed:

- [Installation](../getting-started/installation.md) - JaxARC installed and
  working
- [Quick Start](../getting-started/quickstart.md) - Basic environment usage
- [First Example](../getting-started/first-example.md) - Complete working
  example

## Getting Help

If you encounter issues while following a tutorial:

1. Check the troubleshooting section in each tutorial
2. Consult the [API Reference](../api/index.md) for detailed function
   documentation
3. Ask on [GitHub Discussions](https://github.com/aadimator/JaxARC/discussions)

```{toctree}
:maxdepth: 2
:hidden:

downloading-datasets
visualizing-tasks.ipynb
creating-agents.ipynb
using-wrappers.ipynb
```
