"""empty message

Revision ID: babf96303363
Revises: 038164d73465
Create Date: 2024-08-24 17:26:09.725307

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "babf96303363"
down_revision: Union[str, None] = "038164d73465"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    op.create_table(
        "sequence.exception_tracebacks",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("sequence_id", sa.Integer(), nullable=False),
        sa.Column("content", sa.JSON(), nullable=False),
        sa.ForeignKeyConstraint(["sequence_id"], ["sequences.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("sequence_id"),
    )
    op.create_index(
        op.f("ix_sequence.exception_tracebacks_sequence_id"),
        "sequence.exception_tracebacks",
        ["sequence_id"],
        unique=False,
    )


def downgrade() -> None:
    raise NotImplementedError("Downgrade is not supported")
    # ### commands auto generated by Alembic - please adjust! ###
    # op.drop_index(
    #     op.f("ix_sequence.exception_tracebacks_sequence_id"),
    #     table_name="sequence.exception_tracebacks",
    # )
    # op.drop_table("sequence.exception_tracebacks")
    # ### end Alembic commands ###
