from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="botmanager",
    version="1.0.0",
    author="TheRealPourya",
    author_email="your-email@example.com",
    description="A modern, production-ready Windows desktop application for managing and running multiple bots from a beautiful web-based dashboard",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/xPOURY4/Bot-Management-Dashboard",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: Microsoft :: Windows",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.8",
    install_requires=[
        "Flask>=3.0.0",
        "Flask-CORS>=4.0.0",
        "Werkzeug>=3.0.1",
    ],
    include_package_data=True,
    package_data={
        "botmanager": [
            "templates/*",
            "static/*",
            "static/css/*",
            "static/js/*",
            "icon/*",
        ]
    },
    entry_points={
        "console_scripts": [
            "botmanager=botmanager.cli:main",
        ],
    },
    keywords="bot management dashboard automation python nodejs powershell",
    project_urls={
        "Bug Reports": "https://github.com/xPOURY4/Bot-Management-Dashboard/issues",
        "Source": "https://github.com/xPOURY4/Bot-Management-Dashboard",
    },
)
