# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertPolicyArgs', 'AlertPolicy']

@pulumi.input_type
class AlertPolicyArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[_builtins.str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 continue_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]] = None,
                 ignore_original_actions: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_responders: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]] = None):
        """
        The set of arguments for constructing a AlertPolicy resource.
        :param pulumi.Input[_builtins.str] message: Message of the alerts
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        :param pulumi.Input[_builtins.str] alert_description: Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        :param pulumi.Input[_builtins.str] alias: Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        :param pulumi.Input[_builtins.bool] continue_policy: It will trigger other modify policies if set to `true`. Default: `false`
        :param pulumi.Input[_builtins.bool] enabled: If policy should be enabled. Default: `true`
        :param pulumi.Input[_builtins.str] entity: Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]] filters: A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.bool] ignore_original_actions: If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_details: If set to `true`, policy will ignore the original details of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_responders: If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_tags: If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        :param pulumi.Input[_builtins.str] name: Name of the alert policy
        :param pulumi.Input[_builtins.str] policy_description: Description of the policy. This can be max 512 characters.
        :param pulumi.Input[_builtins.str] priority: Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]] responders: Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.str] source: Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        :param pulumi.Input[_builtins.str] team_id: Id of team that this policy belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]] time_restrictions: Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        pulumi.set(__self__, "message", message)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if continue_policy is not None:
            pulumi.set(__self__, "continue_policy", continue_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if ignore_original_actions is not None:
            pulumi.set(__self__, "ignore_original_actions", ignore_original_actions)
        if ignore_original_details is not None:
            pulumi.set(__self__, "ignore_original_details", ignore_original_details)
        if ignore_original_responders is not None:
            pulumi.set(__self__, "ignore_original_responders", ignore_original_responders)
        if ignore_original_tags is not None:
            pulumi.set(__self__, "ignore_original_tags", ignore_original_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_description is not None:
            pulumi.set(__self__, "policy_description", policy_description)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_restrictions is not None:
            pulumi.set(__self__, "time_restrictions", time_restrictions)

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Input[_builtins.str]:
        """
        Message of the alerts
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_description", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="continuePolicy")
    def continue_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It will trigger other modify policies if set to `true`. Default: `false`
        """
        return pulumi.get(self, "continue_policy")

    @continue_policy.setter
    def continue_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "continue_policy", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If policy should be enabled. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]]:
        """
        A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalActions")
    def ignore_original_actions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_actions")

    @ignore_original_actions.setter
    def ignore_original_actions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_actions", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalDetails")
    def ignore_original_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original details of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_details")

    @ignore_original_details.setter
    def ignore_original_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_details", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalResponders")
    def ignore_original_responders(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_responders")

    @ignore_original_responders.setter
    def ignore_original_responders(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_responders", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalTags")
    def ignore_original_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_tags")

    @ignore_original_tags.setter
    def ignore_original_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_tags", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alert policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyDescription")
    def policy_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the policy. This can be max 512 characters.
        """
        return pulumi.get(self, "policy_description")

    @policy_description.setter
    def policy_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_description", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def responders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]]:
        """
        Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "responders")

    @responders.setter
    def responders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]]):
        pulumi.set(self, "responders", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of team that this policy belongs to.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="timeRestrictions")
    def time_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]]:
        """
        Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        return pulumi.get(self, "time_restrictions")

    @time_restrictions.setter
    def time_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]]):
        pulumi.set(self, "time_restrictions", value)


@pulumi.input_type
class _AlertPolicyState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 continue_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]] = None,
                 ignore_original_actions: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_responders: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]] = None):
        """
        Input properties used for looking up and filtering AlertPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        :param pulumi.Input[_builtins.str] alert_description: Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        :param pulumi.Input[_builtins.str] alias: Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        :param pulumi.Input[_builtins.bool] continue_policy: It will trigger other modify policies if set to `true`. Default: `false`
        :param pulumi.Input[_builtins.bool] enabled: If policy should be enabled. Default: `true`
        :param pulumi.Input[_builtins.str] entity: Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]] filters: A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.bool] ignore_original_actions: If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_details: If set to `true`, policy will ignore the original details of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_responders: If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_tags: If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        :param pulumi.Input[_builtins.str] message: Message of the alerts
        :param pulumi.Input[_builtins.str] name: Name of the alert policy
        :param pulumi.Input[_builtins.str] policy_description: Description of the policy. This can be max 512 characters.
        :param pulumi.Input[_builtins.str] priority: Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]] responders: Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.str] source: Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        :param pulumi.Input[_builtins.str] team_id: Id of team that this policy belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]] time_restrictions: Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if alert_description is not None:
            pulumi.set(__self__, "alert_description", alert_description)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if continue_policy is not None:
            pulumi.set(__self__, "continue_policy", continue_policy)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if ignore_original_actions is not None:
            pulumi.set(__self__, "ignore_original_actions", ignore_original_actions)
        if ignore_original_details is not None:
            pulumi.set(__self__, "ignore_original_details", ignore_original_details)
        if ignore_original_responders is not None:
            pulumi.set(__self__, "ignore_original_responders", ignore_original_responders)
        if ignore_original_tags is not None:
            pulumi.set(__self__, "ignore_original_tags", ignore_original_tags)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_description is not None:
            pulumi.set(__self__, "policy_description", policy_description)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if responders is not None:
            pulumi.set(__self__, "responders", responders)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_restrictions is not None:
            pulumi.set(__self__, "time_restrictions", time_restrictions)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        """
        return pulumi.get(self, "alert_description")

    @alert_description.setter
    def alert_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_description", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="continuePolicy")
    def continue_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It will trigger other modify policies if set to `true`. Default: `false`
        """
        return pulumi.get(self, "continue_policy")

    @continue_policy.setter
    def continue_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "continue_policy", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If policy should be enabled. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]]:
        """
        A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalActions")
    def ignore_original_actions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_actions")

    @ignore_original_actions.setter
    def ignore_original_actions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_actions", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalDetails")
    def ignore_original_details(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original details of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_details")

    @ignore_original_details.setter
    def ignore_original_details(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_details", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalResponders")
    def ignore_original_responders(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_responders")

    @ignore_original_responders.setter
    def ignore_original_responders(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_responders", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalTags")
    def ignore_original_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_tags")

    @ignore_original_tags.setter
    def ignore_original_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_original_tags", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message of the alerts
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alert policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyDescription")
    def policy_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the policy. This can be max 512 characters.
        """
        return pulumi.get(self, "policy_description")

    @policy_description.setter
    def policy_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_description", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def responders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]]:
        """
        Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "responders")

    @responders.setter
    def responders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyResponderArgs']]]]):
        pulumi.set(self, "responders", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of team that this policy belongs to.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="timeRestrictions")
    def time_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]]:
        """
        Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        return pulumi.get(self, "time_restrictions")

    @time_restrictions.setter
    def time_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyTimeRestrictionArgs']]]]):
        pulumi.set(self, "time_restrictions", value)


@pulumi.type_token("opsgenie:index/alertPolicy:AlertPolicy")
class AlertPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 continue_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyFilterArgs', 'AlertPolicyFilterArgsDict']]]]] = None,
                 ignore_original_actions: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_responders: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyResponderArgs', 'AlertPolicyResponderArgsDict']]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyTimeRestrictionArgs', 'AlertPolicyTimeRestrictionArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Alert Policy within Opsgenie.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_opsgenie as opsgenie

        test = opsgenie.Team("test",
            name="example team",
            description="This team deals with all the things")
        test_alert_policy = opsgenie.AlertPolicy("test",
            filters=[{}],
            name="example policy",
            team_id=test.id,
            policy_description="This is sample policy",
            message="{{message}}",
            time_restrictions=[{
                "type": "weekday-and-time-of-day",
                "restriction_list": [
                    {
                        "end_day": "monday",
                        "end_hour": 7,
                        "end_min": 0,
                        "start_day": "sunday",
                        "start_hour": 21,
                        "start_min": 0,
                    },
                    {
                        "end_day": "tuesday",
                        "end_hour": 7,
                        "end_min": 0,
                        "start_day": "monday",
                        "start_hour": 22,
                        "start_min": 0,
                    },
                ],
            }])
        ```

        ## Import

        Alert policies can be imported using the `team_id/policy_id`, e.g.

        ```sh
        $ pulumi import opsgenie:index/alertPolicy:AlertPolicy test team_id/policy_id`
        ```

        You can import global polices using only policy identifier

        ```sh
        $ pulumi import opsgenie:index/alertPolicy:AlertPolicy test policy_id`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        :param pulumi.Input[_builtins.str] alert_description: Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        :param pulumi.Input[_builtins.str] alias: Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        :param pulumi.Input[_builtins.bool] continue_policy: It will trigger other modify policies if set to `true`. Default: `false`
        :param pulumi.Input[_builtins.bool] enabled: If policy should be enabled. Default: `true`
        :param pulumi.Input[_builtins.str] entity: Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyFilterArgs', 'AlertPolicyFilterArgsDict']]]] filters: A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.bool] ignore_original_actions: If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_details: If set to `true`, policy will ignore the original details of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_responders: If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_tags: If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        :param pulumi.Input[_builtins.str] message: Message of the alerts
        :param pulumi.Input[_builtins.str] name: Name of the alert policy
        :param pulumi.Input[_builtins.str] policy_description: Description of the policy. This can be max 512 characters.
        :param pulumi.Input[_builtins.str] priority: Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyResponderArgs', 'AlertPolicyResponderArgsDict']]]] responders: Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.str] source: Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        :param pulumi.Input[_builtins.str] team_id: Id of team that this policy belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyTimeRestrictionArgs', 'AlertPolicyTimeRestrictionArgsDict']]]] time_restrictions: Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Alert Policy within Opsgenie.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_opsgenie as opsgenie

        test = opsgenie.Team("test",
            name="example team",
            description="This team deals with all the things")
        test_alert_policy = opsgenie.AlertPolicy("test",
            filters=[{}],
            name="example policy",
            team_id=test.id,
            policy_description="This is sample policy",
            message="{{message}}",
            time_restrictions=[{
                "type": "weekday-and-time-of-day",
                "restriction_list": [
                    {
                        "end_day": "monday",
                        "end_hour": 7,
                        "end_min": 0,
                        "start_day": "sunday",
                        "start_hour": 21,
                        "start_min": 0,
                    },
                    {
                        "end_day": "tuesday",
                        "end_hour": 7,
                        "end_min": 0,
                        "start_day": "monday",
                        "start_hour": 22,
                        "start_min": 0,
                    },
                ],
            }])
        ```

        ## Import

        Alert policies can be imported using the `team_id/policy_id`, e.g.

        ```sh
        $ pulumi import opsgenie:index/alertPolicy:AlertPolicy test team_id/policy_id`
        ```

        You can import global polices using only policy identifier

        ```sh
        $ pulumi import opsgenie:index/alertPolicy:AlertPolicy test policy_id`
        ```

        :param str resource_name: The name of the resource.
        :param AlertPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alert_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 continue_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity: Optional[pulumi.Input[_builtins.str]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyFilterArgs', 'AlertPolicyFilterArgsDict']]]]] = None,
                 ignore_original_actions: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_details: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_responders: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_original_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_description: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyResponderArgs', 'AlertPolicyResponderArgsDict']]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyTimeRestrictionArgs', 'AlertPolicyTimeRestrictionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertPolicyArgs.__new__(AlertPolicyArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["alert_description"] = alert_description
            __props__.__dict__["alias"] = alias
            __props__.__dict__["continue_policy"] = continue_policy
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entity"] = entity
            __props__.__dict__["filters"] = filters
            __props__.__dict__["ignore_original_actions"] = ignore_original_actions
            __props__.__dict__["ignore_original_details"] = ignore_original_details
            __props__.__dict__["ignore_original_responders"] = ignore_original_responders
            __props__.__dict__["ignore_original_tags"] = ignore_original_tags
            if message is None and not opts.urn:
                raise TypeError("Missing required property 'message'")
            __props__.__dict__["message"] = message
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_description"] = policy_description
            __props__.__dict__["priority"] = priority
            __props__.__dict__["responders"] = responders
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["time_restrictions"] = time_restrictions
        super(AlertPolicy, __self__).__init__(
            'opsgenie:index/alertPolicy:AlertPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            alert_description: Optional[pulumi.Input[_builtins.str]] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            continue_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity: Optional[pulumi.Input[_builtins.str]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyFilterArgs', 'AlertPolicyFilterArgsDict']]]]] = None,
            ignore_original_actions: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_original_details: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_original_responders: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_original_tags: Optional[pulumi.Input[_builtins.bool]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_description: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            responders: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyResponderArgs', 'AlertPolicyResponderArgsDict']]]]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyTimeRestrictionArgs', 'AlertPolicyTimeRestrictionArgsDict']]]]] = None) -> 'AlertPolicy':
        """
        Get an existing AlertPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        :param pulumi.Input[_builtins.str] alert_description: Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        :param pulumi.Input[_builtins.str] alias: Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        :param pulumi.Input[_builtins.bool] continue_policy: It will trigger other modify policies if set to `true`. Default: `false`
        :param pulumi.Input[_builtins.bool] enabled: If policy should be enabled. Default: `true`
        :param pulumi.Input[_builtins.str] entity: Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyFilterArgs', 'AlertPolicyFilterArgsDict']]]] filters: A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.bool] ignore_original_actions: If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_details: If set to `true`, policy will ignore the original details of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_responders: If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        :param pulumi.Input[_builtins.bool] ignore_original_tags: If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        :param pulumi.Input[_builtins.str] message: Message of the alerts
        :param pulumi.Input[_builtins.str] name: Name of the alert policy
        :param pulumi.Input[_builtins.str] policy_description: Description of the policy. This can be max 512 characters.
        :param pulumi.Input[_builtins.str] priority: Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyResponderArgs', 'AlertPolicyResponderArgsDict']]]] responders: Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        :param pulumi.Input[_builtins.str] source: Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        :param pulumi.Input[_builtins.str] team_id: Id of team that this policy belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPolicyTimeRestrictionArgs', 'AlertPolicyTimeRestrictionArgsDict']]]] time_restrictions: Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertPolicyState.__new__(_AlertPolicyState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["alert_description"] = alert_description
        __props__.__dict__["alias"] = alias
        __props__.__dict__["continue_policy"] = continue_policy
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity"] = entity
        __props__.__dict__["filters"] = filters
        __props__.__dict__["ignore_original_actions"] = ignore_original_actions
        __props__.__dict__["ignore_original_details"] = ignore_original_details
        __props__.__dict__["ignore_original_responders"] = ignore_original_responders
        __props__.__dict__["ignore_original_tags"] = ignore_original_tags
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_description"] = policy_description
        __props__.__dict__["priority"] = priority
        __props__.__dict__["responders"] = responders
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["time_restrictions"] = time_restrictions
        return AlertPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Actions to add to the alerts original actions value as a list of strings. If `ignore_original_actions` field is set to `true`, this will replace the original actions.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="alertDescription")
    def alert_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the alert. You can use `{{description}}` to refer to the original alert description. Default: `{{description}}`
        """
        return pulumi.get(self, "alert_description")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Alias of the alert. You can use `{{alias}}` to refer to the original alias. Default: `{{alias}}`
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="continuePolicy")
    def continue_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        It will trigger other modify policies if set to `true`. Default: `false`
        """
        return pulumi.get(self, "continue_policy")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If policy should be enabled. Default: `true`
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def entity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Entity field of the alert. You can use `{{entity}}` to refer to the original entity. Default: `{{entity}}`
        """
        return pulumi.get(self, "entity")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.AlertPolicyFilter']]]:
        """
        A alert filter which will be applied. This filter can be empty: `filter {}` - this means `match-all`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalActions")
    def ignore_original_actions(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original actions of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_actions")

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalDetails")
    def ignore_original_details(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original details of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_details")

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalResponders")
    def ignore_original_responders(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original responders of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_responders")

    @_builtins.property
    @pulumi.getter(name="ignoreOriginalTags")
    def ignore_original_tags(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, policy will ignore the original tags of the alert. Default: `false`
        """
        return pulumi.get(self, "ignore_original_tags")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        Message of the alerts
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the alert policy
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyDescription")
    def policy_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the policy. This can be max 512 characters.
        """
        return pulumi.get(self, "policy_description")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Priority of the alert. Should be one of `P1`, `P2`, `P3`, `P4`, or `P5`
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def responders(self) -> pulumi.Output[Optional[Sequence['outputs.AlertPolicyResponder']]]:
        """
        Responders to add to the alerts original responders value as a list of teams, users or the reserved word none or all. If `ignore_original_responders` field is set to `true`, this will replace the original responders. The possible values for responders are: `user`, `team`, `escalation`, `schedule`. This is a block, structure is documented below.
        """
        return pulumi.get(self, "responders")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Source field of the alert. You can use `{{source}}` to refer to the original source. Default: `{{source}}`
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to add to the alerts original tags value as a list of strings. If `ignore_original_responders` field is set to `true`, this will replace the original responders.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Id of team that this policy belongs to.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="timeRestrictions")
    def time_restrictions(self) -> pulumi.Output[Optional[Sequence['outputs.AlertPolicyTimeRestriction']]]:
        """
        Time restrictions specified in this field must be met for this policy to work. This is a block, structure is documented below.
        """
        return pulumi.get(self, "time_restrictions")

