
# 🔧 redfishLiteApi

A lightweight command-line tool to interact with Redfish APIs using `GET`, `POST`, and `PATCH` methods. Designed for quick testing, debugging, and field extraction.

----------

## 📦 Features

-   ✅ Support for `GET`, `POST`, and `PATCH`
    
-   🔐 Basic Authentication (`-U` / `-P`)
    
-   📁 JSON body input via file (`--json_file`)
    
-   🔍 Recursive field value search with `--find` (supports multiple fields)
    
-   💾 Save response to file (`--save`)
    
-   🧾 Custom HTTP headers (`--header`)
    
-   ⏱️ 10-second request timeout to prevent hanging
    
-   🧯 Disable SSL verification warnings
    
-   📡 HTTP Status display
    
-   ⚠️ JSON parse error handling with fallback to raw text
    
-   🔢 `--version` support
    

----------

## 🚀 Usage


`python redfishLiteApi.py --url <API_URL> --method <get|post|patch> [OPTIONS]` 

### ✅ Example: Basic GET request


`python redfishLiteApi.py --url https://<host>/redfish/v1/Systems --method get` 

### 🔐 Example: Authenticated GET with header and find field

`python redfishLiteApi.py --url https://<host>/redfish/v1/Systems --method get \
    -U admin -P password \
    --header "If-Match:W/\"etag-value\"" \
    --find Id Name PowerState` 

### 📝 Example: PATCH with body file

`python redfishLiteApi.py --url https://<host>/redfish/v1/Managers/1/EthernetInterfaces/1 \
    --method patch -U admin -P password --json_file update.json` 

### 💾 Example: Save output to file

`python redfishLiteApi.py --url https://<host>/redfish/v1/Systems --method get --save output.json` 

### 📌 Check version

`python redfishLiteApi.py --version` 

----------

## 🧠 Argument Summary

Argument

Description

`--url`

Redfish API endpoint URL (required)

`--method`

HTTP method: `get`, `post`, or `patch` (required)

`-U` / `--username`

Basic auth username

`-P` / `--password`

Basic auth password

`--json_file`

Path to JSON file for POST or PATCH body

`--find`

One or more JSON field names to recursively extract (GET only)

`--save`

Save the response body to a file

`--header`

Custom headers in `Key:Value` format (can be repeated)

`--version`

Show current version and exit

----------

## ⚠️ Notes

-   SSL certificate verification is disabled (`verify=False`).
    
-   Timeout is hardcoded to 10 seconds.
    
-   HTTP error handling is basic — be sure to inspect the response if you encounter unexpected results.
    

----------

## 🛠 Dependencies

-   Python 3.x
    
-   `requests`
    

Install dependencies via:

`pip install -r requirements.txt` 

`requirements.txt` content:

`requests` 

----------

## 📜 License

MIT License