## `claims_fixture.json`

An object corresponding to one row of a claims column only DataFrame from the
[Wikidata](https://huggingface.co/datasets/philippesaade/wikidata) dataset.

It has the claims wrapped in a "claims" field, and under that is an object
whose keys are claim IDs like "P31" etc.

It is generated by `_generate_claims_pq.py` from `claims_fixture.parquet`

If you can parse this, you can parse a single row of the real dataset,
which features a nested map of unifiable records (i.e. records which can be unified as a single
optionalised record) which requires scalar-to-object promotion for the `mainsnak.datavalue.value`
field (specifically in the `mainsnak.datavalue.datatype` = "scalar-string" case).

## `claims_x4.jsonl`

An object corresponding to four rows of a claims column only DataFrame from the
[Wikidata](https://huggingface.co/datasets/philippesaade/wikidata) dataset.

It has the claims **not** wrapped in a "claims" field, instead they are an object at the top level
whose keys are claim IDs like "P31" etc. This is how they are found in the real dataset.

```py
shape: (4, 1)
┌─────────────────────────────────┐
│ claims                          │
│ ---                             │
│ str                             │
╞═════════════════════════════════╡
│ {"P31":[{"mainsnak":{"property… │
│ {"P31":[{"mainsnak":{"property… │
│ {"P373":[{"mainsnak":{"propert… │
│ {"P31":[{"mainsnak":{"property… │
└─────────────────────────────────┘
```
