---
title: "User Guides"
layout: single
permalink: /guides/
sidebar:
  nav: "docs"
toc: true
toc_label: "Available Guides"
toc_icon: "book"
---

This section provides detailed guides for using specific features and capabilities of Insight Ingenious - an enterprise-grade Python library for quickly setting up APIs to interact with AI Agents.

## Available Guides

### Integration and Interfaces
- **[Complete Azure Deployment](./complete-azure-deployment.md)** - Complete enterprise deployment instructions
- **[API Integration](./api-integration.md)** - Using the REST API programmatically
- **[Web Interface](./web-interface.md)** - Using the web-based interface
- **[SQL Agent Setup](./sql-agent-setup.md)** - Complete setup guide for SQL manipulation agent with SQLite and Azure SQL
- **[Data Preparation](./data-preparation/)** - Preparing and processing data for analysis
- **[Document Processing](./document-processing/)** - Working with document analysis workflows

## Guide Categories

### Getting Started
For initial setup and basic usage, see the [Getting Started](../getting-started/README.md) section.

### Workflows
For understanding different conversation workflows and their requirements, see [Workflows](../workflows/README.md).

### Extensions
For creating custom components and advanced configurations, see [Extensions](../extensions/README.md).

### Development
For contributing to the project or advanced development topics, see [Development](../development/README.md).

## Using the Guides

Each guide is designed to be:
- **Self-contained** - You can follow a guide independently
- **Practical** - Includes working examples and code samples
- **Progressive** - Builds from basic to advanced topics
- **Cross-referenced** - Links to related documentation when relevant

## Prerequisites

Most guides assume you have:
1. Insight Ingenious installed and configured
2. Basic familiarity with the core concepts
3. Access to required external services (where applicable)

If you're new to Insight Ingenious, start with the [Quick Start Guide](../getting-started/README.md).

## Guide Structure

Each guide typically includes:
- **Overview** - What the guide covers
- **Prerequisites** - What you need before starting
- **Step-by-step instructions** - Clear, actionable steps
- **Examples** - Real-world usage examples
- **Troubleshooting** - Common issues and solutions
- **Next steps** - Where to go from here

## Contributing to Guides

Help improve these guides:
- Report issues or unclear instructions
- Suggest additional examples
- Contribute new guides for missing topics
- Update guides when features change

See [CONTRIBUTING.md](../../CONTRIBUTING.md) for contribution guidelines.

## Need Help?

- Check the [Troubleshooting Guide](../getting-started/troubleshooting.md)
- Review the [Configuration Documentation](/getting-started/configuration)
- Ask questions in the project repository
