<!--
SPDX-FileCopyrightText: 2025 Contributors to the OpenSTEF project <short.term.energy.forecasts@alliander.com>

SPDX-License-Identifier: MPL-2.0
-->

# Contributing to OpenSTEF

Thank you for your interest in contributing to OpenSTEF! 🚀

## Quick Start

1. **Read our contributing guide**: [openstef.github.io/openstef/v4/contribute](https://openstef.github.io/openstef/v4/contribute/index.html)
2. **Install dependencies**: `uv sync --group dev`
3. **Make your changes** and ensure all checks pass: `uv run poe all --check`
4. **Submit a pull request**

## Documentation

For information about:

- 🛠️ **Development setup** - Environment setup with uv and modern Python tools
- 🔄 **Development workflow** - Branch naming, commit messages, and PR process  
- 📝 **Documentation guidelines** - Writing docs and examples
- 🧪 **Testing standards** - Writing and running tests
- 📋 **Style guide** - Code formatting and quality standards

**Visit our full contributing guide: [openstef.github.io/openstef/v4/contribute](https://openstef.github.io/openstef/v4/contribute/index.html)**

## Getting Help

- 💬 **Slack**: [LF Energy workspace](https://slack.lfenergy.org/) (#openstef channel)
- 🐛 **Issues**: [GitHub Issues](https://github.com/OpenSTEF/openstef/issues)
- 📧 **Email**: short.term.energy.forecasts@alliander.com
- 📖 **Support**: [Support page](https://openstef.github.io/openstef/v4/project/support.html)

## Good First Issues

New contributors should look for [`good first issue`](https://github.com/OpenSTEF/openstef/labels/good%20first%20issue) labels!
