# SPDX-FileCopyrightText: 2025 Contributors to the OpenSTEF project <short.term.energy.forecasts@alliander.com>
#
# SPDX-License-Identifier: MPL-2.0

"""Utility functions and helpers for OpenSTEF core functionality.

This package provides common utilities used throughout the OpenSTEF core library,
including data serialization helpers, type conversion functions, and other
general-purpose tools.
"""

from openstef_core.utils.datetime import (
    align_datetime,
    align_datetime_to_time,
)
from openstef_core.utils.invariants import (
    not_none,
)
from openstef_core.utils.multiprocessing import (
    run_parallel,
)
from openstef_core.utils.pydantic import (
    timedelta_from_isoformat,
    timedelta_to_isoformat,
)

__all__ = [
    "align_datetime",
    "align_datetime_to_time",
    "not_none",
    "run_parallel",
    "timedelta_from_isoformat",
    "timedelta_to_isoformat",
]
