# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Elastigroup(pulumi.CustomResource):
    availability_zones: pulumi.Output[list]
    """
    List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
    Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
    `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
    """
    block_devices_mode: pulumi.Output[str]
    capacity_unit: pulumi.Output[str]
    """
    The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs.
    """
    cpu_credits: pulumi.Output[str]
    """
    Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
    """
    description: pulumi.Output[str]
    """
    The group description.
    """
    desired_capacity: pulumi.Output[float]
    """
    The desired number of instances the group should have at any time.
    """
    draining_timeout: pulumi.Output[float]
    """
    The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
    """
    ebs_block_devices: pulumi.Output[list]
    ebs_optimized: pulumi.Output[bool]
    """
    Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
    """
    elastic_ips: pulumi.Output[list]
    """
    A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
    """
    elastic_load_balancers: pulumi.Output[list]
    enable_monitoring: pulumi.Output[bool]
    """
    Indicates whether monitoring is enabled for the instance.
    """
    ephemeral_block_devices: pulumi.Output[list]
    fallback_to_ondemand: pulumi.Output[bool]
    """
    In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
    """
    health_check_grace_period: pulumi.Output[float]
    """
    The amount of time, in seconds, after the instance has launched to starts and check its health.
    """
    health_check_type: pulumi.Output[str]
    """
    The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"MLB"`, `"EC2"`, `"MULTAI_TARGET_SET"`, `"MLB_RUNTIME"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
    """
    health_check_unhealthy_duration_before_replacement: pulumi.Output[float]
    """
    The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
    """
    iam_instance_profile: pulumi.Output[str]
    """
    The ARN or name of an IAM instance profile to associate with launched instances.
    """
    image_id: pulumi.Output[str]
    """
    The ID of the AMI used to launch the instance.
    """
    instance_types_ondemand: pulumi.Output[str]
    """
    The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
    """
    instance_types_preferred_spots: pulumi.Output[list]
    """
    Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
    """
    instance_types_spots: pulumi.Output[list]
    """
    One or more instance types.
    """
    instance_types_weights: pulumi.Output[list]
    """
    List of weights per instance type for weighted groups. Each object in the list should have the following attributes:

      * `instanceType` (`str`) - Name of instance type (String).
      * `weight` (`float`) - Weight per instance type (Integer).
    """
    integration_beanstalk: pulumi.Output[dict]
    integration_codedeploy: pulumi.Output[dict]
    integration_docker_swarm: pulumi.Output[dict]
    integration_ecs: pulumi.Output[dict]
    integration_gitlab: pulumi.Output[dict]
    integration_kubernetes: pulumi.Output[dict]
    integration_mesosphere: pulumi.Output[dict]
    integration_multai_runtime: pulumi.Output[dict]
    integration_nomad: pulumi.Output[dict]
    integration_rancher: pulumi.Output[dict]
    integration_route53: pulumi.Output[dict]
    key_name: pulumi.Output[str]
    """
    The key name that should be used for the instance.
    """
    lifetime_period: pulumi.Output[str]
    max_size: pulumi.Output[float]
    """
    The maximum number of instances the group should have at any time.
    """
    min_size: pulumi.Output[float]
    """
    The minimum number of instances the group should have at any time.
    """
    multai_target_sets: pulumi.Output[list]
    name: pulumi.Output[str]
    """
    The group name.
    """
    network_interfaces: pulumi.Output[list]
    ondemand_count: pulumi.Output[float]
    """
    Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
    """
    orientation: pulumi.Output[str]
    """
    Select a prediction strategy. Valid values: `"balanced"`, `"costOriented"`, `"equalAzDistribution"`, `"availabilityOriented"`.    
    """
    persist_block_devices: pulumi.Output[bool]
    persist_private_ip: pulumi.Output[bool]
    persist_root_device: pulumi.Output[bool]
    placement_tenancy: pulumi.Output[str]
    """
    Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used.
    """
    preferred_availability_zones: pulumi.Output[list]
    """
    The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
    Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
    """
    private_ips: pulumi.Output[list]
    product: pulumi.Output[str]
    """
    Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
    For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
    """
    region: pulumi.Output[str]
    """
    The AWS region your group will be created in.
    Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
    """
    revert_to_spot: pulumi.Output[dict]
    """
    Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`

      * `performAt` (`str`) - In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
      * `timeWindows` (`list`) - Specify a list of time windows for to execute revertToSpot strategy. Time window format: `ddd:hh:mm-ddd:hh:mm`. Example: `Mon:03:00-Wed:02:30`
    """
    scaling_down_policies: pulumi.Output[list]
    scaling_strategies: pulumi.Output[list]
    """
    Set termination policy.

      * `terminateAtEndOfBillingHour` (`bool`) - Specify whether to terminate instances at the end of each billing hour.
      * `terminationPolicy` (`str`) - - Determines whether to terminate the newest instances when performing a scaling action. Valid values: `"default"`, `"newestInstance"`.
    """
    scaling_target_policies: pulumi.Output[list]
    scaling_up_policies: pulumi.Output[list]
    scheduled_tasks: pulumi.Output[list]
    security_groups: pulumi.Output[list]
    """
    A list of associated security group IDS.
    """
    shutdown_script: pulumi.Output[str]
    """
    The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
    """
    signals: pulumi.Output[list]
    spot_percentage: pulumi.Output[float]
    """
    The percentage of Spot instances that would spin up from the `desired_capacity` number.
    """
    stateful_deallocation: pulumi.Output[dict]
    subnet_ids: pulumi.Output[list]
    """
    List of Strings of subnet identifiers.
    Note: When this parameter is set, `availability_zones` should be left unused.
    """
    tags: pulumi.Output[list]
    """
    A key/value mapping of tags to assign to the resource.

      * `key` (`str`)
      * `value` (`str`)
    """
    target_group_arns: pulumi.Output[list]
    update_policy: pulumi.Output[dict]
    user_data: pulumi.Output[str]
    """
    The user data to provide when launching the instance.
    """
    utilize_reserved_instances: pulumi.Output[bool]
    """
    In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
    """
    wait_for_capacity: pulumi.Output[float]
    """
    Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
    """
    wait_for_capacity_timeout: pulumi.Output[float]
    """
    Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment. 
    """
    def __init__(__self__, resource_name, opts=None, availability_zones=None, block_devices_mode=None, capacity_unit=None, cpu_credits=None, description=None, desired_capacity=None, draining_timeout=None, ebs_block_devices=None, ebs_optimized=None, elastic_ips=None, elastic_load_balancers=None, enable_monitoring=None, ephemeral_block_devices=None, fallback_to_ondemand=None, health_check_grace_period=None, health_check_type=None, health_check_unhealthy_duration_before_replacement=None, iam_instance_profile=None, image_id=None, instance_types_ondemand=None, instance_types_preferred_spots=None, instance_types_spots=None, instance_types_weights=None, integration_beanstalk=None, integration_codedeploy=None, integration_docker_swarm=None, integration_ecs=None, integration_gitlab=None, integration_kubernetes=None, integration_mesosphere=None, integration_multai_runtime=None, integration_nomad=None, integration_rancher=None, integration_route53=None, key_name=None, lifetime_period=None, max_size=None, min_size=None, multai_target_sets=None, name=None, network_interfaces=None, ondemand_count=None, orientation=None, persist_block_devices=None, persist_private_ip=None, persist_root_device=None, placement_tenancy=None, preferred_availability_zones=None, private_ips=None, product=None, region=None, revert_to_spot=None, scaling_down_policies=None, scaling_strategies=None, scaling_target_policies=None, scaling_up_policies=None, scheduled_tasks=None, security_groups=None, shutdown_script=None, signals=None, spot_percentage=None, stateful_deallocation=None, subnet_ids=None, tags=None, target_group_arns=None, update_policy=None, user_data=None, utilize_reserved_instances=None, wait_for_capacity=None, wait_for_capacity_timeout=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Spotinst AWS group resource.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/elastigroup_aws.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[float] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[list] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[float] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"MLB"`, `"EC2"`, `"MULTAI_TARGET_SET"`, `"MLB_RUNTIME"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[float] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[list] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[list] instance_types_spots: One or more instance types.
        :param pulumi.Input[list] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[float] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `"balanced"`, `"costOriented"`, `"equalAzDistribution"`, `"availabilityOriented"`.    
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used.
        :param pulumi.Input[list] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[dict] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[list] scaling_strategies: Set termination policy.
        :param pulumi.Input[list] security_groups: A list of associated security group IDS.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[float] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[list] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[list] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[float] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[float] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment. 

        The **ebs_block_devices** object supports the following:

          * `deleteOnTermination` (`pulumi.Input[bool]`)
          * `deviceName` (`pulumi.Input[str]`)
          * `encrypted` (`pulumi.Input[bool]`)
          * `iops` (`pulumi.Input[float]`)
          * `kmsKeyId` (`pulumi.Input[str]`)
          * `snapshotId` (`pulumi.Input[str]`)
          * `volumeSize` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)

        The **ephemeral_block_devices** object supports the following:

          * `deviceName` (`pulumi.Input[str]`)
          * `virtualName` (`pulumi.Input[str]`)

        The **instance_types_weights** object supports the following:

          * `instanceType` (`pulumi.Input[str]`) - Name of instance type (String).
          * `weight` (`pulumi.Input[float]`) - Weight per instance type (Integer).

        The **integration_beanstalk** object supports the following:

          * `deployment_preferences` (`pulumi.Input[dict]`)
            * `automaticRoll` (`pulumi.Input[bool]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `strategy` (`pulumi.Input[dict]`)
              * `action` (`pulumi.Input[str]`)
              * `shouldDrainInstances` (`pulumi.Input[bool]`)

          * `environmentId` (`pulumi.Input[str]`)
          * `managed_actions` (`pulumi.Input[dict]`)
            * `platformUpdate` (`pulumi.Input[dict]`)
              * `performAt` (`pulumi.Input[str]`) - In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
              * `timeWindow` (`pulumi.Input[str]`)
              * `updateLevel` (`pulumi.Input[str]`)

        The **integration_codedeploy** object supports the following:

          * `cleanupOnFailure` (`pulumi.Input[bool]`)
          * `deploymentGroups` (`pulumi.Input[list]`)
            * `applicationName` (`pulumi.Input[str]`)
            * `deploymentGroupName` (`pulumi.Input[str]`)

          * `terminateInstanceOnFailure` (`pulumi.Input[bool]`)

        The **integration_docker_swarm** object supports the following:

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_ecs** object supports the following:

          * `autoscaleAttributes` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)
            * `maxScaleDownPercentage` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleScaleDownNonServiceTasks` (`pulumi.Input[bool]`)
          * `cluster_name` (`pulumi.Input[str]`)

        The **integration_gitlab** object supports the following:

          * `runner` (`pulumi.Input[dict]`)
            * `isEnabled` (`pulumi.Input[bool]`)

        The **integration_kubernetes** object supports the following:

          * `apiServer` (`pulumi.Input[str]`)
          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleLabels` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `clusterIdentifier` (`pulumi.Input[str]`)
          * `integrationMode` (`pulumi.Input[str]`)
          * `token` (`pulumi.Input[str]`)

        The **integration_mesosphere** object supports the following:

          * `apiServer` (`pulumi.Input[str]`)

        The **integration_multai_runtime** object supports the following:

          * `deployment_id` (`pulumi.Input[str]`)

        The **integration_nomad** object supports the following:

          * `aclToken` (`pulumi.Input[str]`)
          * `autoscaleConstraints` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_rancher** object supports the following:

          * `accessKey` (`pulumi.Input[str]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `secretKey` (`pulumi.Input[str]`)
          * `version` (`pulumi.Input[str]`)

        The **integration_route53** object supports the following:

          * `domains` (`pulumi.Input[list]`)
            * `hostedZoneId` (`pulumi.Input[str]`)
            * `recordSets` (`pulumi.Input[list]`)
              * `name` (`pulumi.Input[str]`) - The group name.
              * `usePublicIp` (`pulumi.Input[bool]`)

            * `spotinstAcctId` (`pulumi.Input[str]`)

        The **multai_target_sets** object supports the following:

          * `balancer_id` (`pulumi.Input[str]`)
          * `target_set_id` (`pulumi.Input[str]`)

        The **network_interfaces** object supports the following:

          * `associateIpv6Address` (`pulumi.Input[bool]`)
          * `associate_public_ip_address` (`pulumi.Input[bool]`)
          * `deleteOnTermination` (`pulumi.Input[bool]`)
          * `description` (`pulumi.Input[str]`) - The group description.
          * `deviceIndex` (`pulumi.Input[str]`)
          * `networkInterfaceId` (`pulumi.Input[str]`)
          * `privateIpAddress` (`pulumi.Input[str]`)
          * `secondaryPrivateIpAddressCount` (`pulumi.Input[str]`)

        The **revert_to_spot** object supports the following:

          * `performAt` (`pulumi.Input[str]`) - In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
          * `timeWindows` (`pulumi.Input[list]`) - Specify a list of time windows for to execute revertToSpot strategy. Time window format: `ddd:hh:mm-ddd:hh:mm`. Example: `Mon:03:00-Wed:02:30`

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_strategies** object supports the following:

          * `terminateAtEndOfBillingHour` (`pulumi.Input[bool]`) - Specify whether to terminate instances at the end of each billing hour.
          * `terminationPolicy` (`pulumi.Input[str]`) - - Determines whether to terminate the newest instances when performing a scaling action. Valid values: `"default"`, `"newestInstance"`.

        The **scaling_target_policies** object supports the following:

          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `policyName` (`pulumi.Input[str]`)
          * `predictiveMode` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `adjustment` (`pulumi.Input[str]`)
          * `adjustmentPercentage` (`pulumi.Input[str]`)
          * `batchSizePercentage` (`pulumi.Input[str]`)
          * `cronExpression` (`pulumi.Input[str]`)
          * `frequency` (`pulumi.Input[str]`)
          * `grace_period` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `scaleMaxCapacity` (`pulumi.Input[str]`)
          * `scaleMinCapacity` (`pulumi.Input[str]`)
          * `scaleTargetCapacity` (`pulumi.Input[str]`)
          * `startTime` (`pulumi.Input[str]`)
          * `targetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **signals** object supports the following:

          * `name` (`pulumi.Input[str]`) - The group name.
          * `timeout` (`pulumi.Input[float]`)

        The **stateful_deallocation** object supports the following:

          * `shouldDeleteImages` (`pulumi.Input[bool]`)
          * `shouldDeleteNetworkInterfaces` (`pulumi.Input[bool]`)
          * `shouldDeleteSnapshots` (`pulumi.Input[bool]`)
          * `shouldDeleteVolumes` (`pulumi.Input[bool]`)

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)

        The **update_policy** object supports the following:

          * `autoApplyTags` (`pulumi.Input[bool]`)
          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `health_check_type` (`pulumi.Input[str]`) - The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"MLB"`, `"EC2"`, `"MULTAI_TARGET_SET"`, `"MLB_RUNTIME"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
            * `strategy` (`pulumi.Input[dict]`)
              * `action` (`pulumi.Input[str]`)
              * `batchMinHealthyPercentage` (`pulumi.Input[float]`)
              * `shouldDrainInstances` (`pulumi.Input[bool]`)

            * `waitForRollPercentage` (`pulumi.Input[float]`)
            * `waitForRollTimeout` (`pulumi.Input[float]`)

          * `shouldResumeStateful` (`pulumi.Input[bool]`)
          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['availability_zones'] = availability_zones
            __props__['block_devices_mode'] = block_devices_mode
            __props__['capacity_unit'] = capacity_unit
            __props__['cpu_credits'] = cpu_credits
            __props__['description'] = description
            __props__['desired_capacity'] = desired_capacity
            __props__['draining_timeout'] = draining_timeout
            __props__['ebs_block_devices'] = ebs_block_devices
            __props__['ebs_optimized'] = ebs_optimized
            __props__['elastic_ips'] = elastic_ips
            __props__['elastic_load_balancers'] = elastic_load_balancers
            __props__['enable_monitoring'] = enable_monitoring
            __props__['ephemeral_block_devices'] = ephemeral_block_devices
            if fallback_to_ondemand is None:
                raise TypeError("Missing required property 'fallback_to_ondemand'")
            __props__['fallback_to_ondemand'] = fallback_to_ondemand
            __props__['health_check_grace_period'] = health_check_grace_period
            __props__['health_check_type'] = health_check_type
            __props__['health_check_unhealthy_duration_before_replacement'] = health_check_unhealthy_duration_before_replacement
            __props__['iam_instance_profile'] = iam_instance_profile
            __props__['image_id'] = image_id
            if instance_types_ondemand is None:
                raise TypeError("Missing required property 'instance_types_ondemand'")
            __props__['instance_types_ondemand'] = instance_types_ondemand
            __props__['instance_types_preferred_spots'] = instance_types_preferred_spots
            if instance_types_spots is None:
                raise TypeError("Missing required property 'instance_types_spots'")
            __props__['instance_types_spots'] = instance_types_spots
            __props__['instance_types_weights'] = instance_types_weights
            __props__['integration_beanstalk'] = integration_beanstalk
            __props__['integration_codedeploy'] = integration_codedeploy
            __props__['integration_docker_swarm'] = integration_docker_swarm
            __props__['integration_ecs'] = integration_ecs
            __props__['integration_gitlab'] = integration_gitlab
            __props__['integration_kubernetes'] = integration_kubernetes
            __props__['integration_mesosphere'] = integration_mesosphere
            __props__['integration_multai_runtime'] = integration_multai_runtime
            __props__['integration_nomad'] = integration_nomad
            __props__['integration_rancher'] = integration_rancher
            __props__['integration_route53'] = integration_route53
            __props__['key_name'] = key_name
            __props__['lifetime_period'] = lifetime_period
            __props__['max_size'] = max_size
            __props__['min_size'] = min_size
            __props__['multai_target_sets'] = multai_target_sets
            __props__['name'] = name
            __props__['network_interfaces'] = network_interfaces
            __props__['ondemand_count'] = ondemand_count
            if orientation is None:
                raise TypeError("Missing required property 'orientation'")
            __props__['orientation'] = orientation
            __props__['persist_block_devices'] = persist_block_devices
            __props__['persist_private_ip'] = persist_private_ip
            __props__['persist_root_device'] = persist_root_device
            __props__['placement_tenancy'] = placement_tenancy
            __props__['preferred_availability_zones'] = preferred_availability_zones
            __props__['private_ips'] = private_ips
            if product is None:
                raise TypeError("Missing required property 'product'")
            __props__['product'] = product
            __props__['region'] = region
            __props__['revert_to_spot'] = revert_to_spot
            __props__['scaling_down_policies'] = scaling_down_policies
            __props__['scaling_strategies'] = scaling_strategies
            __props__['scaling_target_policies'] = scaling_target_policies
            __props__['scaling_up_policies'] = scaling_up_policies
            __props__['scheduled_tasks'] = scheduled_tasks
            if security_groups is None:
                raise TypeError("Missing required property 'security_groups'")
            __props__['security_groups'] = security_groups
            __props__['shutdown_script'] = shutdown_script
            __props__['signals'] = signals
            __props__['spot_percentage'] = spot_percentage
            __props__['stateful_deallocation'] = stateful_deallocation
            __props__['subnet_ids'] = subnet_ids
            __props__['tags'] = tags
            __props__['target_group_arns'] = target_group_arns
            __props__['update_policy'] = update_policy
            __props__['user_data'] = user_data
            __props__['utilize_reserved_instances'] = utilize_reserved_instances
            __props__['wait_for_capacity'] = wait_for_capacity
            __props__['wait_for_capacity_timeout'] = wait_for_capacity_timeout
        super(Elastigroup, __self__).__init__(
            'spotinst:aws/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, availability_zones=None, block_devices_mode=None, capacity_unit=None, cpu_credits=None, description=None, desired_capacity=None, draining_timeout=None, ebs_block_devices=None, ebs_optimized=None, elastic_ips=None, elastic_load_balancers=None, enable_monitoring=None, ephemeral_block_devices=None, fallback_to_ondemand=None, health_check_grace_period=None, health_check_type=None, health_check_unhealthy_duration_before_replacement=None, iam_instance_profile=None, image_id=None, instance_types_ondemand=None, instance_types_preferred_spots=None, instance_types_spots=None, instance_types_weights=None, integration_beanstalk=None, integration_codedeploy=None, integration_docker_swarm=None, integration_ecs=None, integration_gitlab=None, integration_kubernetes=None, integration_mesosphere=None, integration_multai_runtime=None, integration_nomad=None, integration_rancher=None, integration_route53=None, key_name=None, lifetime_period=None, max_size=None, min_size=None, multai_target_sets=None, name=None, network_interfaces=None, ondemand_count=None, orientation=None, persist_block_devices=None, persist_private_ip=None, persist_root_device=None, placement_tenancy=None, preferred_availability_zones=None, private_ips=None, product=None, region=None, revert_to_spot=None, scaling_down_policies=None, scaling_strategies=None, scaling_target_policies=None, scaling_up_policies=None, scheduled_tasks=None, security_groups=None, shutdown_script=None, signals=None, spot_percentage=None, stateful_deallocation=None, subnet_ids=None, tags=None, target_group_arns=None, update_policy=None, user_data=None, utilize_reserved_instances=None, wait_for_capacity=None, wait_for_capacity_timeout=None):
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] availability_zones: List of Strings of availability zones. When this parameter is set, `subnet_ids` should be left unused.
               Note: `availability_zones` naming syntax follows the convention `availability-zone:subnet:placement-group-name`. For example, to set an AZ in `us-east-1` with subnet `subnet-123456` and placement group `ClusterI03`, you would set:
               `availability_zones = ["us-east-1a:subnet-123456:ClusterI03"]`
        :param pulumi.Input[str] capacity_unit: The capacity unit to launch instances by. If not specified, when choosing the weight unit, each instance will weight as the number of its vCPUs.
        :param pulumi.Input[str] cpu_credits: Controls how T3 instances are launched. Valid values: `standard`, `unlimited`.
        :param pulumi.Input[str] description: The group description.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[float] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable high bandwidth connectivity between instances and AWS’s Elastic Block Store (EBS). For instance types that are EBS-optimized by default this parameter will be ignored.
        :param pulumi.Input[list] elastic_ips: A list of [AWS Elastic IP](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) allocation IDs to associate to the group instances.
        :param pulumi.Input[bool] enable_monitoring: Indicates whether monitoring is enabled for the instance.
        :param pulumi.Input[bool] fallback_to_ondemand: In a case of no Spot instances available, Elastigroup will launch on-demand instances instead.
        :param pulumi.Input[float] health_check_grace_period: The amount of time, in seconds, after the instance has launched to starts and check its health.
        :param pulumi.Input[str] health_check_type: The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"MLB"`, `"EC2"`, `"MULTAI_TARGET_SET"`, `"MLB_RUNTIME"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
        :param pulumi.Input[float] health_check_unhealthy_duration_before_replacement: The amount of time, in seconds, that we will wait before replacing an instance that is running and became unhealthy (this is only applicable for instances that were once healthy).
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: The ID of the AMI used to launch the instance.
        :param pulumi.Input[str] instance_types_ondemand: The type of instance determines your instance's CPU capacity, memory and storage (e.g., m1.small, c1.xlarge).
        :param pulumi.Input[list] instance_types_preferred_spots: Prioritize a subset of spot instance types. Must be a subset of the selected spot instance types.
        :param pulumi.Input[list] instance_types_spots: One or more instance types.
        :param pulumi.Input[list] instance_types_weights: List of weights per instance type for weighted groups. Each object in the list should have the following attributes:
        :param pulumi.Input[str] key_name: The key name that should be used for the instance.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The group name.
        :param pulumi.Input[float] ondemand_count: Number of on demand instances to launch in the group. All other instances will be spot instances. When this parameter is set the `spot_percentage` parameter is being ignored.
        :param pulumi.Input[str] orientation: Select a prediction strategy. Valid values: `"balanced"`, `"costOriented"`, `"equalAzDistribution"`, `"availabilityOriented"`.    
        :param pulumi.Input[str] placement_tenancy: Enable dedicated tenancy. Note: There is a flat hourly fee for each region in which dedicated tenancy is used.
        :param pulumi.Input[list] preferred_availability_zones: The AZs to prioritize when launching Spot instances. If no markets are available in the Preferred AZs, Spot instances are launched in the non-preferred AZs. 
               Note: Must be a sublist of `availability_zones` and `orientation` value must not be `"equalAzDistribution"`.
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux/UNIX"`, `"SUSE Linux"`, `"Windows"`. 
               For EC2 Classic instances:  `"Linux/UNIX (Amazon VPC)"`, `"SUSE Linux (Amazon VPC)"`, `"Windows (Amazon VPC)"`.
        :param pulumi.Input[str] region: The AWS region your group will be created in.
               Note: This parameter is required if you specify subnets (through subnet_ids). This parameter is optional if you specify Availability Zones (through availability_zones).
        :param pulumi.Input[dict] revert_to_spot: Hold settings for strategy correction – replacing On-Demand for Spot instances. Supported Values: `"never"`, `"always"`, `"timeWindow"`
        :param pulumi.Input[list] scaling_strategies: Set termination policy.
        :param pulumi.Input[list] security_groups: A list of associated security group IDS.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[float] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[list] subnet_ids: List of Strings of subnet identifiers.
               Note: When this parameter is set, `availability_zones` should be left unused.
        :param pulumi.Input[list] tags: A key/value mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_data: The user data to provide when launching the instance.
        :param pulumi.Input[bool] utilize_reserved_instances: In a case of any available reserved instances, Elastigroup will utilize them first before purchasing Spot instances.
        :param pulumi.Input[float] wait_for_capacity: Minimum number of instances in a 'HEALTHY' status that is required before continuing. This is ignored when updating with blue/green deployment. Cannot exceed `desired_capacity`.
        :param pulumi.Input[float] wait_for_capacity_timeout: Time (seconds) to wait for instances to report a 'HEALTHY' status. Useful for plans with multiple dependencies that take some time to initialize. Leave undefined or set to `0` to indicate no wait. This is ignored when updating with blue/green deployment. 

        The **ebs_block_devices** object supports the following:

          * `deleteOnTermination` (`pulumi.Input[bool]`)
          * `deviceName` (`pulumi.Input[str]`)
          * `encrypted` (`pulumi.Input[bool]`)
          * `iops` (`pulumi.Input[float]`)
          * `kmsKeyId` (`pulumi.Input[str]`)
          * `snapshotId` (`pulumi.Input[str]`)
          * `volumeSize` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)

        The **ephemeral_block_devices** object supports the following:

          * `deviceName` (`pulumi.Input[str]`)
          * `virtualName` (`pulumi.Input[str]`)

        The **instance_types_weights** object supports the following:

          * `instanceType` (`pulumi.Input[str]`) - Name of instance type (String).
          * `weight` (`pulumi.Input[float]`) - Weight per instance type (Integer).

        The **integration_beanstalk** object supports the following:

          * `deployment_preferences` (`pulumi.Input[dict]`)
            * `automaticRoll` (`pulumi.Input[bool]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `strategy` (`pulumi.Input[dict]`)
              * `action` (`pulumi.Input[str]`)
              * `shouldDrainInstances` (`pulumi.Input[bool]`)

          * `environmentId` (`pulumi.Input[str]`)
          * `managed_actions` (`pulumi.Input[dict]`)
            * `platformUpdate` (`pulumi.Input[dict]`)
              * `performAt` (`pulumi.Input[str]`) - In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
              * `timeWindow` (`pulumi.Input[str]`)
              * `updateLevel` (`pulumi.Input[str]`)

        The **integration_codedeploy** object supports the following:

          * `cleanupOnFailure` (`pulumi.Input[bool]`)
          * `deploymentGroups` (`pulumi.Input[list]`)
            * `applicationName` (`pulumi.Input[str]`)
            * `deploymentGroupName` (`pulumi.Input[str]`)

          * `terminateInstanceOnFailure` (`pulumi.Input[bool]`)

        The **integration_docker_swarm** object supports the following:

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_ecs** object supports the following:

          * `autoscaleAttributes` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)
            * `maxScaleDownPercentage` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleScaleDownNonServiceTasks` (`pulumi.Input[bool]`)
          * `cluster_name` (`pulumi.Input[str]`)

        The **integration_gitlab** object supports the following:

          * `runner` (`pulumi.Input[dict]`)
            * `isEnabled` (`pulumi.Input[bool]`)

        The **integration_kubernetes** object supports the following:

          * `apiServer` (`pulumi.Input[str]`)
          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleLabels` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `clusterIdentifier` (`pulumi.Input[str]`)
          * `integrationMode` (`pulumi.Input[str]`)
          * `token` (`pulumi.Input[str]`)

        The **integration_mesosphere** object supports the following:

          * `apiServer` (`pulumi.Input[str]`)

        The **integration_multai_runtime** object supports the following:

          * `deployment_id` (`pulumi.Input[str]`)

        The **integration_nomad** object supports the following:

          * `aclToken` (`pulumi.Input[str]`)
          * `autoscaleConstraints` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`)
            * `value` (`pulumi.Input[str]`)

          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_rancher** object supports the following:

          * `accessKey` (`pulumi.Input[str]`)
          * `masterHost` (`pulumi.Input[str]`)
          * `secretKey` (`pulumi.Input[str]`)
          * `version` (`pulumi.Input[str]`)

        The **integration_route53** object supports the following:

          * `domains` (`pulumi.Input[list]`)
            * `hostedZoneId` (`pulumi.Input[str]`)
            * `recordSets` (`pulumi.Input[list]`)
              * `name` (`pulumi.Input[str]`) - The group name.
              * `usePublicIp` (`pulumi.Input[bool]`)

            * `spotinstAcctId` (`pulumi.Input[str]`)

        The **multai_target_sets** object supports the following:

          * `balancer_id` (`pulumi.Input[str]`)
          * `target_set_id` (`pulumi.Input[str]`)

        The **network_interfaces** object supports the following:

          * `associateIpv6Address` (`pulumi.Input[bool]`)
          * `associate_public_ip_address` (`pulumi.Input[bool]`)
          * `deleteOnTermination` (`pulumi.Input[bool]`)
          * `description` (`pulumi.Input[str]`) - The group description.
          * `deviceIndex` (`pulumi.Input[str]`)
          * `networkInterfaceId` (`pulumi.Input[str]`)
          * `privateIpAddress` (`pulumi.Input[str]`)
          * `secondaryPrivateIpAddressCount` (`pulumi.Input[str]`)

        The **revert_to_spot** object supports the following:

          * `performAt` (`pulumi.Input[str]`) - In the event of a fallback to On-Demand instances, select the time period to revert back to Spot. Supported Arguments – always (default), timeWindow, never. For timeWindow or never to be valid the group must have availabilityOriented OR persistence defined.
          * `timeWindows` (`pulumi.Input[list]`) - Specify a list of time windows for to execute revertToSpot strategy. Time window format: `ddd:hh:mm-ddd:hh:mm`. Example: `Mon:03:00-Wed:02:30`

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_strategies** object supports the following:

          * `terminateAtEndOfBillingHour` (`pulumi.Input[bool]`) - Specify whether to terminate instances at the end of each billing hour.
          * `terminationPolicy` (`pulumi.Input[str]`) - - Determines whether to terminate the newest instances when performing a scaling action. Valid values: `"default"`, `"newestInstance"`.

        The **scaling_target_policies** object supports the following:

          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `policyName` (`pulumi.Input[str]`)
          * `predictiveMode` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `adjustment` (`pulumi.Input[str]`)
          * `adjustmentPercentage` (`pulumi.Input[str]`)
          * `batchSizePercentage` (`pulumi.Input[str]`)
          * `cronExpression` (`pulumi.Input[str]`)
          * `frequency` (`pulumi.Input[str]`)
          * `grace_period` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `scaleMaxCapacity` (`pulumi.Input[str]`)
          * `scaleMinCapacity` (`pulumi.Input[str]`)
          * `scaleTargetCapacity` (`pulumi.Input[str]`)
          * `startTime` (`pulumi.Input[str]`)
          * `targetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **signals** object supports the following:

          * `name` (`pulumi.Input[str]`) - The group name.
          * `timeout` (`pulumi.Input[float]`)

        The **stateful_deallocation** object supports the following:

          * `shouldDeleteImages` (`pulumi.Input[bool]`)
          * `shouldDeleteNetworkInterfaces` (`pulumi.Input[bool]`)
          * `shouldDeleteSnapshots` (`pulumi.Input[bool]`)
          * `shouldDeleteVolumes` (`pulumi.Input[bool]`)

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)

        The **update_policy** object supports the following:

          * `autoApplyTags` (`pulumi.Input[bool]`)
          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `health_check_type` (`pulumi.Input[str]`) - The service that will perform health checks for the instance. Valid values: `"ELB"`, `"HCS"`, `"TARGET_GROUP"`, `"MLB"`, `"EC2"`, `"MULTAI_TARGET_SET"`, `"MLB_RUNTIME"`, `"K8S_NODE"`, `"NOMAD_NODE"`, `"ECS_CLUSTER_INSTANCE"`.
            * `strategy` (`pulumi.Input[dict]`)
              * `action` (`pulumi.Input[str]`)
              * `batchMinHealthyPercentage` (`pulumi.Input[float]`)
              * `shouldDrainInstances` (`pulumi.Input[bool]`)

            * `waitForRollPercentage` (`pulumi.Input[float]`)
            * `waitForRollTimeout` (`pulumi.Input[float]`)

          * `shouldResumeStateful` (`pulumi.Input[bool]`)
          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["availability_zones"] = availability_zones
        __props__["block_devices_mode"] = block_devices_mode
        __props__["capacity_unit"] = capacity_unit
        __props__["cpu_credits"] = cpu_credits
        __props__["description"] = description
        __props__["desired_capacity"] = desired_capacity
        __props__["draining_timeout"] = draining_timeout
        __props__["ebs_block_devices"] = ebs_block_devices
        __props__["ebs_optimized"] = ebs_optimized
        __props__["elastic_ips"] = elastic_ips
        __props__["elastic_load_balancers"] = elastic_load_balancers
        __props__["enable_monitoring"] = enable_monitoring
        __props__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__["health_check_grace_period"] = health_check_grace_period
        __props__["health_check_type"] = health_check_type
        __props__["health_check_unhealthy_duration_before_replacement"] = health_check_unhealthy_duration_before_replacement
        __props__["iam_instance_profile"] = iam_instance_profile
        __props__["image_id"] = image_id
        __props__["instance_types_ondemand"] = instance_types_ondemand
        __props__["instance_types_preferred_spots"] = instance_types_preferred_spots
        __props__["instance_types_spots"] = instance_types_spots
        __props__["instance_types_weights"] = instance_types_weights
        __props__["integration_beanstalk"] = integration_beanstalk
        __props__["integration_codedeploy"] = integration_codedeploy
        __props__["integration_docker_swarm"] = integration_docker_swarm
        __props__["integration_ecs"] = integration_ecs
        __props__["integration_gitlab"] = integration_gitlab
        __props__["integration_kubernetes"] = integration_kubernetes
        __props__["integration_mesosphere"] = integration_mesosphere
        __props__["integration_multai_runtime"] = integration_multai_runtime
        __props__["integration_nomad"] = integration_nomad
        __props__["integration_rancher"] = integration_rancher
        __props__["integration_route53"] = integration_route53
        __props__["key_name"] = key_name
        __props__["lifetime_period"] = lifetime_period
        __props__["max_size"] = max_size
        __props__["min_size"] = min_size
        __props__["multai_target_sets"] = multai_target_sets
        __props__["name"] = name
        __props__["network_interfaces"] = network_interfaces
        __props__["ondemand_count"] = ondemand_count
        __props__["orientation"] = orientation
        __props__["persist_block_devices"] = persist_block_devices
        __props__["persist_private_ip"] = persist_private_ip
        __props__["persist_root_device"] = persist_root_device
        __props__["placement_tenancy"] = placement_tenancy
        __props__["preferred_availability_zones"] = preferred_availability_zones
        __props__["private_ips"] = private_ips
        __props__["product"] = product
        __props__["region"] = region
        __props__["revert_to_spot"] = revert_to_spot
        __props__["scaling_down_policies"] = scaling_down_policies
        __props__["scaling_strategies"] = scaling_strategies
        __props__["scaling_target_policies"] = scaling_target_policies
        __props__["scaling_up_policies"] = scaling_up_policies
        __props__["scheduled_tasks"] = scheduled_tasks
        __props__["security_groups"] = security_groups
        __props__["shutdown_script"] = shutdown_script
        __props__["signals"] = signals
        __props__["spot_percentage"] = spot_percentage
        __props__["stateful_deallocation"] = stateful_deallocation
        __props__["subnet_ids"] = subnet_ids
        __props__["tags"] = tags
        __props__["target_group_arns"] = target_group_arns
        __props__["update_policy"] = update_policy
        __props__["user_data"] = user_data
        __props__["utilize_reserved_instances"] = utilize_reserved_instances
        __props__["wait_for_capacity"] = wait_for_capacity
        __props__["wait_for_capacity_timeout"] = wait_for_capacity_timeout
        return Elastigroup(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

