# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class MrScalar(pulumi.CustomResource):
    additional_info: pulumi.Output[str]
    additional_primary_security_groups: pulumi.Output[list]
    additional_replica_security_groups: pulumi.Output[list]
    applications: pulumi.Output[list]
    availability_zones: pulumi.Output[list]
    bootstrap_actions_files: pulumi.Output[list]
    cluster_id: pulumi.Output[str]
    """
    The MrScaler cluster id.
    """
    configurations_files: pulumi.Output[list]
    core_desired_capacity: pulumi.Output[float]
    core_ebs_block_devices: pulumi.Output[list]
    core_ebs_optimized: pulumi.Output[bool]
    core_instance_types: pulumi.Output[list]
    core_lifecycle: pulumi.Output[str]
    core_max_size: pulumi.Output[float]
    core_min_size: pulumi.Output[float]
    core_scaling_down_policies: pulumi.Output[list]
    core_scaling_up_policies: pulumi.Output[list]
    custom_ami_id: pulumi.Output[str]
    description: pulumi.Output[str]
    """
    The MrScaler description.
    """
    ebs_root_volume_size: pulumi.Output[float]
    ec2_key_name: pulumi.Output[str]
    expose_cluster_id: pulumi.Output[bool]
    instance_weights: pulumi.Output[list]
    job_flow_role: pulumi.Output[str]
    keep_job_flow_alive: pulumi.Output[bool]
    log_uri: pulumi.Output[str]
    managed_primary_security_group: pulumi.Output[str]
    managed_replica_security_group: pulumi.Output[str]
    master_ebs_block_devices: pulumi.Output[list]
    master_ebs_optimized: pulumi.Output[bool]
    master_instance_types: pulumi.Output[list]
    master_lifecycle: pulumi.Output[str]
    name: pulumi.Output[str]
    """
    The MrScaler name.
    """
    output_cluster_id: pulumi.Output[str]
    provisioning_timeout: pulumi.Output[dict]
    region: pulumi.Output[str]
    """
    The MrScaler region.
    """
    release_label: pulumi.Output[str]
    repo_upgrade_on_boot: pulumi.Output[str]
    retries: pulumi.Output[float]
    scheduled_tasks: pulumi.Output[list]
    security_config: pulumi.Output[str]
    service_access_security_group: pulumi.Output[str]
    service_role: pulumi.Output[str]
    steps_files: pulumi.Output[list]
    strategy: pulumi.Output[str]
    """
    The MrScaler strategy. Allowed values are `new` `clone` and `wrap`.
    """
    tags: pulumi.Output[list]
    task_desired_capacity: pulumi.Output[float]
    task_ebs_block_devices: pulumi.Output[list]
    task_ebs_optimized: pulumi.Output[bool]
    task_instance_types: pulumi.Output[list]
    task_lifecycle: pulumi.Output[str]
    task_max_size: pulumi.Output[float]
    task_min_size: pulumi.Output[float]
    task_scaling_down_policies: pulumi.Output[list]
    task_scaling_up_policies: pulumi.Output[list]
    termination_protected: pulumi.Output[bool]
    visible_to_all_users: pulumi.Output[bool]
    def __init__(__self__, resource_name, opts=None, additional_info=None, additional_primary_security_groups=None, additional_replica_security_groups=None, applications=None, availability_zones=None, bootstrap_actions_files=None, cluster_id=None, configurations_files=None, core_desired_capacity=None, core_ebs_block_devices=None, core_ebs_optimized=None, core_instance_types=None, core_lifecycle=None, core_max_size=None, core_min_size=None, core_scaling_down_policies=None, core_scaling_up_policies=None, custom_ami_id=None, description=None, ebs_root_volume_size=None, ec2_key_name=None, expose_cluster_id=None, instance_weights=None, job_flow_role=None, keep_job_flow_alive=None, log_uri=None, managed_primary_security_group=None, managed_replica_security_group=None, master_ebs_block_devices=None, master_ebs_optimized=None, master_instance_types=None, master_lifecycle=None, name=None, provisioning_timeout=None, region=None, release_label=None, repo_upgrade_on_boot=None, retries=None, scheduled_tasks=None, security_config=None, service_access_security_group=None, service_role=None, steps_files=None, strategy=None, tags=None, task_desired_capacity=None, task_ebs_block_devices=None, task_ebs_optimized=None, task_instance_types=None, task_lifecycle=None, task_max_size=None, task_min_size=None, task_scaling_down_policies=None, task_scaling_up_policies=None, termination_protected=None, visible_to_all_users=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Spotinst AWS MrScaler resource.

        ## Provisioning Timeout (Clone, New strategies)

        * `timeout` - (Optional) The amount of time (minutes) after which the cluster is automatically terminated if it's still in provisioning status. Minimum: '15'.
        * `timeout_action` - (Optional) The action to take if the timeout is exceeded. Valid values: `terminate`, `terminateAndRetry`.

        <a id="cluster-config"></a>
        ## Cluster Configuration (New strategy only)

        * `log_uri` - (Optional) The path to the Amazon S3 location where logs for this cluster are stored.
        * `additional_info` - (Optional) This is meta information about third-party applications that third-party vendors use for testing purposes.
        * `security_config` - (Optional) The name of the security configuration applied to the cluster.
        * `service_role` - (Optional) The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
        * `job_flow_role` - (Optional) The IAM role that was specified when the job flow was launched. The EC2 instances of the job flow assume this role.
        * `termination_protected` - (Optional) Specifies whether the Amazon EC2 instances in the cluster are protected from termination by API calls, user intervention, or in the event of a job-flow error.
        * `keep_job_flow_alive` - (Optional) Specifies whether the cluster should remain available after completing all steps.

        <a id="task-group"></a>
        ## Task Group (Wrap, Clone, and New strategies)

        * `task_instance_types` - (Required) The MrScaler instance types for the task nodes.
        * `task_target` - (Required) amount of instances in task group.
        * `task_maximum` - (Optional) maximal amount of instances in task group.
        * `task_minimum` - (Optional) The minimal amount of instances in task group.
        * `task_lifecycle` - (Required) The MrScaler lifecycle for instances in task group. Allowed values are 'SPOT' and 'ON_DEMAND'.
        * `task_ebs_optimized` - (Optional) EBS Optimization setting for instances in group.
        * `task_ebs_block_device` - (Required) This determines the ebs configuration for your task group instances. Only a single block is allowed.
            * `volumes_per_instance` - (Optional; Default 1) Amount of volumes per instance in the task group.
            * `volume_type` - (Required) volume type. Allowed values are 'gp2', 'io1' and others.
            * `size_in_gb` - (Required) Size of the volume, in GBs.
            * `iops` - (Optional) IOPS for the volume. Required in some volume types, such as io1.

        <a id="core-group"></a>
        ## Core Group (Clone, New strategies)

        * `core_instance_types` - (Required) The MrScaler instance types for the core nodes.
        * `core_target` - (Required) amount of instances in core group.
        * `core_maximum` - (Optional) maximal amount of instances in core group.
        * `core_minimum` - (Optional) The minimal amount of instances in core group.
        * `core_lifecycle` - (Required) The MrScaler lifecycle for instances in core group. Allowed values are 'SPOT' and 'ON_DEMAND'.
        * `core_ebs_optimized` - (Optional) EBS Optimization setting for instances in group.
        * `core_ebs_block_device` - (Required) This determines the ebs configuration for your core group instances. Only a single block is allowed.
            * `volumes_per_instance` - (Optional; Default 1) Amount of volumes per instance in the core group.
            * `volume_type` - (Required) volume type. Allowed values are 'gp2', 'io1' and others.
            * `size_in_gb` - (Required) Size of the volume, in GBs.
            * `iops` - (Optional) IOPS for the volume. Required in some volume types, such as io1.

        <a id="master-group"></a>
        ## Master Group (Clone, New strategies)

        * `master_instance_types` - (Required) The MrScaler instance types for the master nodes.
        * `master_lifecycle` - (Required) The MrScaler lifecycle for instances in master group. Allowed values are 'SPOT' and 'ON_DEMAND'.
        * `master_ebs_optimized` - (Optional) EBS Optimization setting for instances in group.
        * `master_ebs_block_device` - (Required) This determines the ebs configuration for your master group instances. Only a single block is allowed.
            * `volumes_per_instance` - (Optional; Default 1) Amount of volumes per instance in the master group.
            * `volume_type` - (Required) volume type. Allowed values are 'gp2', 'io1' and others.
            * `size_in_gb` - (Required) Size of the volume, in GBs.
            * `iops` - (Optional) IOPS for the volume. Required in some volume types, such as io1.

        <a id="tags"></a>
        ## Tags (Clone, New strategies)

        * `tags` - (Optional) A list of tags to assign to the resource. You may define multiple tags.
            * `key` - (Required) Tag key.
            * `value` - (Required) Tag value.

        <a id="Optional Compute Parameters"></a>  
        ## Optional Compute Parameters (New strategy)

        * `managed_primary_security_group` - (Optional) EMR Managed Security group that will be set to the primary instance group.
        * `managed_replica_security_group` - (Optional) EMR Managed Security group that will be set to the replica instance group.
        * `service_access_security_group` - (Optional) The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
        * `additional_primary_security_groups` - (Optional) A list of additional Amazon EC2 security group IDs for the master node.
        * `additional_replica_security_groups` - (Optional) A list of additional Amazon EC2 security group IDs for the core and task nodes.
        * `custom_ami_id` - (Optional) The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
        * `repo_upgrade_on_boot` - (Optional) Applies only when `custom_ami_id` is used. Specifies the type of updates that are applied from the Amazon Linux AMI package repositories when an instance boots using the AMI. Possible values include: `SECURITY`, `NONE`.
        * `ec2_key_name` - (Optional) The name of an Amazon EC2 key pair that can be used to ssh to the master node.
        * `applications` - (Optional) A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster
            * `args` - (Optional) Arguments for EMR to pass to the application.
            * `name` - (Required) The application name.
            * `version`- (Optional)T he version of the application.
        * `instance_weights` - (Optional) Describes the instance and weights. Check out [Elastigroup Weighted Instances](https://api.spotinst.com/elastigroup-for-aws/concepts/general-concepts/elastigroup-capacity-instances-or-weighted) for more info.
            * `instance_type` - (Required) The type of the instance.
            * `weighted_capacity` - (Required) The weight given to the associated instance type. 

        <a id="availability-zone"></a>
        ## Availability Zones (Clone, New strategies)

        * `availability_zones` - (Required in Clone) List of AZs and their subnet Ids. See example above for usage.

        <a id="configurations"></a>
        ## Configurations (Clone, New strategies)

        * `configurations_file` - (Optional) Describes path to S3 file containing description of configurations. [More Information](https://api.spotinst.com/elastigroup-for-aws/services-integrations/elastic-mapreduce/import-an-emr-cluster/advanced/)
            * `bucket` - (Required) S3 Bucket name for configurations.
            * `key`- (Required) S3 key for configurations.
            
        <a id="steps"></a>
        ## Steps (Clone, New strategies)

        * `steps_file` - (Optional) Steps from S3.
            * `bucket` - (Required) S3 Bucket name for steps.
            * `key`- (Required) S3 key for steps.
            
        <a id="boostrap-actions"></a>
        ## Bootstrap Actions (Clone, New strategies)   

        * `bootstrap_actions_file` - (Optional) Describes path to S3 file containing description of bootstrap actions. [More Information](https://api.spotinst.com/elastigroup-for-aws/services-integrations/elastic-mapreduce/import-an-emr-cluster/advanced/)
            * `bucket` - (Required) S3 Bucket name for bootstrap actions.
            * `key`- (Required) S3 key for bootstrap actions.

        <a id="scaling-policy"></a>
        ## Scaling Policies

        Possible task group scaling policies (Wrap, Clone, and New strategies):
        * `task_scaling_up_policy`
        * `task_scaling_down_policy`

        Possible core group scaling policies (Clone, New strategies):
        * `core_scaling_up_policy`
        * `core_scaling_down_policy`

        Each `*_scaling_*_policy` supports the following:

        * `policy_name` - (Required) The name of the policy.
        * `metric_name` - (Required) The name of the metric, with or without spaces.
        * `statistic` - (Required) The metric statistics to return. For information about specific statistics go to [Statistics](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/index.html?CHAP_TerminologyandKeyConcepts.html#Statistic) in the Amazon CloudWatch Developer Guide.
        * `unit` - (Required) The unit for the metric.
        * `threshold` - (Required) The value against which the specified statistic is compared.
        * `adjustment` - (Optional) The number of instances to add/remove to/from the target capacity when scale is needed.
        * `min_target_capacity` - (Optional) Min target capacity for scale up.
        * `max_target_capacity` - (Optional) Max target capacity for scale down.
        * `namespace` - (Required) The namespace for the metric.
        * `operator` - (Required) The operator to use. Allowed values are : 'gt', 'gte', 'lt' , 'lte'.
        * `evaluation_periods` - (Required) The number of periods over which data is compared to the specified threshold.
        * `period` - (Required) The granularity, in seconds, of the returned datapoints. Period must be at least 60 seconds and must be a multiple of 60.
        * `cooldown` - (Required) The amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
        * `dimensions` - (Optional) A mapping of dimensions describing qualities of the metric.
        * `minimum` - (Optional) The minimum to set when scale is needed.
        * `maximum` - (Optional) The maximum to set when scale is needed.
        * `target` - (Optional) The number of instances to set when scale is needed.
        * `action_type` - (Required) The type of action to perform. Allowed values are : 'adjustment', 'setMinTarget', 'setMaxTarget', 'updateCapacity', 'percentageAdjustment'

        <a id="scheduled-task"></a>
        ## Scheduled Tasks

        * `scheduled_task` - (Optional) An array of scheduled tasks.
        * `is_enabled` - (Optional) Enable/Disable the specified scheduling task.
        * `task_type` - (Required) The type of task to be scheduled. Valid values: `setCapacity`.
        * `instance_group_type` - (Required) Select the EMR instance groups to execute the scheduled task on. Valid values: `task`.
        * `cron` - (Required) A cron expression representing the schedule for the task.
        * `desired_capacity` - (Optional) New desired capacity for the elastigroup.
        * `min_capacity` - (Optional) New min capacity for the elastigroup.
        * `max_capacity` - (Optional) New max capacity for the elastigroup.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/mrscaler_aws.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The MrScaler cluster id.
        :param pulumi.Input[str] description: The MrScaler description.
        :param pulumi.Input[str] name: The MrScaler name.
        :param pulumi.Input[str] region: The MrScaler region.
        :param pulumi.Input[str] strategy: The MrScaler strategy. Allowed values are `new` `clone` and `wrap`.

        The **applications** object supports the following:

          * `args` (`pulumi.Input[list]`)
          * `name` (`pulumi.Input[str]`) - The MrScaler name.
          * `version` (`pulumi.Input[str]`)

        The **bootstrap_actions_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **configurations_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **core_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **core_scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **core_scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **instance_weights** object supports the following:

          * `instanceType` (`pulumi.Input[str]`)
          * `weightedCapacity` (`pulumi.Input[float]`)

        The **master_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **provisioning_timeout** object supports the following:

          * `timeout` (`pulumi.Input[float]`)
          * `timeoutAction` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `cron` (`pulumi.Input[str]`)
          * `desired_capacity` (`pulumi.Input[str]`)
          * `instanceGroupType` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **steps_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)

        The **task_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **task_scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **task_scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_info'] = additional_info
            __props__['additional_primary_security_groups'] = additional_primary_security_groups
            __props__['additional_replica_security_groups'] = additional_replica_security_groups
            __props__['applications'] = applications
            __props__['availability_zones'] = availability_zones
            __props__['bootstrap_actions_files'] = bootstrap_actions_files
            __props__['cluster_id'] = cluster_id
            __props__['configurations_files'] = configurations_files
            __props__['core_desired_capacity'] = core_desired_capacity
            __props__['core_ebs_block_devices'] = core_ebs_block_devices
            __props__['core_ebs_optimized'] = core_ebs_optimized
            __props__['core_instance_types'] = core_instance_types
            __props__['core_lifecycle'] = core_lifecycle
            __props__['core_max_size'] = core_max_size
            __props__['core_min_size'] = core_min_size
            __props__['core_scaling_down_policies'] = core_scaling_down_policies
            __props__['core_scaling_up_policies'] = core_scaling_up_policies
            __props__['custom_ami_id'] = custom_ami_id
            __props__['description'] = description
            __props__['ebs_root_volume_size'] = ebs_root_volume_size
            __props__['ec2_key_name'] = ec2_key_name
            __props__['expose_cluster_id'] = expose_cluster_id
            __props__['instance_weights'] = instance_weights
            __props__['job_flow_role'] = job_flow_role
            __props__['keep_job_flow_alive'] = keep_job_flow_alive
            __props__['log_uri'] = log_uri
            __props__['managed_primary_security_group'] = managed_primary_security_group
            __props__['managed_replica_security_group'] = managed_replica_security_group
            __props__['master_ebs_block_devices'] = master_ebs_block_devices
            __props__['master_ebs_optimized'] = master_ebs_optimized
            __props__['master_instance_types'] = master_instance_types
            __props__['master_lifecycle'] = master_lifecycle
            __props__['name'] = name
            __props__['provisioning_timeout'] = provisioning_timeout
            __props__['region'] = region
            __props__['release_label'] = release_label
            __props__['repo_upgrade_on_boot'] = repo_upgrade_on_boot
            __props__['retries'] = retries
            __props__['scheduled_tasks'] = scheduled_tasks
            __props__['security_config'] = security_config
            __props__['service_access_security_group'] = service_access_security_group
            __props__['service_role'] = service_role
            __props__['steps_files'] = steps_files
            if strategy is None:
                raise TypeError("Missing required property 'strategy'")
            __props__['strategy'] = strategy
            __props__['tags'] = tags
            __props__['task_desired_capacity'] = task_desired_capacity
            __props__['task_ebs_block_devices'] = task_ebs_block_devices
            __props__['task_ebs_optimized'] = task_ebs_optimized
            __props__['task_instance_types'] = task_instance_types
            __props__['task_lifecycle'] = task_lifecycle
            __props__['task_max_size'] = task_max_size
            __props__['task_min_size'] = task_min_size
            __props__['task_scaling_down_policies'] = task_scaling_down_policies
            __props__['task_scaling_up_policies'] = task_scaling_up_policies
            __props__['termination_protected'] = termination_protected
            __props__['visible_to_all_users'] = visible_to_all_users
            __props__['output_cluster_id'] = None
        super(MrScalar, __self__).__init__(
            'spotinst:aws/mrScalar:MrScalar',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, additional_info=None, additional_primary_security_groups=None, additional_replica_security_groups=None, applications=None, availability_zones=None, bootstrap_actions_files=None, cluster_id=None, configurations_files=None, core_desired_capacity=None, core_ebs_block_devices=None, core_ebs_optimized=None, core_instance_types=None, core_lifecycle=None, core_max_size=None, core_min_size=None, core_scaling_down_policies=None, core_scaling_up_policies=None, custom_ami_id=None, description=None, ebs_root_volume_size=None, ec2_key_name=None, expose_cluster_id=None, instance_weights=None, job_flow_role=None, keep_job_flow_alive=None, log_uri=None, managed_primary_security_group=None, managed_replica_security_group=None, master_ebs_block_devices=None, master_ebs_optimized=None, master_instance_types=None, master_lifecycle=None, name=None, output_cluster_id=None, provisioning_timeout=None, region=None, release_label=None, repo_upgrade_on_boot=None, retries=None, scheduled_tasks=None, security_config=None, service_access_security_group=None, service_role=None, steps_files=None, strategy=None, tags=None, task_desired_capacity=None, task_ebs_block_devices=None, task_ebs_optimized=None, task_instance_types=None, task_lifecycle=None, task_max_size=None, task_min_size=None, task_scaling_down_policies=None, task_scaling_up_policies=None, termination_protected=None, visible_to_all_users=None):
        """
        Get an existing MrScalar resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The MrScaler cluster id.
        :param pulumi.Input[str] description: The MrScaler description.
        :param pulumi.Input[str] name: The MrScaler name.
        :param pulumi.Input[str] region: The MrScaler region.
        :param pulumi.Input[str] strategy: The MrScaler strategy. Allowed values are `new` `clone` and `wrap`.

        The **applications** object supports the following:

          * `args` (`pulumi.Input[list]`)
          * `name` (`pulumi.Input[str]`) - The MrScaler name.
          * `version` (`pulumi.Input[str]`)

        The **bootstrap_actions_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **configurations_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **core_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **core_scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **core_scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **instance_weights** object supports the following:

          * `instanceType` (`pulumi.Input[str]`)
          * `weightedCapacity` (`pulumi.Input[float]`)

        The **master_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **provisioning_timeout** object supports the following:

          * `timeout` (`pulumi.Input[float]`)
          * `timeoutAction` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `cron` (`pulumi.Input[str]`)
          * `desired_capacity` (`pulumi.Input[str]`)
          * `instanceGroupType` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **steps_files** object supports the following:

          * `bucket` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`)
          * `value` (`pulumi.Input[str]`)

        The **task_ebs_block_devices** object supports the following:

          * `iops` (`pulumi.Input[float]`)
          * `sizeInGb` (`pulumi.Input[float]`)
          * `volumeType` (`pulumi.Input[str]`)
          * `volumesPerInstance` (`pulumi.Input[float]`)

        The **task_scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **task_scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[dict]`)
          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_info"] = additional_info
        __props__["additional_primary_security_groups"] = additional_primary_security_groups
        __props__["additional_replica_security_groups"] = additional_replica_security_groups
        __props__["applications"] = applications
        __props__["availability_zones"] = availability_zones
        __props__["bootstrap_actions_files"] = bootstrap_actions_files
        __props__["cluster_id"] = cluster_id
        __props__["configurations_files"] = configurations_files
        __props__["core_desired_capacity"] = core_desired_capacity
        __props__["core_ebs_block_devices"] = core_ebs_block_devices
        __props__["core_ebs_optimized"] = core_ebs_optimized
        __props__["core_instance_types"] = core_instance_types
        __props__["core_lifecycle"] = core_lifecycle
        __props__["core_max_size"] = core_max_size
        __props__["core_min_size"] = core_min_size
        __props__["core_scaling_down_policies"] = core_scaling_down_policies
        __props__["core_scaling_up_policies"] = core_scaling_up_policies
        __props__["custom_ami_id"] = custom_ami_id
        __props__["description"] = description
        __props__["ebs_root_volume_size"] = ebs_root_volume_size
        __props__["ec2_key_name"] = ec2_key_name
        __props__["expose_cluster_id"] = expose_cluster_id
        __props__["instance_weights"] = instance_weights
        __props__["job_flow_role"] = job_flow_role
        __props__["keep_job_flow_alive"] = keep_job_flow_alive
        __props__["log_uri"] = log_uri
        __props__["managed_primary_security_group"] = managed_primary_security_group
        __props__["managed_replica_security_group"] = managed_replica_security_group
        __props__["master_ebs_block_devices"] = master_ebs_block_devices
        __props__["master_ebs_optimized"] = master_ebs_optimized
        __props__["master_instance_types"] = master_instance_types
        __props__["master_lifecycle"] = master_lifecycle
        __props__["name"] = name
        __props__["output_cluster_id"] = output_cluster_id
        __props__["provisioning_timeout"] = provisioning_timeout
        __props__["region"] = region
        __props__["release_label"] = release_label
        __props__["repo_upgrade_on_boot"] = repo_upgrade_on_boot
        __props__["retries"] = retries
        __props__["scheduled_tasks"] = scheduled_tasks
        __props__["security_config"] = security_config
        __props__["service_access_security_group"] = service_access_security_group
        __props__["service_role"] = service_role
        __props__["steps_files"] = steps_files
        __props__["strategy"] = strategy
        __props__["tags"] = tags
        __props__["task_desired_capacity"] = task_desired_capacity
        __props__["task_ebs_block_devices"] = task_ebs_block_devices
        __props__["task_ebs_optimized"] = task_ebs_optimized
        __props__["task_instance_types"] = task_instance_types
        __props__["task_lifecycle"] = task_lifecycle
        __props__["task_max_size"] = task_max_size
        __props__["task_min_size"] = task_min_size
        __props__["task_scaling_down_policies"] = task_scaling_down_policies
        __props__["task_scaling_up_policies"] = task_scaling_up_policies
        __props__["termination_protected"] = termination_protected
        __props__["visible_to_all_users"] = visible_to_all_users
        return MrScalar(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

