# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Elastigroup(pulumi.CustomResource):
    custom_data: pulumi.Output[str]
    desired_capacity: pulumi.Output[float]
    """
    The desired number of instances the group should have at any time.
    """
    health_check: pulumi.Output[dict]
    images: pulumi.Output[list]
    integration_kubernetes: pulumi.Output[dict]
    integration_multai_runtime: pulumi.Output[dict]
    load_balancers: pulumi.Output[list]
    login: pulumi.Output[dict]
    low_priority_sizes: pulumi.Output[list]
    """
    Available Low-Priority sizes.
    """
    managed_service_identities: pulumi.Output[list]
    max_size: pulumi.Output[float]
    """
    The maximum number of instances the group should have at any time.
    """
    min_size: pulumi.Output[float]
    """
    The minimum number of instances the group should have at any time.
    """
    name: pulumi.Output[str]
    """
    The name of the managed identity.
    """
    network: pulumi.Output[dict]
    od_sizes: pulumi.Output[list]
    """
    Available On-Demand sizes
    """
    product: pulumi.Output[str]
    """
    Operation system type. Valid values: `"Linux"`, `"Windows"`.
    """
    region: pulumi.Output[str]
    """
    The region your Azure group will be created in.
    """
    resource_group_name: pulumi.Output[str]
    """
    The Resource Group that the user-assigned managed identity resides in.
    """
    scaling_down_policies: pulumi.Output[list]
    scaling_up_policies: pulumi.Output[list]
    scheduled_tasks: pulumi.Output[list]
    shutdown_script: pulumi.Output[str]
    """
    Shutdown script for the group. Value should be passed as a string encoded at Base64 only.
    """
    strategy: pulumi.Output[dict]
    """
    Describes the deployment strategy.

      * `draining_timeout` (`float`) - Time (seconds) to allow the instance to be drained from incoming TCP connections and detached from MLB before terminating it during a scale-down operation.
      * `lowPriorityPercentage` (`float`) - Percentage of Low Priority instances to maintain. Required if `od_count` is not specified.
      * `odCount` (`float`) - Number of On-Demand instances to maintain. Required if low_priority_percentage is not specified.
    """
    update_policy: pulumi.Output[dict]
    user_data: pulumi.Output[str]
    """
    Base64-encoded MIME user data to make available to the instances.
    """
    def __init__(__self__, resource_name, opts=None, custom_data=None, desired_capacity=None, health_check=None, images=None, integration_kubernetes=None, integration_multai_runtime=None, load_balancers=None, login=None, low_priority_sizes=None, managed_service_identities=None, max_size=None, min_size=None, name=None, network=None, od_sizes=None, product=None, region=None, resource_group_name=None, scaling_down_policies=None, scaling_up_policies=None, scheduled_tasks=None, shutdown_script=None, strategy=None, update_policy=None, user_data=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Spotinst elastigroup Azure resource.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/elastigroup_azure.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[list] low_priority_sizes: Available Low-Priority sizes.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The name of the managed identity.
        :param pulumi.Input[list] od_sizes: Available On-Demand sizes
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux"`, `"Windows"`.
        :param pulumi.Input[str] region: The region your Azure group will be created in.
        :param pulumi.Input[str] resource_group_name: The Resource Group that the user-assigned managed identity resides in.
        :param pulumi.Input[str] shutdown_script: Shutdown script for the group. Value should be passed as a string encoded at Base64 only.
        :param pulumi.Input[dict] strategy: Describes the deployment strategy.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.

        The **health_check** object supports the following:

          * `auto_healing` (`pulumi.Input[bool]`)
          * `grace_period` (`pulumi.Input[float]`)
          * `health_check_type` (`pulumi.Input[str]`)

        The **images** object supports the following:

          * `customs` (`pulumi.Input[list]`)
            * `imageName` (`pulumi.Input[str]`)
            * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.

          * `marketplaces` (`pulumi.Input[list]`)
            * `offer` (`pulumi.Input[str]`)
            * `publisher` (`pulumi.Input[str]`)
            * `sku` (`pulumi.Input[str]`)

        The **integration_kubernetes** object supports the following:

          * `clusterIdentifier` (`pulumi.Input[str]`)

        The **integration_multai_runtime** object supports the following:

          * `deployment_id` (`pulumi.Input[str]`)

        The **load_balancers** object supports the following:

          * `autoWeight` (`pulumi.Input[bool]`)
          * `balancer_id` (`pulumi.Input[str]`)
          * `target_set_id` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)

        The **login** object supports the following:

          * `password` (`pulumi.Input[str]`)
          * `sshPublicKey` (`pulumi.Input[str]`)
          * `userName` (`pulumi.Input[str]`)

        The **managed_service_identities** object supports the following:

          * `name` (`pulumi.Input[str]`) - The name of the managed identity.
          * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.

        The **network** object supports the following:

          * `additionalIpConfigs` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `privateIpVersion` (`pulumi.Input[str]`)

          * `assignPublicIp` (`pulumi.Input[bool]`)
          * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.
          * `subnetName` (`pulumi.Input[str]`)
          * `virtualNetworkName` (`pulumi.Input[str]`)

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `adjustment` (`pulumi.Input[str]`)
          * `adjustmentPercentage` (`pulumi.Input[str]`)
          * `batchSizePercentage` (`pulumi.Input[str]`)
          * `cronExpression` (`pulumi.Input[str]`)
          * `grace_period` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `scaleMaxCapacity` (`pulumi.Input[str]`)
          * `scaleMinCapacity` (`pulumi.Input[str]`)
          * `scaleTargetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **strategy** object supports the following:

          * `draining_timeout` (`pulumi.Input[float]`) - Time (seconds) to allow the instance to be drained from incoming TCP connections and detached from MLB before terminating it during a scale-down operation.
          * `lowPriorityPercentage` (`pulumi.Input[float]`) - Percentage of Low Priority instances to maintain. Required if `od_count` is not specified.
          * `odCount` (`pulumi.Input[float]`) - Number of On-Demand instances to maintain. Required if low_priority_percentage is not specified.

        The **update_policy** object supports the following:

          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `health_check_type` (`pulumi.Input[str]`)

          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['custom_data'] = custom_data
            __props__['desired_capacity'] = desired_capacity
            __props__['health_check'] = health_check
            __props__['images'] = images
            __props__['integration_kubernetes'] = integration_kubernetes
            __props__['integration_multai_runtime'] = integration_multai_runtime
            __props__['load_balancers'] = load_balancers
            __props__['login'] = login
            if low_priority_sizes is None:
                raise TypeError("Missing required property 'low_priority_sizes'")
            __props__['low_priority_sizes'] = low_priority_sizes
            __props__['managed_service_identities'] = managed_service_identities
            __props__['max_size'] = max_size
            __props__['min_size'] = min_size
            __props__['name'] = name
            if network is None:
                raise TypeError("Missing required property 'network'")
            __props__['network'] = network
            if od_sizes is None:
                raise TypeError("Missing required property 'od_sizes'")
            __props__['od_sizes'] = od_sizes
            if product is None:
                raise TypeError("Missing required property 'product'")
            __props__['product'] = product
            if region is None:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            if resource_group_name is None:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__['resource_group_name'] = resource_group_name
            __props__['scaling_down_policies'] = scaling_down_policies
            __props__['scaling_up_policies'] = scaling_up_policies
            __props__['scheduled_tasks'] = scheduled_tasks
            __props__['shutdown_script'] = shutdown_script
            if strategy is None:
                raise TypeError("Missing required property 'strategy'")
            __props__['strategy'] = strategy
            __props__['update_policy'] = update_policy
            __props__['user_data'] = user_data
        super(Elastigroup, __self__).__init__(
            'spotinst:azure/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, custom_data=None, desired_capacity=None, health_check=None, images=None, integration_kubernetes=None, integration_multai_runtime=None, load_balancers=None, login=None, low_priority_sizes=None, managed_service_identities=None, max_size=None, min_size=None, name=None, network=None, od_sizes=None, product=None, region=None, resource_group_name=None, scaling_down_policies=None, scaling_up_policies=None, scheduled_tasks=None, shutdown_script=None, strategy=None, update_policy=None, user_data=None):
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[list] low_priority_sizes: Available Low-Priority sizes.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The name of the managed identity.
        :param pulumi.Input[list] od_sizes: Available On-Demand sizes
        :param pulumi.Input[str] product: Operation system type. Valid values: `"Linux"`, `"Windows"`.
        :param pulumi.Input[str] region: The region your Azure group will be created in.
        :param pulumi.Input[str] resource_group_name: The Resource Group that the user-assigned managed identity resides in.
        :param pulumi.Input[str] shutdown_script: Shutdown script for the group. Value should be passed as a string encoded at Base64 only.
        :param pulumi.Input[dict] strategy: Describes the deployment strategy.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.

        The **health_check** object supports the following:

          * `auto_healing` (`pulumi.Input[bool]`)
          * `grace_period` (`pulumi.Input[float]`)
          * `health_check_type` (`pulumi.Input[str]`)

        The **images** object supports the following:

          * `customs` (`pulumi.Input[list]`)
            * `imageName` (`pulumi.Input[str]`)
            * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.

          * `marketplaces` (`pulumi.Input[list]`)
            * `offer` (`pulumi.Input[str]`)
            * `publisher` (`pulumi.Input[str]`)
            * `sku` (`pulumi.Input[str]`)

        The **integration_kubernetes** object supports the following:

          * `clusterIdentifier` (`pulumi.Input[str]`)

        The **integration_multai_runtime** object supports the following:

          * `deployment_id` (`pulumi.Input[str]`)

        The **load_balancers** object supports the following:

          * `autoWeight` (`pulumi.Input[bool]`)
          * `balancer_id` (`pulumi.Input[str]`)
          * `target_set_id` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)

        The **login** object supports the following:

          * `password` (`pulumi.Input[str]`)
          * `sshPublicKey` (`pulumi.Input[str]`)
          * `userName` (`pulumi.Input[str]`)

        The **managed_service_identities** object supports the following:

          * `name` (`pulumi.Input[str]`) - The name of the managed identity.
          * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.

        The **network** object supports the following:

          * `additionalIpConfigs` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `privateIpVersion` (`pulumi.Input[str]`)

          * `assignPublicIp` (`pulumi.Input[bool]`)
          * `resource_group_name` (`pulumi.Input[str]`) - The Resource Group that the user-assigned managed identity resides in.
          * `subnetName` (`pulumi.Input[str]`)
          * `virtualNetworkName` (`pulumi.Input[str]`)

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[str]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The name of the managed identity.
            * `value` (`pulumi.Input[str]`)

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `maxTargetCapacity` (`pulumi.Input[str]`)
          * `maximum` (`pulumi.Input[str]`)
          * `metricName` (`pulumi.Input[str]`)
          * `minTargetCapacity` (`pulumi.Input[str]`)
          * `minimum` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `target` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `adjustment` (`pulumi.Input[str]`)
          * `adjustmentPercentage` (`pulumi.Input[str]`)
          * `batchSizePercentage` (`pulumi.Input[str]`)
          * `cronExpression` (`pulumi.Input[str]`)
          * `grace_period` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `scaleMaxCapacity` (`pulumi.Input[str]`)
          * `scaleMinCapacity` (`pulumi.Input[str]`)
          * `scaleTargetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **strategy** object supports the following:

          * `draining_timeout` (`pulumi.Input[float]`) - Time (seconds) to allow the instance to be drained from incoming TCP connections and detached from MLB before terminating it during a scale-down operation.
          * `lowPriorityPercentage` (`pulumi.Input[float]`) - Percentage of Low Priority instances to maintain. Required if `od_count` is not specified.
          * `odCount` (`pulumi.Input[float]`) - Number of On-Demand instances to maintain. Required if low_priority_percentage is not specified.

        The **update_policy** object supports the following:

          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)
            * `grace_period` (`pulumi.Input[float]`)
            * `health_check_type` (`pulumi.Input[str]`)

          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["custom_data"] = custom_data
        __props__["desired_capacity"] = desired_capacity
        __props__["health_check"] = health_check
        __props__["images"] = images
        __props__["integration_kubernetes"] = integration_kubernetes
        __props__["integration_multai_runtime"] = integration_multai_runtime
        __props__["load_balancers"] = load_balancers
        __props__["login"] = login
        __props__["low_priority_sizes"] = low_priority_sizes
        __props__["managed_service_identities"] = managed_service_identities
        __props__["max_size"] = max_size
        __props__["min_size"] = min_size
        __props__["name"] = name
        __props__["network"] = network
        __props__["od_sizes"] = od_sizes
        __props__["product"] = product
        __props__["region"] = region
        __props__["resource_group_name"] = resource_group_name
        __props__["scaling_down_policies"] = scaling_down_policies
        __props__["scaling_up_policies"] = scaling_up_policies
        __props__["scheduled_tasks"] = scheduled_tasks
        __props__["shutdown_script"] = shutdown_script
        __props__["strategy"] = strategy
        __props__["update_policy"] = update_policy
        __props__["user_data"] = user_data
        return Elastigroup(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

