# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Ocean(pulumi.CustomResource):
    associate_public_ip_address: pulumi.Output[bool]
    """
    Configure public IP address allocation.
    """
    autoscaler: pulumi.Output[dict]
    """
    Describes the Ocean ECS autoscaler.

      * `cooldown` (`float`) - Cooldown period between scaling actions.
      * `down` (`dict`) - Auto Scaling scale down operations.
        * `maxScaleDownPercentage` (`float`) - Would represent the maximum % to scale-down. Number between 1-100

      * `headroom` (`dict`) - Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        * `cpuPerUnit` (`float`) - Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        * `memoryPerUnit` (`float`) - Optionally configure the amount of memory (MB) to allocate the headroom.
        * `numOfUnits` (`float`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.

      * `isAutoConfig` (`bool`) - Automatically configure and optimize headroom resources.
      * `isEnabled` (`bool`) - Enable the Ocean ECS autoscaler.
      * `resourceLimits` (`dict`) - Optionally set upper and lower bounds on the resource usage of the cluster.
        * `maxMemoryGib` (`float`) - The maximum memory in GiB units that can be allocated to the cluster.
        * `maxVcpu` (`float`) - The maximum cpu in vCPU units that can be allocated to the cluster.
    """
    cluster_name: pulumi.Output[str]
    """
    The ocean cluster name.
    """
    desired_capacity: pulumi.Output[float]
    """
    The number of instances to launch and maintain in the cluster.
    """
    draining_timeout: pulumi.Output[float]
    """
    The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
    """
    ebs_optimized: pulumi.Output[bool]
    """
    Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
    """
    iam_instance_profile: pulumi.Output[str]
    """
    The instance profile iam role.
    """
    image_id: pulumi.Output[str]
    """
    ID of the image used to launch the instances.
    """
    key_pair: pulumi.Output[str]
    """
    The key pair to attach the instances.
    """
    max_size: pulumi.Output[float]
    """
    The upper limit of instances the cluster can scale up to.
    """
    min_size: pulumi.Output[float]
    """
    The lower limit of instances the cluster can scale down to.
    """
    monitoring: pulumi.Output[bool]
    """
    Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
    """
    name: pulumi.Output[str]
    """
    The Ocean cluster name.
    """
    region: pulumi.Output[str]
    """
    The region the cluster will run in.
    """
    security_group_ids: pulumi.Output[list]
    """
    One or more security group ids.
    """
    subnet_ids: pulumi.Output[list]
    """
    A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
    """
    tags: pulumi.Output[list]
    """
    Optionally adds tags to instances launched in an Ocean cluster.

      * `key` (`str`) - The tag key.
      * `value` (`str`) - The tag value.
    """
    update_policy: pulumi.Output[dict]
    user_data: pulumi.Output[str]
    """
    Base64-encoded MIME user data to make available to the instances.
    """
    utilize_reserved_instances: pulumi.Output[bool]
    whitelists: pulumi.Output[list]
    """
    Instance types allowed in the Ocean cluster.
    """
    def __init__(__self__, resource_name, opts=None, associate_public_ip_address=None, autoscaler=None, cluster_name=None, desired_capacity=None, draining_timeout=None, ebs_optimized=None, iam_instance_profile=None, image_id=None, key_pair=None, max_size=None, min_size=None, monitoring=None, name=None, region=None, security_group_ids=None, subnet_ids=None, tags=None, update_policy=None, user_data=None, utilize_reserved_instances=None, whitelists=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Spotinst Ocean ECS resource.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/ocean_ecs.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[dict] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[str] cluster_name: The ocean cluster name.
        :param pulumi.Input[float] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[float] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[str] key_pair: The key pair to attach the instances.
        :param pulumi.Input[float] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[float] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[str] name: The Ocean cluster name.
        :param pulumi.Input[str] region: The region the cluster will run in.
        :param pulumi.Input[list] security_group_ids: One or more security group ids.
        :param pulumi.Input[list] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[list] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[list] whitelists: Instance types allowed in the Ocean cluster.

        The **autoscaler** object supports the following:

          * `cooldown` (`pulumi.Input[float]`) - Cooldown period between scaling actions.
          * `down` (`pulumi.Input[dict]`) - Auto Scaling scale down operations.
            * `maxScaleDownPercentage` (`pulumi.Input[float]`) - Would represent the maximum % to scale-down. Number between 1-100

          * `headroom` (`pulumi.Input[dict]`) - Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
            * `cpuPerUnit` (`pulumi.Input[float]`) - Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
            * `memoryPerUnit` (`pulumi.Input[float]`) - Optionally configure the amount of memory (MB) to allocate the headroom.
            * `numOfUnits` (`pulumi.Input[float]`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.

          * `isAutoConfig` (`pulumi.Input[bool]`) - Automatically configure and optimize headroom resources.
          * `isEnabled` (`pulumi.Input[bool]`) - Enable the Ocean ECS autoscaler.
          * `resourceLimits` (`pulumi.Input[dict]`) - Optionally set upper and lower bounds on the resource usage of the cluster.
            * `maxMemoryGib` (`pulumi.Input[float]`) - The maximum memory in GiB units that can be allocated to the cluster.
            * `maxVcpu` (`pulumi.Input[float]`) - The maximum cpu in vCPU units that can be allocated to the cluster.

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`) - The tag key.
          * `value` (`pulumi.Input[str]`) - The tag value.

        The **update_policy** object supports the following:

          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)

          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['associate_public_ip_address'] = associate_public_ip_address
            __props__['autoscaler'] = autoscaler
            if cluster_name is None:
                raise TypeError("Missing required property 'cluster_name'")
            __props__['cluster_name'] = cluster_name
            __props__['desired_capacity'] = desired_capacity
            __props__['draining_timeout'] = draining_timeout
            __props__['ebs_optimized'] = ebs_optimized
            __props__['iam_instance_profile'] = iam_instance_profile
            __props__['image_id'] = image_id
            __props__['key_pair'] = key_pair
            __props__['max_size'] = max_size
            __props__['min_size'] = min_size
            __props__['monitoring'] = monitoring
            __props__['name'] = name
            if region is None:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            if security_group_ids is None:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__['security_group_ids'] = security_group_ids
            if subnet_ids is None:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__['subnet_ids'] = subnet_ids
            __props__['tags'] = tags
            __props__['update_policy'] = update_policy
            __props__['user_data'] = user_data
            __props__['utilize_reserved_instances'] = utilize_reserved_instances
            __props__['whitelists'] = whitelists
        super(Ocean, __self__).__init__(
            'spotinst:ecs/ocean:Ocean',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, associate_public_ip_address=None, autoscaler=None, cluster_name=None, desired_capacity=None, draining_timeout=None, ebs_optimized=None, iam_instance_profile=None, image_id=None, key_pair=None, max_size=None, min_size=None, monitoring=None, name=None, region=None, security_group_ids=None, subnet_ids=None, tags=None, update_policy=None, user_data=None, utilize_reserved_instances=None, whitelists=None):
        """
        Get an existing Ocean resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[dict] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[str] cluster_name: The ocean cluster name.
        :param pulumi.Input[float] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[float] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[str] key_pair: The key pair to attach the instances.
        :param pulumi.Input[float] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[float] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[str] name: The Ocean cluster name.
        :param pulumi.Input[str] region: The region the cluster will run in.
        :param pulumi.Input[list] security_group_ids: One or more security group ids.
        :param pulumi.Input[list] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[list] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[list] whitelists: Instance types allowed in the Ocean cluster.

        The **autoscaler** object supports the following:

          * `cooldown` (`pulumi.Input[float]`) - Cooldown period between scaling actions.
          * `down` (`pulumi.Input[dict]`) - Auto Scaling scale down operations.
            * `maxScaleDownPercentage` (`pulumi.Input[float]`) - Would represent the maximum % to scale-down. Number between 1-100

          * `headroom` (`pulumi.Input[dict]`) - Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
            * `cpuPerUnit` (`pulumi.Input[float]`) - Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
            * `memoryPerUnit` (`pulumi.Input[float]`) - Optionally configure the amount of memory (MB) to allocate the headroom.
            * `numOfUnits` (`pulumi.Input[float]`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.

          * `isAutoConfig` (`pulumi.Input[bool]`) - Automatically configure and optimize headroom resources.
          * `isEnabled` (`pulumi.Input[bool]`) - Enable the Ocean ECS autoscaler.
          * `resourceLimits` (`pulumi.Input[dict]`) - Optionally set upper and lower bounds on the resource usage of the cluster.
            * `maxMemoryGib` (`pulumi.Input[float]`) - The maximum memory in GiB units that can be allocated to the cluster.
            * `maxVcpu` (`pulumi.Input[float]`) - The maximum cpu in vCPU units that can be allocated to the cluster.

        The **tags** object supports the following:

          * `key` (`pulumi.Input[str]`) - The tag key.
          * `value` (`pulumi.Input[str]`) - The tag value.

        The **update_policy** object supports the following:

          * `rollConfig` (`pulumi.Input[dict]`)
            * `batchSizePercentage` (`pulumi.Input[float]`)

          * `shouldRoll` (`pulumi.Input[bool]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["associate_public_ip_address"] = associate_public_ip_address
        __props__["autoscaler"] = autoscaler
        __props__["cluster_name"] = cluster_name
        __props__["desired_capacity"] = desired_capacity
        __props__["draining_timeout"] = draining_timeout
        __props__["ebs_optimized"] = ebs_optimized
        __props__["iam_instance_profile"] = iam_instance_profile
        __props__["image_id"] = image_id
        __props__["key_pair"] = key_pair
        __props__["max_size"] = max_size
        __props__["min_size"] = min_size
        __props__["monitoring"] = monitoring
        __props__["name"] = name
        __props__["region"] = region
        __props__["security_group_ids"] = security_group_ids
        __props__["subnet_ids"] = subnet_ids
        __props__["tags"] = tags
        __props__["update_policy"] = update_policy
        __props__["user_data"] = user_data
        __props__["utilize_reserved_instances"] = utilize_reserved_instances
        __props__["whitelists"] = whitelists
        return Ocean(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

