# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class OceanLaunchSpec(pulumi.CustomResource):
    attributes: pulumi.Output[list]
    """
    Optionally adds labels to instances launched in an Ocean cluster.

      * `key` (`str`) - The label key.
      * `value` (`str`) - The label value.
    """
    autoscale_headrooms: pulumi.Output[list]
    """
    Set custom headroom per launch spec. provide list of headrooms object.

      * `cpuPerUnit` (`float`) - Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
      * `memoryPerUnit` (`float`) - Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
      * `numOfUnits` (`float`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
    """
    iam_instance_profile: pulumi.Output[str]
    """
    The ARN or name of an IAM instance profile to associate with launched instances.
    """
    image_id: pulumi.Output[str]
    """
    ID of the image used to launch the instances.
    """
    name: pulumi.Output[str]
    """
    The Ocean Launch Specification name. 
    """
    ocean_id: pulumi.Output[str]
    """
    The Ocean cluster ID .
    """
    security_group_ids: pulumi.Output[list]
    """
    One or more security group ids.
    """
    user_data: pulumi.Output[str]
    """
    Base64-encoded MIME user data to make available to the instances.
    """
    def __init__(__self__, resource_name, opts=None, attributes=None, autoscale_headrooms=None, iam_instance_profile=None, image_id=None, name=None, ocean_id=None, security_group_ids=None, user_data=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a custom Spotinst Ocean ECS Launch Spec resource.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/ocean_ecs_launch_spec.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] attributes: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[list] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[str] name: The Ocean Launch Specification name. 
        :param pulumi.Input[str] ocean_id: The Ocean cluster ID .
        :param pulumi.Input[list] security_group_ids: One or more security group ids.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.

        The **attributes** object supports the following:

          * `key` (`pulumi.Input[str]`) - The label key.
          * `value` (`pulumi.Input[str]`) - The label value.

        The **autoscale_headrooms** object supports the following:

          * `cpuPerUnit` (`pulumi.Input[float]`) - Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
          * `memoryPerUnit` (`pulumi.Input[float]`) - Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
          * `numOfUnits` (`pulumi.Input[float]`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['attributes'] = attributes
            __props__['autoscale_headrooms'] = autoscale_headrooms
            __props__['iam_instance_profile'] = iam_instance_profile
            __props__['image_id'] = image_id
            __props__['name'] = name
            if ocean_id is None:
                raise TypeError("Missing required property 'ocean_id'")
            __props__['ocean_id'] = ocean_id
            __props__['security_group_ids'] = security_group_ids
            __props__['user_data'] = user_data
        super(OceanLaunchSpec, __self__).__init__(
            'spotinst:ecs/oceanLaunchSpec:OceanLaunchSpec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, attributes=None, autoscale_headrooms=None, iam_instance_profile=None, image_id=None, name=None, ocean_id=None, security_group_ids=None, user_data=None):
        """
        Get an existing OceanLaunchSpec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] attributes: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[list] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[str] iam_instance_profile: The ARN or name of an IAM instance profile to associate with launched instances.
        :param pulumi.Input[str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[str] name: The Ocean Launch Specification name. 
        :param pulumi.Input[str] ocean_id: The Ocean cluster ID .
        :param pulumi.Input[list] security_group_ids: One or more security group ids.
        :param pulumi.Input[str] user_data: Base64-encoded MIME user data to make available to the instances.

        The **attributes** object supports the following:

          * `key` (`pulumi.Input[str]`) - The label key.
          * `value` (`pulumi.Input[str]`) - The label value.

        The **autoscale_headrooms** object supports the following:

          * `cpuPerUnit` (`pulumi.Input[float]`) - Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
          * `memoryPerUnit` (`pulumi.Input[float]`) - Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
          * `numOfUnits` (`pulumi.Input[float]`) - The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["attributes"] = attributes
        __props__["autoscale_headrooms"] = autoscale_headrooms
        __props__["iam_instance_profile"] = iam_instance_profile
        __props__["image_id"] = image_id
        __props__["name"] = name
        __props__["ocean_id"] = ocean_id
        __props__["security_group_ids"] = security_group_ids
        __props__["user_data"] = user_data
        return OceanLaunchSpec(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

