# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Elastigroup(pulumi.CustomResource):
    auto_healing: pulumi.Output[bool]
    availability_zones: pulumi.Output[list]
    """
    List of availability zones for the group.
    """
    backend_services: pulumi.Output[list]
    description: pulumi.Output[str]
    """
    The region your GCP group will be created in.
    """
    desired_capacity: pulumi.Output[float]
    """
    The desired number of instances the group should have at any time.
    """
    disks: pulumi.Output[list]
    draining_timeout: pulumi.Output[float]
    """
    Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
    """
    fallback_to_ondemand: pulumi.Output[bool]
    """
    Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
    """
    gpu: pulumi.Output[list]
    health_check_grace_period: pulumi.Output[float]
    health_check_type: pulumi.Output[str]
    instance_types_customs: pulumi.Output[list]
    """
    Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.

      * `memoryGib` (`float`) - The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
      * `vcpu` (`float`)
    """
    instance_types_ondemand: pulumi.Output[str]
    """
    The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
    """
    instance_types_preemptibles: pulumi.Output[list]
    """
    The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
    """
    integration_docker_swarm: pulumi.Output[dict]
    integration_gke: pulumi.Output[dict]
    ip_forwarding: pulumi.Output[bool]
    labels: pulumi.Output[list]
    """
    Array of objects with key-value pairs.

      * `key` (`str`) - Labels key.
      * `value` (`str`) - Labels value.
    """
    max_size: pulumi.Output[float]
    """
    The maximum number of instances the group should have at any time.
    """
    metadatas: pulumi.Output[list]
    """
    Array of objects with key-value pairs.

      * `key` (`str`) - Labels key.
      * `value` (`str`) - Labels value.
    """
    min_size: pulumi.Output[float]
    """
    The minimum number of instances the group should have at any time.
    """
    name: pulumi.Output[str]
    """
    The group name. 
    """
    network_interfaces: pulumi.Output[list]
    ondemand_count: pulumi.Output[float]
    preemptible_percentage: pulumi.Output[float]
    """
    Percentage of Preemptible VMs to spin up from the "desired_capacity".
    """
    scaling_down_policies: pulumi.Output[list]
    scaling_up_policies: pulumi.Output[list]
    scheduled_tasks: pulumi.Output[list]
    service_account: pulumi.Output[str]
    """
    The email of the service account in which the group instances will be launched.
    """
    shutdown_script: pulumi.Output[str]
    """
    The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
    """
    startup_script: pulumi.Output[str]
    """
    Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
    """
    subnets: pulumi.Output[list]
    """
    A list of regions and subnets.

      * `region` (`str`) - The region for the group of subnets.
      * `subnetNames` (`list`) - The names of the subnets in the region.
    """
    tags: pulumi.Output[list]
    """
    Tags to mark created instances.
    """
    unhealthy_duration: pulumi.Output[float]
    def __init__(__self__, resource_name, opts=None, auto_healing=None, availability_zones=None, backend_services=None, description=None, desired_capacity=None, disks=None, draining_timeout=None, fallback_to_ondemand=None, gpu=None, health_check_grace_period=None, health_check_type=None, instance_types_customs=None, instance_types_ondemand=None, instance_types_preemptibles=None, integration_docker_swarm=None, integration_gke=None, ip_forwarding=None, labels=None, max_size=None, metadatas=None, min_size=None, name=None, network_interfaces=None, ondemand_count=None, preemptible_percentage=None, scaling_down_policies=None, scaling_up_policies=None, scheduled_tasks=None, service_account=None, shutdown_script=None, startup_script=None, subnets=None, tags=None, unhealthy_duration=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Spotinst elastigroup GCP resource.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-spotinst/blob/master/website/docs/r/elastigroup_gcp.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] availability_zones: List of availability zones for the group.
        :param pulumi.Input[str] description: The region your GCP group will be created in.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[float] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[list] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
        :param pulumi.Input[str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[list] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[list] labels: Array of objects with key-value pairs.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[list] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The group name. 
        :param pulumi.Input[float] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[list] subnets: A list of regions and subnets.
        :param pulumi.Input[list] tags: Tags to mark created instances.

        The **backend_services** object supports the following:

          * `locationType` (`pulumi.Input[str]`)
          * `namedPorts` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `ports` (`pulumi.Input[list]`)

          * `scheme` (`pulumi.Input[str]`)
          * `serviceName` (`pulumi.Input[str]`)

        The **disks** object supports the following:

          * `autoDelete` (`pulumi.Input[bool]`)
          * `boot` (`pulumi.Input[bool]`)
          * `deviceName` (`pulumi.Input[str]`)
          * `initializeParams` (`pulumi.Input[list]`)
            * `diskSizeGb` (`pulumi.Input[str]`)
            * `diskType` (`pulumi.Input[str]`)
            * `source_image` (`pulumi.Input[str]`)

          * `interface` (`pulumi.Input[str]`)
          * `mode` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)

        The **gpu** object supports the following:

          * `count` (`pulumi.Input[float]`)
          * `type` (`pulumi.Input[str]`)

        The **instance_types_customs** object supports the following:

          * `memoryGib` (`pulumi.Input[float]`) - The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
          * `vcpu` (`pulumi.Input[float]`)

        The **integration_docker_swarm** object supports the following:

          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_gke** object supports the following:

          * `autoUpdate` (`pulumi.Input[bool]`)
          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleLabels` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`) - Labels key.
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `cluster_id` (`pulumi.Input[str]`)
          * `location` (`pulumi.Input[str]`)

        The **labels** object supports the following:

          * `key` (`pulumi.Input[str]`) - Labels key.
          * `value` (`pulumi.Input[str]`) - Labels value.

        The **metadatas** object supports the following:

          * `key` (`pulumi.Input[str]`) - Labels key.
          * `value` (`pulumi.Input[str]`) - Labels value.

        The **network_interfaces** object supports the following:

          * `accessConfigs` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `type` (`pulumi.Input[str]`)

          * `aliasIpRanges` (`pulumi.Input[list]`)
            * `ipCidrRange` (`pulumi.Input[str]`)
            * `subnetworkRangeName` (`pulumi.Input[str]`)

          * `network` (`pulumi.Input[str]`)

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[float]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[float]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `cronExpression` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `targetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **subnets** object supports the following:

          * `region` (`pulumi.Input[str]`) - The region for the group of subnets.
          * `subnetNames` (`pulumi.Input[list]`) - The names of the subnets in the region.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['auto_healing'] = auto_healing
            __props__['availability_zones'] = availability_zones
            __props__['backend_services'] = backend_services
            __props__['description'] = description
            if desired_capacity is None:
                raise TypeError("Missing required property 'desired_capacity'")
            __props__['desired_capacity'] = desired_capacity
            __props__['disks'] = disks
            __props__['draining_timeout'] = draining_timeout
            __props__['fallback_to_ondemand'] = fallback_to_ondemand
            __props__['gpu'] = gpu
            __props__['health_check_grace_period'] = health_check_grace_period
            __props__['health_check_type'] = health_check_type
            __props__['instance_types_customs'] = instance_types_customs
            __props__['instance_types_ondemand'] = instance_types_ondemand
            __props__['instance_types_preemptibles'] = instance_types_preemptibles
            __props__['integration_docker_swarm'] = integration_docker_swarm
            __props__['integration_gke'] = integration_gke
            __props__['ip_forwarding'] = ip_forwarding
            __props__['labels'] = labels
            __props__['max_size'] = max_size
            __props__['metadatas'] = metadatas
            __props__['min_size'] = min_size
            __props__['name'] = name
            __props__['network_interfaces'] = network_interfaces
            __props__['ondemand_count'] = ondemand_count
            __props__['preemptible_percentage'] = preemptible_percentage
            __props__['scaling_down_policies'] = scaling_down_policies
            __props__['scaling_up_policies'] = scaling_up_policies
            __props__['scheduled_tasks'] = scheduled_tasks
            __props__['service_account'] = service_account
            __props__['shutdown_script'] = shutdown_script
            __props__['startup_script'] = startup_script
            __props__['subnets'] = subnets
            __props__['tags'] = tags
            __props__['unhealthy_duration'] = unhealthy_duration
        super(Elastigroup, __self__).__init__(
            'spotinst:gcp/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, auto_healing=None, availability_zones=None, backend_services=None, description=None, desired_capacity=None, disks=None, draining_timeout=None, fallback_to_ondemand=None, gpu=None, health_check_grace_period=None, health_check_type=None, instance_types_customs=None, instance_types_ondemand=None, instance_types_preemptibles=None, integration_docker_swarm=None, integration_gke=None, ip_forwarding=None, labels=None, max_size=None, metadatas=None, min_size=None, name=None, network_interfaces=None, ondemand_count=None, preemptible_percentage=None, scaling_down_policies=None, scaling_up_policies=None, scheduled_tasks=None, service_account=None, shutdown_script=None, startup_script=None, subnets=None, tags=None, unhealthy_duration=None):
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] availability_zones: List of availability zones for the group.
        :param pulumi.Input[str] description: The region your GCP group will be created in.
        :param pulumi.Input[float] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[float] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[list] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
        :param pulumi.Input[str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[list] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[list] labels: Array of objects with key-value pairs.
        :param pulumi.Input[float] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[list] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[float] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[str] name: The group name. 
        :param pulumi.Input[float] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input[str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[list] subnets: A list of regions and subnets.
        :param pulumi.Input[list] tags: Tags to mark created instances.

        The **backend_services** object supports the following:

          * `locationType` (`pulumi.Input[str]`)
          * `namedPorts` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `ports` (`pulumi.Input[list]`)

          * `scheme` (`pulumi.Input[str]`)
          * `serviceName` (`pulumi.Input[str]`)

        The **disks** object supports the following:

          * `autoDelete` (`pulumi.Input[bool]`)
          * `boot` (`pulumi.Input[bool]`)
          * `deviceName` (`pulumi.Input[str]`)
          * `initializeParams` (`pulumi.Input[list]`)
            * `diskSizeGb` (`pulumi.Input[str]`)
            * `diskType` (`pulumi.Input[str]`)
            * `source_image` (`pulumi.Input[str]`)

          * `interface` (`pulumi.Input[str]`)
          * `mode` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)

        The **gpu** object supports the following:

          * `count` (`pulumi.Input[float]`)
          * `type` (`pulumi.Input[str]`)

        The **instance_types_customs** object supports the following:

          * `memoryGib` (`pulumi.Input[float]`) - The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
          * `vcpu` (`pulumi.Input[float]`)

        The **integration_docker_swarm** object supports the following:

          * `masterHost` (`pulumi.Input[str]`)
          * `masterPort` (`pulumi.Input[float]`)

        The **integration_gke** object supports the following:

          * `autoUpdate` (`pulumi.Input[bool]`)
          * `autoscaleCooldown` (`pulumi.Input[float]`)
          * `autoscaleDown` (`pulumi.Input[dict]`)
            * `evaluationPeriods` (`pulumi.Input[float]`)

          * `autoscaleHeadroom` (`pulumi.Input[dict]`)
            * `cpuPerUnit` (`pulumi.Input[float]`)
            * `memoryPerUnit` (`pulumi.Input[float]`)
            * `numOfUnits` (`pulumi.Input[float]`)

          * `autoscaleIsAutoConfig` (`pulumi.Input[bool]`)
          * `autoscaleIsEnabled` (`pulumi.Input[bool]`)
          * `autoscaleLabels` (`pulumi.Input[list]`)
            * `key` (`pulumi.Input[str]`) - Labels key.
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `cluster_id` (`pulumi.Input[str]`)
          * `location` (`pulumi.Input[str]`)

        The **labels** object supports the following:

          * `key` (`pulumi.Input[str]`) - Labels key.
          * `value` (`pulumi.Input[str]`) - Labels value.

        The **metadatas** object supports the following:

          * `key` (`pulumi.Input[str]`) - Labels key.
          * `value` (`pulumi.Input[str]`) - Labels value.

        The **network_interfaces** object supports the following:

          * `accessConfigs` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `type` (`pulumi.Input[str]`)

          * `aliasIpRanges` (`pulumi.Input[list]`)
            * `ipCidrRange` (`pulumi.Input[str]`)
            * `subnetworkRangeName` (`pulumi.Input[str]`)

          * `network` (`pulumi.Input[str]`)

        The **scaling_down_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[float]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scaling_up_policies** object supports the following:

          * `actionType` (`pulumi.Input[str]`)
          * `adjustment` (`pulumi.Input[float]`)
          * `cooldown` (`pulumi.Input[float]`)
          * `dimensions` (`pulumi.Input[list]`)
            * `name` (`pulumi.Input[str]`) - The group name. 
            * `value` (`pulumi.Input[str]`) - Labels value.

          * `evaluationPeriods` (`pulumi.Input[float]`)
          * `metricName` (`pulumi.Input[str]`)
          * `namespace` (`pulumi.Input[str]`)
          * `operator` (`pulumi.Input[str]`)
          * `period` (`pulumi.Input[float]`)
          * `policyName` (`pulumi.Input[str]`)
          * `source` (`pulumi.Input[str]`)
          * `statistic` (`pulumi.Input[str]`)
          * `threshold` (`pulumi.Input[float]`)
          * `unit` (`pulumi.Input[str]`)

        The **scheduled_tasks** object supports the following:

          * `cronExpression` (`pulumi.Input[str]`)
          * `isEnabled` (`pulumi.Input[bool]`)
          * `maxCapacity` (`pulumi.Input[str]`)
          * `minCapacity` (`pulumi.Input[str]`)
          * `targetCapacity` (`pulumi.Input[str]`)
          * `taskType` (`pulumi.Input[str]`)

        The **subnets** object supports the following:

          * `region` (`pulumi.Input[str]`) - The region for the group of subnets.
          * `subnetNames` (`pulumi.Input[list]`) - The names of the subnets in the region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["auto_healing"] = auto_healing
        __props__["availability_zones"] = availability_zones
        __props__["backend_services"] = backend_services
        __props__["description"] = description
        __props__["desired_capacity"] = desired_capacity
        __props__["disks"] = disks
        __props__["draining_timeout"] = draining_timeout
        __props__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__["gpu"] = gpu
        __props__["health_check_grace_period"] = health_check_grace_period
        __props__["health_check_type"] = health_check_type
        __props__["instance_types_customs"] = instance_types_customs
        __props__["instance_types_ondemand"] = instance_types_ondemand
        __props__["instance_types_preemptibles"] = instance_types_preemptibles
        __props__["integration_docker_swarm"] = integration_docker_swarm
        __props__["integration_gke"] = integration_gke
        __props__["ip_forwarding"] = ip_forwarding
        __props__["labels"] = labels
        __props__["max_size"] = max_size
        __props__["metadatas"] = metadatas
        __props__["min_size"] = min_size
        __props__["name"] = name
        __props__["network_interfaces"] = network_interfaces
        __props__["ondemand_count"] = ondemand_count
        __props__["preemptible_percentage"] = preemptible_percentage
        __props__["scaling_down_policies"] = scaling_down_policies
        __props__["scaling_up_policies"] = scaling_up_policies
        __props__["scheduled_tasks"] = scheduled_tasks
        __props__["service_account"] = service_account
        __props__["shutdown_script"] = shutdown_script
        __props__["startup_script"] = startup_script
        __props__["subnets"] = subnets
        __props__["tags"] = tags
        __props__["unhealthy_duration"] = unhealthy_duration
        return Elastigroup(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

