"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from datetime import datetime
from jsonpath import JSONPath
from kombo import errors, models, utils
from kombo._hooks import HookContext
from kombo.types import BaseModel, OptionalNullable, UNSET
from kombo.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union, cast


class Assessment(BaseSDK):
    def get_packages(
        self,
        *,
        request: Union[
            models.GetAssessmentPackagesRequest,
            models.GetAssessmentPackagesRequestTypedDict,
        ] = models.GetAssessmentPackagesRequest(),
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetAssessmentPackagesPositiveResponse:
        r"""Get packages

        Get all available assessment and background check packages for an integration.

        This is mainly intended for debugging. As you always need to submit the full list of available packages when using [\"set packages\"](/assessment/v1/put-packages), there shouldn't ever be a need to call this endpoint in production.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.GetAssessmentPackagesRequest)
        request = cast(models.GetAssessmentPackagesRequest, request)

        req = self._build_request(
            method="GET",
            path="/assessment/packages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetAssessmentPackagesGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GetAssessmentPackages",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetAssessmentPackagesPositiveResponse, http_res
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_packages_async(
        self,
        *,
        request: Union[
            models.GetAssessmentPackagesRequest,
            models.GetAssessmentPackagesRequestTypedDict,
        ] = models.GetAssessmentPackagesRequest(),
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetAssessmentPackagesPositiveResponse:
        r"""Get packages

        Get all available assessment and background check packages for an integration.

        This is mainly intended for debugging. As you always need to submit the full list of available packages when using [\"set packages\"](/assessment/v1/put-packages), there shouldn't ever be a need to call this endpoint in production.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.GetAssessmentPackagesRequest)
        request = cast(models.GetAssessmentPackagesRequest, request)

        req = self._build_request_async(
            method="GET",
            path="/assessment/packages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetAssessmentPackagesGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GetAssessmentPackages",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GetAssessmentPackagesPositiveResponse, http_res
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def set_packages(
        self,
        *,
        packages: Union[
            List[models.PutAssessmentPackagesRequestBodyPackage],
            List[models.PutAssessmentPackagesRequestBodyPackageTypedDict],
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutAssessmentPackagesPositiveResponse:
        r"""Set packages

        Set packages

        Replaces the list of available assessment and or background check packages.

        Packages that have been previously submitted through this endpoint but aren't included again will be marked as deleted.

        ### Example Request Body

        ```json
        {
        \"packages\": [
        {
        \"id\": \"1001\",
        \"type\": \"SKILLS_TEST\",
        \"name\": \"TypeScript\",
        \"description\": \"TypeScript coding skills assessments\"
        },
        {
        \"id\": \"1002\",
        \"type\": \"VIDEO_INTERVIEW\",
        \"name\": \"Video Interview\",
        \"description\": \"Video interview to assess communication skills\"
        }
        ]
        }
        ```

        :param packages:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutAssessmentPackagesRequestBody(
            packages=utils.get_pydantic_model(
                packages, List[models.PutAssessmentPackagesRequestBodyPackage]
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/assessment/packages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.PutAssessmentPackagesGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.PutAssessmentPackagesRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="PutAssessmentPackages",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutAssessmentPackagesPositiveResponse, http_res
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def set_packages_async(
        self,
        *,
        packages: Union[
            List[models.PutAssessmentPackagesRequestBodyPackage],
            List[models.PutAssessmentPackagesRequestBodyPackageTypedDict],
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutAssessmentPackagesPositiveResponse:
        r"""Set packages

        Set packages

        Replaces the list of available assessment and or background check packages.

        Packages that have been previously submitted through this endpoint but aren't included again will be marked as deleted.

        ### Example Request Body

        ```json
        {
        \"packages\": [
        {
        \"id\": \"1001\",
        \"type\": \"SKILLS_TEST\",
        \"name\": \"TypeScript\",
        \"description\": \"TypeScript coding skills assessments\"
        },
        {
        \"id\": \"1002\",
        \"type\": \"VIDEO_INTERVIEW\",
        \"name\": \"Video Interview\",
        \"description\": \"Video interview to assess communication skills\"
        }
        ]
        }
        ```

        :param packages:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutAssessmentPackagesRequestBody(
            packages=utils.get_pydantic_model(
                packages, List[models.PutAssessmentPackagesRequestBodyPackage]
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/assessment/packages",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.PutAssessmentPackagesGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.PutAssessmentPackagesRequestBody
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="PutAssessmentPackages",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutAssessmentPackagesPositiveResponse, http_res
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_open_orders(
        self,
        *,
        cursor: Optional[str] = None,
        page_size: Optional[int] = 100,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GetAssessmentOrdersOpenResponse]:
        r"""Get open orders

        Get all open assessment and background check orders of an integration.

        :param cursor: An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response.
        :param page_size: The number of results to return per page. Maximum is 250.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAssessmentOrdersOpenRequest(
            cursor=cursor,
            page_size=page_size,
        )

        req = self._build_request(
            method="GET",
            path="/assessment/orders/open",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetAssessmentOrdersOpenGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GetAssessmentOrdersOpen",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.GetAssessmentOrdersOpenResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            next_cursor = JSONPath("$.next").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.get_open_orders(
                cursor=next_cursor,
                page_size=page_size,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GetAssessmentOrdersOpenResponse(
                result=unmarshal_json_response(
                    models.GetAssessmentOrdersOpenPositiveResponse, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_open_orders_async(
        self,
        *,
        cursor: Optional[str] = None,
        page_size: Optional[int] = 100,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GetAssessmentOrdersOpenResponse]:
        r"""Get open orders

        Get all open assessment and background check orders of an integration.

        :param cursor: An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response.
        :param page_size: The number of results to return per page. Maximum is 250.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetAssessmentOrdersOpenRequest(
            cursor=cursor,
            page_size=page_size,
        )

        req = self._build_request_async(
            method="GET",
            path="/assessment/orders/open",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetAssessmentOrdersOpenGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GetAssessmentOrdersOpen",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.GetAssessmentOrdersOpenResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            next_cursor = JSONPath("$.next").parse(body)

            if len(next_cursor) == 0:
                return empty_result()

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return empty_result()

            return self.get_open_orders_async(
                cursor=next_cursor,
                page_size=page_size,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GetAssessmentOrdersOpenResponse(
                result=unmarshal_json_response(
                    models.GetAssessmentOrdersOpenPositiveResponse, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update_order_result(
        self,
        *,
        assessment_order_id: str,
        status: models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyStatus,
        result_url: str,
        completed_at: Optional[datetime] = None,
        score: Optional[float] = None,
        max_score: Optional[float] = None,
        attributes: Optional[
            Union[List[models.Attribute], List[models.AttributeTypedDict]]
        ] = None,
        attachments: Optional[
            Union[
                List[
                    models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment
                ],
                List[
                    models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachmentTypedDict
                ],
            ]
        ] = None,
        remote_fields: Optional[
            Union[
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields,
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFieldsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutAssessmentOrdersAssessmentOrderIDResultPositiveResponse:
        r"""Update order result

        Updates an assessment or a background check order result.

        ### Example Request Body

        ```json
        {
        \"status\": \"COMPLETED\",
        \"score\": 90,
        \"max_score\": 100,
        \"result_url\": \"https://example.com\",
        \"completed_at\": \"2023-04-04T00:00:00.000Z\",
        \"attributes\": [
        {
        \"type\": \"TEXT\",
        \"label\": \"Role fit\",
        \"value\": \"Excellent\"
        },
        {
        \"type\": \"SUB_RESULT\",
        \"id\": \"<YOUR_INTERNAL_ID_OF_THE_TEST>\",
        \"label\": \"Personality test\",
        \"score\": {
        \"value\": 97,
        \"max\": 100
        },
        \"status\": \"COMPLETED\"
        }
        ],
        \"attachments\": [
        {
        \"name\": \"Assessment Report.pdf\",
        \"data\": \"SGkgdGhlcmUsIEtvbWJvIGlzIGN1cnJlbnRseSBoaXJpbmcgZW5naW5lZXJzIHRoYXQgbG92ZSB0byB3b3JrIG9uIGRldmVsb3BlciBwcm9kdWN0cy4=\",
        \"content_type\": \"application/pdf\"
        }
        ]
        }
        ```

        :param assessment_order_id: PUT /assessment/orders/:assessment_order_id/result Parameter
        :param status: Status of the assessment.

            **Please note the `status` can only be updated to a different value if its current value is `OPEN`.**
        :param result_url:
        :param completed_at: YYYY-MM-DDTHH:mm:ss.sssZ

            **Please make sure this value is provided when the `status` is of the type `COMPLETED` or `CANCELLED`.**
        :param score:
        :param max_score:
        :param attributes: An array of additional attributes that you would like to submit as a part of the assessment result.

            - If an ATS only supports writing text attributes, we will transform non `TEXT` attributes into formatted plain text values.
        :param attachments: An array of attachments containing the assessment result.
        :param remote_fields: Additional fields that we will pass through to specific ATS systems.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutAssessmentOrdersAssessmentOrderIDResultRequest(
            assessment_order_id=assessment_order_id,
            body=models.PutAssessmentOrdersAssessmentOrderIDResultRequestBody(
                status=status,
                result_url=result_url,
                completed_at=completed_at,
                score=score,
                max_score=max_score,
                attributes=utils.get_pydantic_model(
                    attributes, Optional[List[models.Attribute]]
                ),
                attachments=utils.get_pydantic_model(
                    attachments,
                    Optional[
                        List[
                            models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment
                        ]
                    ],
                ),
                remote_fields=utils.get_pydantic_model(
                    remote_fields,
                    Optional[
                        models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields
                    ],
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/assessment/orders/{assessment_order_id}/result",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.PutAssessmentOrdersAssessmentOrderIDResultGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.body,
                False,
                False,
                "json",
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="PutAssessmentOrdersAssessmentOrderIdResult",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutAssessmentOrdersAssessmentOrderIDResultPositiveResponse,
                http_res,
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_order_result_async(
        self,
        *,
        assessment_order_id: str,
        status: models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyStatus,
        result_url: str,
        completed_at: Optional[datetime] = None,
        score: Optional[float] = None,
        max_score: Optional[float] = None,
        attributes: Optional[
            Union[List[models.Attribute], List[models.AttributeTypedDict]]
        ] = None,
        attachments: Optional[
            Union[
                List[
                    models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment
                ],
                List[
                    models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachmentTypedDict
                ],
            ]
        ] = None,
        remote_fields: Optional[
            Union[
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields,
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFieldsTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PutAssessmentOrdersAssessmentOrderIDResultPositiveResponse:
        r"""Update order result

        Updates an assessment or a background check order result.

        ### Example Request Body

        ```json
        {
        \"status\": \"COMPLETED\",
        \"score\": 90,
        \"max_score\": 100,
        \"result_url\": \"https://example.com\",
        \"completed_at\": \"2023-04-04T00:00:00.000Z\",
        \"attributes\": [
        {
        \"type\": \"TEXT\",
        \"label\": \"Role fit\",
        \"value\": \"Excellent\"
        },
        {
        \"type\": \"SUB_RESULT\",
        \"id\": \"<YOUR_INTERNAL_ID_OF_THE_TEST>\",
        \"label\": \"Personality test\",
        \"score\": {
        \"value\": 97,
        \"max\": 100
        },
        \"status\": \"COMPLETED\"
        }
        ],
        \"attachments\": [
        {
        \"name\": \"Assessment Report.pdf\",
        \"data\": \"SGkgdGhlcmUsIEtvbWJvIGlzIGN1cnJlbnRseSBoaXJpbmcgZW5naW5lZXJzIHRoYXQgbG92ZSB0byB3b3JrIG9uIGRldmVsb3BlciBwcm9kdWN0cy4=\",
        \"content_type\": \"application/pdf\"
        }
        ]
        }
        ```

        :param assessment_order_id: PUT /assessment/orders/:assessment_order_id/result Parameter
        :param status: Status of the assessment.

            **Please note the `status` can only be updated to a different value if its current value is `OPEN`.**
        :param result_url:
        :param completed_at: YYYY-MM-DDTHH:mm:ss.sssZ

            **Please make sure this value is provided when the `status` is of the type `COMPLETED` or `CANCELLED`.**
        :param score:
        :param max_score:
        :param attributes: An array of additional attributes that you would like to submit as a part of the assessment result.

            - If an ATS only supports writing text attributes, we will transform non `TEXT` attributes into formatted plain text values.
        :param attachments: An array of attachments containing the assessment result.
        :param remote_fields: Additional fields that we will pass through to specific ATS systems.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.PutAssessmentOrdersAssessmentOrderIDResultRequest(
            assessment_order_id=assessment_order_id,
            body=models.PutAssessmentOrdersAssessmentOrderIDResultRequestBody(
                status=status,
                result_url=result_url,
                completed_at=completed_at,
                score=score,
                max_score=max_score,
                attributes=utils.get_pydantic_model(
                    attributes, Optional[List[models.Attribute]]
                ),
                attachments=utils.get_pydantic_model(
                    attachments,
                    Optional[
                        List[
                            models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyAttachment
                        ]
                    ],
                ),
                remote_fields=utils.get_pydantic_model(
                    remote_fields,
                    Optional[
                        models.PutAssessmentOrdersAssessmentOrderIDResultRequestBodyRemoteFields
                    ],
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/assessment/orders/{assessment_order_id}/result",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.PutAssessmentOrdersAssessmentOrderIDResultGlobals(
                integration_id=self.sdk_configuration.globals.integration_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.body,
                False,
                False,
                "json",
                models.PutAssessmentOrdersAssessmentOrderIDResultRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="PutAssessmentOrdersAssessmentOrderIdResult",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["default"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.PutAssessmentOrdersAssessmentOrderIDResultPositiveResponse,
                http_res,
            )
        if utils.match_response(http_res, "default", "application/json"):
            response_data = unmarshal_json_response(errors.KomboAtsErrorData, http_res)
            raise errors.KomboAtsError(response_data, http_res)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
