"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from kombo.errors import SDKError
from kombo.models import komboatserror as models_komboatserror
from kombo.types import BaseModel
from typing import Optional


class KomboAtsErrorData(BaseModel):
    status: models_komboatserror.KomboAtsErrorStatus

    error: models_komboatserror.KomboAtsErrorError
    r"""Error details with structured code for programmatic handling."""


@dataclass(unsafe_hash=True)
class KomboAtsError(SDKError):
    r"""The standard error response with the error codes for the ATS use case."""

    data: KomboAtsErrorData = field(hash=False)

    def __init__(
        self,
        data: KomboAtsErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
