"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from kombo.errors import SDKError
from kombo.models import kombogeneralerror as models_kombogeneralerror
from kombo.types import BaseModel
from typing import Optional


class KomboGeneralErrorData(BaseModel):
    status: models_kombogeneralerror.KomboGeneralErrorStatus

    error: models_kombogeneralerror.KomboGeneralErrorError
    r"""Error details with structured code for programmatic handling."""


@dataclass(unsafe_hash=True)
class KomboGeneralError(SDKError):
    r"""The standard error response with just the platform error codes."""

    data: KomboGeneralErrorData = field(hash=False)

    def __init__(
        self,
        data: KomboGeneralErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
