"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from kombo.errors import SDKError
from kombo.models import kombohriserror as models_kombohriserror
from kombo.types import BaseModel
from typing import Optional


class KomboHrisErrorData(BaseModel):
    status: models_kombohriserror.KomboHrisErrorStatus

    error: models_kombohriserror.KomboHrisErrorError
    r"""Error details with structured code for programmatic handling."""


@dataclass(unsafe_hash=True)
class KomboHrisError(SDKError):
    r"""The standard error response with the error codes for the HRIS use case."""

    data: KomboHrisErrorData = field(hash=False)

    def __init__(
        self,
        data: KomboHrisErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
