"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import TypedDict


ConnectionFlowFailedWebhookPayloadType = Literal["connection-flow-failed",]
r"""Type of the webhook event"""


ConnectionFlowFailedWebhookPayloadIntegrationCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]
r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""


class ConnectionFlowFailedWebhookPayloadEndUserTypedDict(TypedDict):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""
    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""
    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""


class ConnectionFlowFailedWebhookPayloadEndUser(BaseModel):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""

    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""

    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["creator_email", "origin_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ConnectionFlowFailedWebhookPayloadDataTypedDict(TypedDict):
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""
    integration_category: ConnectionFlowFailedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""
    end_user: ConnectionFlowFailedWebhookPayloadEndUserTypedDict
    r"""Information about the end user who created the integration."""
    log_url: str
    r"""URL to view detailed logs for the operation."""


class ConnectionFlowFailedWebhookPayloadData(BaseModel):
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""

    integration_category: ConnectionFlowFailedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""

    end_user: ConnectionFlowFailedWebhookPayloadEndUser
    r"""Information about the end user who created the integration."""

    log_url: str
    r"""URL to view detailed logs for the operation."""


class ConnectionFlowFailedWebhookPayloadTypedDict(TypedDict):
    id: str
    r"""Unique identifier for this webhook event"""
    type: ConnectionFlowFailedWebhookPayloadType
    r"""Type of the webhook event"""
    data: ConnectionFlowFailedWebhookPayloadDataTypedDict


class ConnectionFlowFailedWebhookPayload(BaseModel):
    id: str
    r"""Unique identifier for this webhook event"""

    type: ConnectionFlowFailedWebhookPayloadType
    r"""Type of the webhook event"""

    data: ConnectionFlowFailedWebhookPayloadData
