"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel
from typing import List, Literal
from typing_extensions import TypedDict


DataChangedWebhookPayloadType = Literal["data-changed",]
r"""Type of the webhook event"""


DataChangedWebhookPayloadIntegrationCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]
r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""


Name = Literal[
    "hris_legal_entities",
    "hris_locations",
    "hris_employees",
    "hris_absence_types",
    "hris_absences",
    "hris_employments",
    "hris_teams",
    "hris_time_off_balances",
    "hris_timesheets",
    "hris_employee_document_categories",
    "hris_performance_reviews",
    "hris_performance_review_cycles",
    "ats_users",
    "ats_jobs",
    "ats_job_postings",
    "ats_candidates",
    "ats_application_stages",
    "ats_applications",
    "ats_screening_questions",
    "ats_tags",
    "ats_interviews",
    "ats_offers",
    "ats_rejection_reasons",
    "hris_join_employees_teams",
    "ats_join_candidates_tags",
    "ats_join_jobs_application_stages",
    "ats_join_jobs_screening_questions",
    "ats_join_jobs_users",
    "ats_join_interviews_users",
]
r"""The name of the Kombo model or connection that changed."""


class ChangedModelTypedDict(TypedDict):
    r"""A model or connection that has changed in the integration."""

    name: Name
    r"""The name of the Kombo model or connection that changed."""


class ChangedModel(BaseModel):
    r"""A model or connection that has changed in the integration."""

    name: Name
    r"""The name of the Kombo model or connection that changed."""


class DataChangedWebhookPayloadDataTypedDict(TypedDict):
    integration_id: str
    r"""The unique identifier of the integration."""
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""
    integration_category: DataChangedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""
    changed_models: List[ChangedModelTypedDict]
    r"""List of data models and connections for which one or more records were created, updated, or deleted."""


class DataChangedWebhookPayloadData(BaseModel):
    integration_id: str
    r"""The unique identifier of the integration."""

    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""

    integration_category: DataChangedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""

    changed_models: List[ChangedModel]
    r"""List of data models and connections for which one or more records were created, updated, or deleted."""


class DataChangedWebhookPayloadTypedDict(TypedDict):
    id: str
    r"""Unique identifier for this webhook event"""
    type: DataChangedWebhookPayloadType
    r"""Type of the webhook event"""
    data: DataChangedWebhookPayloadDataTypedDict


class DataChangedWebhookPayload(BaseModel):
    id: str
    r"""Unique identifier for this webhook event"""

    type: DataChangedWebhookPayloadType
    r"""Type of the webhook event"""

    data: DataChangedWebhookPayloadData
