"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


GetAtsApplicationsPositiveResponseOutcome = Literal[
    "PENDING",
    "HIRED",
    "DECLINED",
]
r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
Kombo will always try to deliver this information as reliably as possible.
"""


class GetAtsApplicationsPositiveResponseAnswer7TypedDict(TypedDict):
    raw: NotRequired[Nullable[Any]]
    r"""We pass the original question data along so you can handle it."""


class GetAtsApplicationsPositiveResponseAnswer7(BaseModel):
    raw: OptionalNullable[Any] = UNSET
    r"""We pass the original question data along so you can handle it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["raw"]
        nullable_fields = ["raw"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionUnknownTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["UNKNOWN"]
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""


class GetAtsApplicationsPositiveResponseQuestionUnknown(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["UNKNOWN"], AfterValidator(validate_const("UNKNOWN"))],
        pydantic.Field(alias="type"),
    ] = "UNKNOWN"
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer7TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer7TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionUnknownTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer7(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer7

    question: GetAtsApplicationsPositiveResponseQuestionUnknown


class GetAtsApplicationsPositiveResponseAnswer6TypedDict(TypedDict):
    date_: Nullable[datetime]


class GetAtsApplicationsPositiveResponseAnswer6(BaseModel):
    date_: Annotated[Nullable[datetime], pydantic.Field(alias="date")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["date"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionDateTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["DATE"]


class GetAtsApplicationsPositiveResponseQuestionDate(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["DATE"], AfterValidator(validate_const("DATE"))],
        pydantic.Field(alias="type"),
    ] = "DATE"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer6TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer6TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionDateTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer6(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer6

    question: GetAtsApplicationsPositiveResponseQuestionDate


class GetAtsApplicationsPositiveResponseAnswer5TypedDict(TypedDict):
    number: Nullable[float]


class GetAtsApplicationsPositiveResponseAnswer5(BaseModel):
    number: Nullable[float]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["number"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionNumberTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["NUMBER"]


class GetAtsApplicationsPositiveResponseQuestionNumber(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["NUMBER"], AfterValidator(validate_const("NUMBER"))],
        pydantic.Field(alias="type"),
    ] = "NUMBER"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer5TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer5TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionNumberTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer5(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer5

    question: GetAtsApplicationsPositiveResponseQuestionNumber


class GetAtsApplicationsPositiveResponseAnswer4TypedDict(TypedDict):
    checked: Nullable[bool]


class GetAtsApplicationsPositiveResponseAnswer4(BaseModel):
    checked: Nullable[bool]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["checked"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionBooleanTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["BOOLEAN"]


class GetAtsApplicationsPositiveResponseQuestionBoolean(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["BOOLEAN"], AfterValidator(validate_const("BOOLEAN"))],
        pydantic.Field(alias="type"),
    ] = "BOOLEAN"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer4TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer4TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionBooleanTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer4(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer4

    question: GetAtsApplicationsPositiveResponseQuestionBoolean


class GetAtsApplicationsPositiveResponseAnswer3TypedDict(TypedDict):
    choices: NotRequired[List[str]]


class GetAtsApplicationsPositiveResponseAnswer3(BaseModel):
    choices: Optional[List[str]] = None


class GetAtsApplicationsPositiveResponseQuestionMultiSelectTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["MULTI_SELECT"]


class GetAtsApplicationsPositiveResponseQuestionMultiSelect(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[
            Literal["MULTI_SELECT"], AfterValidator(validate_const("MULTI_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "MULTI_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer3TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer3TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionMultiSelectTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer3(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer3

    question: GetAtsApplicationsPositiveResponseQuestionMultiSelect


class GetAtsApplicationsPositiveResponseAnswer2TypedDict(TypedDict):
    choice: Nullable[str]


class GetAtsApplicationsPositiveResponseAnswer2(BaseModel):
    choice: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["choice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionSingleSelectTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["SINGLE_SELECT"]


class GetAtsApplicationsPositiveResponseQuestionSingleSelect(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[
            Literal["SINGLE_SELECT"], AfterValidator(validate_const("SINGLE_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "SINGLE_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer2TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer2TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionSingleSelectTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer2(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer2

    question: GetAtsApplicationsPositiveResponseQuestionSingleSelect


class GetAtsApplicationsPositiveResponseAnswer1TypedDict(TypedDict):
    content: Nullable[str]


class GetAtsApplicationsPositiveResponseAnswer1(BaseModel):
    content: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseQuestionTextTypedDict(TypedDict):
    remote_id: Nullable[str]
    title: str
    type: Literal["TEXT"]


class GetAtsApplicationsPositiveResponseQuestionText(BaseModel):
    remote_id: Nullable[str]

    title: str

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer1TypedDict(TypedDict):
    answer: GetAtsApplicationsPositiveResponseAnswer1TypedDict
    question: GetAtsApplicationsPositiveResponseQuestionTextTypedDict


class GetAtsApplicationsPositiveResponseScreeningQuestionAnswer1(BaseModel):
    answer: GetAtsApplicationsPositiveResponseAnswer1

    question: GetAtsApplicationsPositiveResponseQuestionText


GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict = TypeAliasType(
    "GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict",
    Union[
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer1TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer2TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer3TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer4TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer5TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer6TypedDict,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer7TypedDict,
    ],
)


GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnion = TypeAliasType(
    "GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnion",
    Union[
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer1,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer2,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer3,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer4,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer5,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer6,
        GetAtsApplicationsPositiveResponseScreeningQuestionAnswer7,
    ],
)


class GetAtsApplicationsPositiveResponseEmailAddressTypedDict(TypedDict):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""
    email_address: NotRequired[Nullable[str]]


class GetAtsApplicationsPositiveResponseEmailAddress(BaseModel):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    email_address: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_address"]
        nullable_fields = ["email_address", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponsePhoneNumberTypedDict(TypedDict):
    phone_number: str
    type: NotRequired[Nullable[str]]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""


class GetAtsApplicationsPositiveResponsePhoneNumber(BaseModel):
    phone_number: str

    type: OptionalNullable[str] = UNSET
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type"]
        nullable_fields = ["type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseSocialMediaTypedDict(TypedDict):
    link: NotRequired[Nullable[str]]
    type: NotRequired[Nullable[str]]
    username: NotRequired[Nullable[str]]


class GetAtsApplicationsPositiveResponseSocialMedia(BaseModel):
    link: OptionalNullable[str] = UNSET

    type: OptionalNullable[str] = UNSET

    username: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["link", "type", "username"]
        nullable_fields = ["link", "type", "username"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseTagTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]


class GetAtsApplicationsPositiveResponseTag(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id", "name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseCandidateTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the candidate."""
    last_name: Nullable[str]
    r"""Last name of the candidate."""
    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""
    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""
    tags: List[GetAtsApplicationsPositiveResponseTagTypedDict]
    email_addresses: NotRequired[
        Nullable[List[GetAtsApplicationsPositiveResponseEmailAddressTypedDict]]
    ]
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""
    phone_numbers: NotRequired[
        Nullable[List[GetAtsApplicationsPositiveResponsePhoneNumberTypedDict]]
    ]
    r"""A list of phone numbers of the candidate."""
    social_media: NotRequired[
        Nullable[List[GetAtsApplicationsPositiveResponseSocialMediaTypedDict]]
    ]
    r"""List of social media accounts of the candidate."""


class GetAtsApplicationsPositiveResponseCandidate(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the candidate."""

    last_name: Nullable[str]
    r"""Last name of the candidate."""

    source: Nullable[str]
    r"""The hiring source of the candidate. If you're a job board or recruiting service, you can use this to validate which candidates applied through your service and ensure that the correct referral compensation is paid out."""

    remote_url: Nullable[str]
    r"""URL to the candidate profile in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated candidate profile URL is available, so you might need to fall back to the application URL."""

    tags: List[GetAtsApplicationsPositiveResponseTag]

    email_addresses: OptionalNullable[
        List[GetAtsApplicationsPositiveResponseEmailAddress]
    ] = UNSET
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""

    phone_numbers: OptionalNullable[
        List[GetAtsApplicationsPositiveResponsePhoneNumber]
    ] = UNSET
    r"""A list of phone numbers of the candidate."""

    social_media: OptionalNullable[
        List[GetAtsApplicationsPositiveResponseSocialMedia]
    ] = UNSET
    r"""List of social media accounts of the candidate."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_addresses", "phone_numbers", "social_media"]
        nullable_fields = [
            "first_name",
            "last_name",
            "email_addresses",
            "phone_numbers",
            "social_media",
            "source",
            "remote_url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseCurrentStageTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""
    index: Nullable[int]


class GetAtsApplicationsPositiveResponseCurrentStage(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""

    index: Nullable[int]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id", "name", "index"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseJobTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""Title of the job."""


class GetAtsApplicationsPositiveResponseJob(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""Title of the job."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseLocationTypedDict(TypedDict):
    r"""Location of the interview."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class GetAtsApplicationsPositiveResponseLocation(BaseModel):
    r"""Location of the interview."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InterviewTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    title: Nullable[str]
    r"""The title of the interview."""
    starting_at: Nullable[datetime]
    r"""The start time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    ending_at: Nullable[datetime]
    r"""The end time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    canceled: Nullable[bool]
    r"""Whether the interview was canceled or not. If we have no information, this field will be `null`."""
    location: NotRequired[Nullable[GetAtsApplicationsPositiveResponseLocationTypedDict]]
    r"""Location of the interview."""


class Interview(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    title: Nullable[str]
    r"""The title of the interview."""

    starting_at: Nullable[datetime]
    r"""The start time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    ending_at: Nullable[datetime]
    r"""The end time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    canceled: Nullable[bool]
    r"""Whether the interview was canceled or not. If we have no information, this field will be `null`."""

    location: OptionalNullable[GetAtsApplicationsPositiveResponseLocation] = UNSET
    r"""Location of the interview."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["location"]
        nullable_fields = [
            "remote_id",
            "title",
            "starting_at",
            "ending_at",
            "location",
            "canceled",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetAtsApplicationsPositiveResponseStatus = Literal[
    "ACCEPTED",
    "DECLINED",
    "SENT",
    "APPROVED",
    "DRAFT",
    "ABANDONED",
]
r"""The offer’s current status. The usual flow of statuses is as follows:
`DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

- `ACCEPTED`: The offer was accepted by the candidate.
- `DECLINED`: The offer was declined by the candidate.
- `SENT`: The offer was sent to the candidate.
- `APPROVED`: The draft was approved.
- `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
- `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

"""


class OfferTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    status: Nullable[GetAtsApplicationsPositiveResponseStatus]
    r"""The offer’s current status. The usual flow of statuses is as follows:
    `DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

    Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

    - `ACCEPTED`: The offer was accepted by the candidate.
    - `DECLINED`: The offer was declined by the candidate.
    - `SENT`: The offer was sent to the candidate.
    - `APPROVED`: The draft was approved.
    - `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
    - `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

    """


class Offer(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    status: Nullable[GetAtsApplicationsPositiveResponseStatus]
    r"""The offer’s current status. The usual flow of statuses is as follows:
    `DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

    Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

    - `ACCEPTED`: The offer was accepted by the candidate.
    - `DECLINED`: The offer was declined by the candidate.
    - `SENT`: The offer was sent to the candidate.
    - `APPROVED`: The draft was approved.
    - `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
    - `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["remote_id", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    outcome: Nullable[GetAtsApplicationsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """
    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""
    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    current_stage_id: Nullable[str]
    r"""ID of the current application stage"""
    job_id: Nullable[str]
    r"""The Kombo ID of the job which the candidate applied to. The ID can be used to retrieve the job from the `get jobs` endpoint."""
    candidate_id: Nullable[str]
    r"""The Kombo ID of the candidate who applied to the job. The ID can be used to retrieve the candidate from the `get candidates` endpoint."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    candidate: Nullable[GetAtsApplicationsPositiveResponseCandidateTypedDict]
    current_stage: Nullable[GetAtsApplicationsPositiveResponseCurrentStageTypedDict]
    job: Nullable[GetAtsApplicationsPositiveResponseJobTypedDict]
    interviews: List[InterviewTypedDict]
    offers: List[OfferTypedDict]
    screening_question_answers: NotRequired[
        Nullable[
            List[
                GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnionTypedDict
            ]
        ]
    ]
    r"""A list of answers to screening questions. The screening answer type `FILE` is currently unsupported."""


class GetAtsApplicationsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    outcome: Nullable[GetAtsApplicationsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """

    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""

    rejected_at: Nullable[datetime]
    r"""The time that the application was rejected.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    current_stage_id: Nullable[str]
    r"""ID of the current application stage"""

    job_id: Nullable[str]
    r"""The Kombo ID of the job which the candidate applied to. The ID can be used to retrieve the job from the `get jobs` endpoint."""

    candidate_id: Nullable[str]
    r"""The Kombo ID of the candidate who applied to the job. The ID can be used to retrieve the candidate from the `get candidates` endpoint."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    remote_url: Nullable[str]
    r"""URL to the application in the source ATS system. When embedding this in your system, please consider that not for all ATS a dedicated application URL is available, so you might need to fall back to the candidate URL."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    candidate: Nullable[GetAtsApplicationsPositiveResponseCandidate]

    current_stage: Nullable[GetAtsApplicationsPositiveResponseCurrentStage]

    job: Nullable[GetAtsApplicationsPositiveResponseJob]

    interviews: List[Interview]

    offers: List[Offer]

    screening_question_answers: OptionalNullable[
        List[GetAtsApplicationsPositiveResponseScreeningQuestionAnswerUnion]
    ] = UNSET
    r"""A list of answers to screening questions. The screening answer type `FILE` is currently unsupported."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["screening_question_answers"]
        nullable_fields = [
            "remote_id",
            "outcome",
            "rejection_reason_name",
            "rejected_at",
            "current_stage_id",
            "job_id",
            "candidate_id",
            "screening_question_answers",
            "custom_fields",
            "remote_url",
            "remote_deleted_at",
            "remote_created_at",
            "remote_updated_at",
            "candidate",
            "current_stage",
            "job",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetAtsApplicationsPositiveResponseResultTypedDict]


class GetAtsApplicationsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetAtsApplicationsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsApplicationsPositiveResponseTypedDict(TypedDict):
    data: GetAtsApplicationsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetAtsApplicationsPositiveResponse(BaseModel):
    data: GetAtsApplicationsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
