"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class GetAtsInterviewsPositiveResponseLocationTypedDict(TypedDict):
    r"""Location of the interview."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class GetAtsInterviewsPositiveResponseLocation(BaseModel):
    r"""Location of the interview."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UserTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the user."""
    last_name: Nullable[str]
    r"""Last name of the user."""
    email: NotRequired[Nullable[str]]
    r"""Email of the user. If the email address is invalid, it will be set to null."""


class User(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the user."""

    last_name: Nullable[str]
    r"""Last name of the user."""

    email: OptionalNullable[str] = UNSET
    r"""Email of the user. If the email address is invalid, it will be set to null."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email"]
        nullable_fields = ["remote_id", "first_name", "last_name", "email"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetAtsInterviewsPositiveResponseOutcome = Literal[
    "PENDING",
    "HIRED",
    "DECLINED",
]
r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
Kombo will always try to deliver this information as reliably as possible.
"""


class GetAtsInterviewsPositiveResponseEmailAddressTypedDict(TypedDict):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""
    email_address: NotRequired[Nullable[str]]


class GetAtsInterviewsPositiveResponseEmailAddress(BaseModel):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    email_address: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_address"]
        nullable_fields = ["email_address", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseCandidateTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the candidate."""
    last_name: Nullable[str]
    r"""Last name of the candidate."""
    email_addresses: NotRequired[
        Nullable[List[GetAtsInterviewsPositiveResponseEmailAddressTypedDict]]
    ]
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""


class GetAtsInterviewsPositiveResponseCandidate(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the candidate."""

    last_name: Nullable[str]
    r"""Last name of the candidate."""

    email_addresses: OptionalNullable[
        List[GetAtsInterviewsPositiveResponseEmailAddress]
    ] = UNSET
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_addresses"]
        nullable_fields = ["first_name", "last_name", "email_addresses"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseJobTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""Title of the job."""


class GetAtsInterviewsPositiveResponseJob(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""Title of the job."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseApplicationTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    outcome: Nullable[GetAtsInterviewsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """
    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""
    candidate: Nullable[GetAtsInterviewsPositiveResponseCandidateTypedDict]
    job: Nullable[GetAtsInterviewsPositiveResponseJobTypedDict]


class GetAtsInterviewsPositiveResponseApplication(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    outcome: Nullable[GetAtsInterviewsPositiveResponseOutcome]
    r"""Parsed status of the application. If Kombo identifies that the application was accepted and the candidate hired, it will be `HIRED`. If the application was rejected or the candidate declined, it will be `DECLINED`. If the application is still in process, it will be `PENDING`.
    Kombo will always try to deliver this information as reliably as possible.
    """

    rejection_reason_name: Nullable[str]
    r"""Reason for the rejection of the candidate."""

    candidate: Nullable[GetAtsInterviewsPositiveResponseCandidate]

    job: Nullable[GetAtsInterviewsPositiveResponseJob]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "remote_id",
            "outcome",
            "rejection_reason_name",
            "candidate",
            "job",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    title: Nullable[str]
    r"""The title of the interview."""
    starting_at: Nullable[datetime]
    r"""The start time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    ending_at: Nullable[datetime]
    r"""The end time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    application_id: Nullable[str]
    r"""The Kombo ID of the application this interview belongs to. The ID can be used to retrieve the application from the `get applications` endpoint."""
    stage_id: Nullable[str]
    r"""If a system specifies to which stage this interview belongs to, this field will be the Kombo ID of the application stage. The ID can be used to retrieve the stage from the `get application stages` endpoint."""
    canceled: Nullable[bool]
    r"""Whether the interview was canceled or not. If we have no information, this field will be `null`."""
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    users: List[UserTypedDict]
    application: Nullable[GetAtsInterviewsPositiveResponseApplicationTypedDict]
    location: NotRequired[Nullable[GetAtsInterviewsPositiveResponseLocationTypedDict]]
    r"""Location of the interview."""


class GetAtsInterviewsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    title: Nullable[str]
    r"""The title of the interview."""

    starting_at: Nullable[datetime]
    r"""The start time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    ending_at: Nullable[datetime]
    r"""The end time of the interview.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    application_id: Nullable[str]
    r"""The Kombo ID of the application this interview belongs to. The ID can be used to retrieve the application from the `get applications` endpoint."""

    stage_id: Nullable[str]
    r"""If a system specifies to which stage this interview belongs to, this field will be the Kombo ID of the application stage. The ID can be used to retrieve the stage from the `get application stages` endpoint."""

    canceled: Nullable[bool]
    r"""Whether the interview was canceled or not. If we have no information, this field will be `null`."""

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    users: List[User]

    application: Nullable[GetAtsInterviewsPositiveResponseApplication]

    location: OptionalNullable[GetAtsInterviewsPositiveResponseLocation] = UNSET
    r"""Location of the interview."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["location"]
        nullable_fields = [
            "remote_id",
            "title",
            "starting_at",
            "ending_at",
            "location",
            "application_id",
            "stage_id",
            "canceled",
            "remote_created_at",
            "remote_updated_at",
            "remote_deleted_at",
            "application",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetAtsInterviewsPositiveResponseResultTypedDict]


class GetAtsInterviewsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetAtsInterviewsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsInterviewsPositiveResponseTypedDict(TypedDict):
    data: GetAtsInterviewsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetAtsInterviewsPositiveResponse(BaseModel):
    data: GetAtsInterviewsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
