"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .getatsjobspositiveresponse import (
    GetAtsJobsPositiveResponse,
    GetAtsJobsPositiveResponseTypedDict,
)
from datetime import datetime
from kombo.types import BaseModel
from kombo.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Awaitable, Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GetAtsJobsGlobalsTypedDict(TypedDict):
    integration_id: NotRequired[str]
    r"""ID of the integration you want to interact with."""


class GetAtsJobsGlobals(BaseModel):
    integration_id: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Integration-Id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""ID of the integration you want to interact with."""


class GetAtsJobsRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""
    page_size: NotRequired[int]
    r"""The number of results to return per page. Maximum is 250."""
    updated_after: NotRequired[datetime]
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """
    include_deleted: NotRequired[bool]
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""
    ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""
    remote_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of remote IDs."""
    job_codes: NotRequired[List[str]]
    r"""Filter by a comma-separated list of job codes."""
    post_url: NotRequired[str]
    r"""Filter by the `post_url` field. Can be used to find a job based on its public posting URL."""
    statuses: NotRequired[List[str]]
    r"""Filter by a comma-separated list of `OPEN`, `CLOSED`, `DRAFT`, `ARCHIVED`

    Leave this blank to get results matching all values.
    """
    employment_types: NotRequired[List[str]]
    r"""Filter by a comma-separated list of `FULL_TIME`, `PART_TIME`, `CONTRACT`, `SEASONAL`, `INTERNSHIP`

    Leave this blank to get results matching all values.
    """
    visibilities: NotRequired[List[str]]
    r"""Filter by a comma-separated list of `PUBLIC`, `INTERNAL`, `UNLISTED`, `CONFIDENTIAL`

    Leave this blank to get results matching all values.
    """
    remote_created_after: NotRequired[datetime]
    r"""Filter jobs by the day they were created in the remote system. This allows you to get jobs that were created on or after a certain day."""
    name_contains: NotRequired[str]
    r"""Filter by the `name` field. Can be used to find a job by keywords present in the job name."""


class GetAtsJobsRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""

    page_size: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""The number of results to return per page. Maximum is 250."""

    updated_after: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """

    include_deleted: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""

    ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""

    remote_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of remote IDs."""

    job_codes: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of job codes."""

    post_url: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by the `post_url` field. Can be used to find a job based on its public posting URL."""

    statuses: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of `OPEN`, `CLOSED`, `DRAFT`, `ARCHIVED`

    Leave this blank to get results matching all values.
    """

    employment_types: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of `FULL_TIME`, `PART_TIME`, `CONTRACT`, `SEASONAL`, `INTERNSHIP`

    Leave this blank to get results matching all values.
    """

    visibilities: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of `PUBLIC`, `INTERNAL`, `UNLISTED`, `CONFIDENTIAL`

    Leave this blank to get results matching all values.
    """

    remote_created_after: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter jobs by the day they were created in the remote system. This allows you to get jobs that were created on or after a certain day."""

    name_contains: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by the `name` field. Can be used to find a job by keywords present in the job name."""


class GetAtsJobsResponseTypedDict(TypedDict):
    result: GetAtsJobsPositiveResponseTypedDict


class GetAtsJobsResponse(BaseModel):
    next: Union[
        Callable[[], Optional[GetAtsJobsResponse]],
        Callable[[], Awaitable[Optional[GetAtsJobsResponse]]],
    ]

    result: GetAtsJobsPositiveResponse
