"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from kombo.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


GetAtsJobsPositiveResponseEmploymentType = Union[
    Literal[
        "FULL_TIME",
        "PART_TIME",
        "CONTRACT",
        "SEASONAL",
        "INTERNSHIP",
    ],
    UnrecognizedStr,
]


GetAtsJobsPositiveResponseStatus = Union[
    Literal[
        "OPEN",
        "CLOSED",
        "DRAFT",
        "ARCHIVED",
    ],
    UnrecognizedStr,
]


Visibility = Union[
    Literal[
        "PUBLIC",
        "INTERNAL",
        "UNLISTED",
        "CONFIDENTIAL",
    ],
    UnrecognizedStr,
]


RemoteWorkStatus = Union[
    Literal[
        "REMOTE",
        "HYBRID",
        "TEMPORARY",
        "ON_SITE",
    ],
    UnrecognizedStr,
]


SalaryPeriod = Union[
    Literal[
        "YEAR",
        "MONTH",
        "TWO_WEEKS",
        "WEEK",
        "DAY",
        "HOUR",
    ],
    UnrecognizedStr,
]


class GetAtsJobsPositiveResponseLocationTypedDict(TypedDict):
    r"""The location of the listed job."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class GetAtsJobsPositiveResponseLocation(BaseModel):
    r"""The location of the listed job."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StageTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""
    index: NotRequired[Nullable[int]]
    r"""Numeric index following the order of the stages if they are ordered in the underlying tool."""


class Stage(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The application stage name. For example, \"Initial Screening\"."""

    index: OptionalNullable[int] = UNSET
    r"""Numeric index following the order of the stages if they are ordered in the underlying tool."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["index"]
        nullable_fields = ["remote_id", "name", "index"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FormatUnknownTypedDict(TypedDict):
    raw_question: NotRequired[Any]
    r"""We pass the original question data along so you can handle it."""
    type: Literal["UNKNOWN"]
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""


class FormatUnknown(BaseModel):
    raw_question: Optional[Any] = None
    r"""We pass the original question data along so you can handle it."""

    TYPE: Annotated[
        Annotated[Literal["UNKNOWN"], AfterValidator(validate_const("UNKNOWN"))],
        pydantic.Field(alias="type"),
    ] = "UNKNOWN"
    r"""When we're not able to map a specific question type yet, we will return this type. Every `UNKNOWN` question will also be parsed and unified by us at some point."""


class FormatInformationTypedDict(TypedDict):
    type: Literal["INFORMATION"]
    r"""This is just a text block."""


class FormatInformation(BaseModel):
    TYPE: Annotated[
        Annotated[
            Literal["INFORMATION"], AfterValidator(validate_const("INFORMATION"))
        ],
        pydantic.Field(alias="type"),
    ] = "INFORMATION"
    r"""This is just a text block."""


class Option2TypedDict(TypedDict):
    id: str
    r"""The Kombo ID of this question option. Use this ID to specify the answer to this question."""
    name: str
    r"""Content of the question option."""
    remote_id: NotRequired[Nullable[str]]
    r"""ID in the connected ATS. This might be null as some systems only use the name to identify the option."""


class Option2(BaseModel):
    id: str
    r"""The Kombo ID of this question option. Use this ID to specify the answer to this question."""

    name: str
    r"""Content of the question option."""

    remote_id: OptionalNullable[str] = UNSET
    r"""ID in the connected ATS. This might be null as some systems only use the name to identify the option."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["remote_id"]
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FormatMultiSelectTypedDict(TypedDict):
    options: List[Option2TypedDict]
    type: Literal["MULTI_SELECT"]


class FormatMultiSelect(BaseModel):
    options: List[Option2]

    TYPE: Annotated[
        Annotated[
            Literal["MULTI_SELECT"], AfterValidator(validate_const("MULTI_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "MULTI_SELECT"


class FormatDateTypedDict(TypedDict):
    type: Literal["DATE"]


class FormatDate(BaseModel):
    TYPE: Annotated[
        Annotated[Literal["DATE"], AfterValidator(validate_const("DATE"))],
        pydantic.Field(alias="type"),
    ] = "DATE"


class FormatBooleanTypedDict(TypedDict):
    type: Literal["BOOLEAN"]


class FormatBoolean(BaseModel):
    TYPE: Annotated[
        Annotated[Literal["BOOLEAN"], AfterValidator(validate_const("BOOLEAN"))],
        pydantic.Field(alias="type"),
    ] = "BOOLEAN"


DisplayType3 = Literal[
    "DROPDOWN",
    "RADIO",
]


class Option1TypedDict(TypedDict):
    id: str
    r"""The Kombo ID of this question option. Use this ID to specify the answer to this question."""
    name: str
    r"""Content of the question option."""
    remote_id: NotRequired[Nullable[str]]
    r"""ID in the connected ATS. This might be null as some systems only use the name to identify the option."""


class Option1(BaseModel):
    id: str
    r"""The Kombo ID of this question option. Use this ID to specify the answer to this question."""

    name: str
    r"""Content of the question option."""

    remote_id: OptionalNullable[str] = UNSET
    r"""ID in the connected ATS. This might be null as some systems only use the name to identify the option."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["remote_id"]
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FormatSingleSelectTypedDict(TypedDict):
    options: List[Option1TypedDict]
    display_type: NotRequired[Nullable[DisplayType3]]
    type: Literal["SINGLE_SELECT"]


class FormatSingleSelect(BaseModel):
    options: List[Option1]

    display_type: OptionalNullable[DisplayType3] = UNSET

    TYPE: Annotated[
        Annotated[
            Literal["SINGLE_SELECT"], AfterValidator(validate_const("SINGLE_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "SINGLE_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["display_type"]
        nullable_fields = ["display_type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FormatFileTypedDict(TypedDict):
    accepted_mime_types: NotRequired[Nullable[List[str]]]
    max_file_size_bytes: NotRequired[Nullable[int]]
    type: Literal["FILE"]


class FormatFile(BaseModel):
    accepted_mime_types: OptionalNullable[List[str]] = UNSET

    max_file_size_bytes: OptionalNullable[int] = UNSET

    TYPE: Annotated[
        Annotated[Literal["FILE"], AfterValidator(validate_const("FILE"))],
        pydantic.Field(alias="type"),
    ] = "FILE"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accepted_mime_types", "max_file_size_bytes"]
        nullable_fields = ["accepted_mime_types", "max_file_size_bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


DisplayType2 = Literal[
    "SLIDER",
    "FIELD",
]


class FormatNumberTypedDict(TypedDict):
    display_type: NotRequired[Nullable[DisplayType2]]
    max: NotRequired[Nullable[float]]
    min: NotRequired[Nullable[float]]
    type: Literal["NUMBER"]


class FormatNumber(BaseModel):
    display_type: OptionalNullable[DisplayType2] = "FIELD"

    max: OptionalNullable[float] = UNSET

    min: OptionalNullable[float] = UNSET

    TYPE: Annotated[
        Annotated[Literal["NUMBER"], AfterValidator(validate_const("NUMBER"))],
        pydantic.Field(alias="type"),
    ] = "NUMBER"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["display_type", "max", "min"]
        nullable_fields = ["display_type", "max", "min"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


DisplayType1 = Literal[
    "SINGLE_LINE",
    "MULTI_LINE",
    "EMAIL",
    "URL",
]
r"""If unavailable, we recommend displaying a single-line input."""


class FormatTextTypedDict(TypedDict):
    display_type: NotRequired[Nullable[DisplayType1]]
    r"""If unavailable, we recommend displaying a single-line input."""
    max_length: NotRequired[Nullable[int]]
    type: Literal["TEXT"]


class FormatText(BaseModel):
    display_type: OptionalNullable[DisplayType1] = UNSET
    r"""If unavailable, we recommend displaying a single-line input."""

    max_length: OptionalNullable[int] = UNSET

    TYPE: Annotated[
        Annotated[Literal["TEXT"], AfterValidator(validate_const("TEXT"))],
        pydantic.Field(alias="type"),
    ] = "TEXT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["display_type", "max_length"]
        nullable_fields = ["display_type", "max_length"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


FormatTypedDict = TypeAliasType(
    "FormatTypedDict",
    Union[
        FormatBooleanTypedDict,
        FormatDateTypedDict,
        FormatInformationTypedDict,
        FormatMultiSelectTypedDict,
        FormatUnknownTypedDict,
        FormatTextTypedDict,
        FormatFileTypedDict,
        FormatSingleSelectTypedDict,
        FormatNumberTypedDict,
    ],
)


Format = TypeAliasType(
    "Format",
    Union[
        FormatBoolean,
        FormatDate,
        FormatInformation,
        FormatMultiSelect,
        FormatUnknown,
        FormatText,
        FormatFile,
        FormatSingleSelect,
        FormatNumber,
    ],
)


GetAtsJobsPositiveResponseCategory = Literal[
    "EEO",
    "DEMOGRAPHIC",
]
r"""The category of the screening question (default `null`). \"EEO\" questions are related to Equal Employment Opportunity (e.g. \"What is your veteran status?\"), while \"DEMOGRAPHIC\" questions are for other diversity and demographic data collection."""


PreconditionOptionsTypedDict = TypeAliasType(
    "PreconditionOptionsTypedDict", Union[List[str], List[bool]]
)
r"""Where the screening question specified by `precondition_question_id` is of type `MULTI_SELECT` or `SINGLE_SELECT`, this is an array of Kombo IDs describing the valid options. If the question is of type `BOOLEAN`, this is an array containing either `true` or `false`."""


PreconditionOptions = TypeAliasType("PreconditionOptions", Union[List[str], List[bool]])
r"""Where the screening question specified by `precondition_question_id` is of type `MULTI_SELECT` or `SINGLE_SELECT`, this is an array of Kombo IDs describing the valid options. If the question is of type `BOOLEAN`, this is an array containing either `true` or `false`."""


class ScreeningQuestionTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    title: Nullable[str]
    description: Nullable[str]
    r"""Additional instructions or context. Typically a short sentence, but sometimes a long detailed description (e.g., for EEO questions). May include HTML for extra formatting."""
    category: Nullable[GetAtsJobsPositiveResponseCategory]
    r"""The category of the screening question (default `null`). \"EEO\" questions are related to Equal Employment Opportunity (e.g. \"What is your veteran status?\"), while \"DEMOGRAPHIC\" questions are for other diversity and demographic data collection."""
    required: Nullable[bool]
    format_: NotRequired[Nullable[FormatTypedDict]]
    index: NotRequired[Nullable[int]]
    precondition_question_id: NotRequired[Nullable[str]]
    r"""The Kombo ID of another screening question. Only display this question if the specified \"precondition question\" is answered with one of the values in `precondition_options`."""
    precondition_options: NotRequired[Nullable[PreconditionOptionsTypedDict]]
    r"""Where the screening question specified by `precondition_question_id` is of type `MULTI_SELECT` or `SINGLE_SELECT`, this is an array of Kombo IDs describing the valid options. If the question is of type `BOOLEAN`, this is an array containing either `true` or `false`."""


class ScreeningQuestion(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    title: Nullable[str]

    description: Nullable[str]
    r"""Additional instructions or context. Typically a short sentence, but sometimes a long detailed description (e.g., for EEO questions). May include HTML for extra formatting."""

    category: Nullable[GetAtsJobsPositiveResponseCategory]
    r"""The category of the screening question (default `null`). \"EEO\" questions are related to Equal Employment Opportunity (e.g. \"What is your veteran status?\"), while \"DEMOGRAPHIC\" questions are for other diversity and demographic data collection."""

    required: Nullable[bool]

    format_: Annotated[OptionalNullable[Format], pydantic.Field(alias="format")] = UNSET

    index: OptionalNullable[int] = UNSET

    precondition_question_id: OptionalNullable[str] = UNSET
    r"""The Kombo ID of another screening question. Only display this question if the specified \"precondition question\" is answered with one of the values in `precondition_options`."""

    precondition_options: OptionalNullable[PreconditionOptions] = UNSET
    r"""Where the screening question specified by `precondition_question_id` is of type `MULTI_SELECT` or `SINGLE_SELECT`, this is an array of Kombo IDs describing the valid options. If the question is of type `BOOLEAN`, this is an array containing either `true` or `false`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "format",
            "index",
            "precondition_question_id",
            "precondition_options",
        ]
        nullable_fields = [
            "remote_id",
            "title",
            "description",
            "format",
            "category",
            "index",
            "required",
            "precondition_question_id",
            "precondition_options",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


JobPostingStatus = Literal[
    "ACTIVE",
    "INACTIVE",
    "DRAFT",
]
r"""The job posting’s current status."""


JobPostingVisibility = Literal[
    "PUBLIC",
    "INTERNAL",
    "UNLISTED",
]


class JobPostingTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    title: Nullable[str]
    r"""The job posting’s title."""
    description_html: Nullable[str]
    r"""The job posting’s description in HTML format."""
    status: Nullable[JobPostingStatus]
    r"""The job posting’s current status."""
    visibility: Nullable[JobPostingVisibility]
    url: Nullable[str]
    r"""The public URL to the job posting on the ATS platform."""


class JobPosting(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    title: Nullable[str]
    r"""The job posting’s title."""

    description_html: Nullable[str]
    r"""The job posting’s description in HTML format."""

    status: Nullable[JobPostingStatus]
    r"""The job posting’s current status."""

    visibility: Nullable[JobPostingVisibility]

    url: Nullable[str]
    r"""The public URL to the job posting on the ATS platform."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "remote_id",
            "title",
            "description_html",
            "status",
            "visibility",
            "url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetAtsJobsPositiveResponseHiringTeamRole = Literal[
    "RECRUITER",
    "HIRING_MANAGER",
]


class GetAtsJobsPositiveResponseHiringTeamTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the user."""
    last_name: Nullable[str]
    r"""Last name of the user."""
    hiring_team_roles: List[GetAtsJobsPositiveResponseHiringTeamRole]
    r"""Array of the roles of the user for this specific job. Currently only `RECRUITER` and `HIRING_MANAGER` are mapped into our unified schema."""
    email: NotRequired[Nullable[str]]
    r"""Email of the user. If the email address is invalid, it will be set to null."""


class GetAtsJobsPositiveResponseHiringTeam(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the user."""

    last_name: Nullable[str]
    r"""Last name of the user."""

    hiring_team_roles: List[GetAtsJobsPositiveResponseHiringTeamRole]
    r"""Array of the roles of the user for this specific job. Currently only `RECRUITER` and `HIRING_MANAGER` are mapped into our unified schema."""

    email: OptionalNullable[str] = UNSET
    r"""Email of the user. If the email address is invalid, it will be set to null."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email"]
        nullable_fields = ["remote_id", "first_name", "last_name", "email"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsJobsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""Title of the job."""
    job_code: Nullable[str]
    r"""The human readable job code. Some systems expose this as the Requisition Code/ID."""
    description: Nullable[str]
    r"""Description of the job. This field is usually returned as HTML."""
    confidential: Nullable[bool]
    r"""**(⚠️ Deprecated)** It makes more sense to store the visibility of a job in an enum. Therefore, we introduced the `visibility` enum on jobs."""
    weekly_hours: Nullable[float]
    r"""The number of hours per week an employee is expected to work."""
    category: Nullable[str]
    r"""The category of the job (often the job industry). The original string is passed through, for example \"Information Technology\", \"Quality Assurance\", \"Marketing\"."""
    department: Nullable[str]
    r"""The internal department or team the job belongs to. The original string is passed through, for example \"IT/Operations\", \"Engineering - Platform\", \"Customer Success\"."""
    post_url: Nullable[str]
    r"""The public job posting URL of the ATS itself. This can be used by external job boards to redirect applicants."""
    experience_level: Nullable[str]
    r"""The role's seniority or experience level. The original string is passed through, for example \"Mid-Senior Level\", \"5+ years\", \"Associate\", \"IC3\"."""
    salary_amount: Nullable[float]
    r"""The salary amount in the given currency."""
    salary_amount_from: Nullable[float]
    r"""The lower bound of the salary range."""
    salary_amount_to: Nullable[float]
    r"""The upper bound of the salary range."""
    salary_currency: Nullable[str]
    r"""Salary currency usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    remote_url: Nullable[str]
    r"""URL to the job posting in the source ATS system."""
    opened_at: Nullable[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    closed_at: Nullable[datetime]
    r"""The date the job closed or is scheduled to close. A future value typically indicates the job remains open for applications until that date.

    Please use the `status` and `visibility` fields to determine if a job can be published.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    contact_id: Nullable[str]
    r"""**(⚠️ Deprecated)** The user ID of the contact person for this job. We strongly recommend using the new `hiring_team` property instead as it provides more complete and accurate information about the ATS users connected to a job."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    stages: List[StageTypedDict]
    r"""Application stages a candidate can be in for this particular job."""
    screening_questions: List[ScreeningQuestionTypedDict]
    job_postings: List[JobPostingTypedDict]
    hiring_team: List[GetAtsJobsPositiveResponseHiringTeamTypedDict]
    r"""The hiring team allows you to sync users into your system who can access the job and its applications."""
    employment_type: NotRequired[Nullable[GetAtsJobsPositiveResponseEmploymentType]]
    r"""The type of employment contract. In rare cases where can't find a clear mapping, the original string is passed through."""
    status: NotRequired[Nullable[GetAtsJobsPositiveResponseStatus]]
    r"""The job's current status.

    *Note: For any checks (e.g., \"can we publish this job?\"), always evaluate both `status` and `visibility`. For example, a job can be `status=OPEN` with `visibility=INTERNAL`, meaning only existing employees can apply.*

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    visibility: NotRequired[Nullable[Visibility]]
    r"""Describes the visibility of the job:

    - `PUBLIC`: visible to everyone, published on a job board
    - `INTERNAL`: only visible to employees of the company itself
    - `UNLISTED`: anyone can apply but only if they have the link to it
    - `CONFIDENTIAL`: nobody can apply and it's only visible in the ATS to people who were invited to it

    *Note: For any checks (e.g., \"can we publish this job?\"), always evaluate both `status` and `visibility`.*

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    remote_work_status: NotRequired[Nullable[RemoteWorkStatus]]
    r"""Defines if the job supports remote work and if so, to what extent."""
    salary_period: NotRequired[Nullable[SalaryPeriod]]
    r"""The period of time over which the salary amount is paid (not equal to the pay frequency). In rare cases where we can’t find a clear mapping, the original string is passed through."""
    location: NotRequired[Nullable[GetAtsJobsPositiveResponseLocationTypedDict]]
    r"""The location of the listed job."""


class GetAtsJobsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""Title of the job."""

    job_code: Nullable[str]
    r"""The human readable job code. Some systems expose this as the Requisition Code/ID."""

    description: Nullable[str]
    r"""Description of the job. This field is usually returned as HTML."""

    confidential: Annotated[
        Nullable[bool],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]
    r"""**(⚠️ Deprecated)** It makes more sense to store the visibility of a job in an enum. Therefore, we introduced the `visibility` enum on jobs."""

    weekly_hours: Nullable[float]
    r"""The number of hours per week an employee is expected to work."""

    category: Nullable[str]
    r"""The category of the job (often the job industry). The original string is passed through, for example \"Information Technology\", \"Quality Assurance\", \"Marketing\"."""

    department: Nullable[str]
    r"""The internal department or team the job belongs to. The original string is passed through, for example \"IT/Operations\", \"Engineering - Platform\", \"Customer Success\"."""

    post_url: Nullable[str]
    r"""The public job posting URL of the ATS itself. This can be used by external job boards to redirect applicants."""

    experience_level: Nullable[str]
    r"""The role's seniority or experience level. The original string is passed through, for example \"Mid-Senior Level\", \"5+ years\", \"Associate\", \"IC3\"."""

    salary_amount: Nullable[float]
    r"""The salary amount in the given currency."""

    salary_amount_from: Nullable[float]
    r"""The lower bound of the salary range."""

    salary_amount_to: Nullable[float]
    r"""The upper bound of the salary range."""

    salary_currency: Nullable[str]
    r"""Salary currency usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    remote_url: Nullable[str]
    r"""URL to the job posting in the source ATS system."""

    opened_at: Nullable[datetime]
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    closed_at: Nullable[datetime]
    r"""The date the job closed or is scheduled to close. A future value typically indicates the job remains open for applications until that date.

    Please use the `status` and `visibility` fields to determine if a job can be published.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    contact_id: Annotated[
        Nullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]
    r"""**(⚠️ Deprecated)** The user ID of the contact person for this job. We strongly recommend using the new `hiring_team` property instead as it provides more complete and accurate information about the ATS users connected to a job."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    stages: List[Stage]
    r"""Application stages a candidate can be in for this particular job."""

    screening_questions: List[ScreeningQuestion]

    job_postings: List[JobPosting]

    hiring_team: List[GetAtsJobsPositiveResponseHiringTeam]
    r"""The hiring team allows you to sync users into your system who can access the job and its applications."""

    employment_type: Annotated[
        OptionalNullable[GetAtsJobsPositiveResponseEmploymentType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The type of employment contract. In rare cases where can't find a clear mapping, the original string is passed through."""

    status: Annotated[
        OptionalNullable[GetAtsJobsPositiveResponseStatus],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The job's current status.

    *Note: For any checks (e.g., \"can we publish this job?\"), always evaluate both `status` and `visibility`. For example, a job can be `status=OPEN` with `visibility=INTERNAL`, meaning only existing employees can apply.*

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    visibility: Annotated[
        OptionalNullable[Visibility], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Describes the visibility of the job:

    - `PUBLIC`: visible to everyone, published on a job board
    - `INTERNAL`: only visible to employees of the company itself
    - `UNLISTED`: anyone can apply but only if they have the link to it
    - `CONFIDENTIAL`: nobody can apply and it's only visible in the ATS to people who were invited to it

    *Note: For any checks (e.g., \"can we publish this job?\"), always evaluate both `status` and `visibility`.*

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    remote_work_status: Annotated[
        OptionalNullable[RemoteWorkStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Defines if the job supports remote work and if so, to what extent."""

    salary_period: Annotated[
        OptionalNullable[SalaryPeriod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The period of time over which the salary amount is paid (not equal to the pay frequency). In rare cases where we can’t find a clear mapping, the original string is passed through."""

    location: OptionalNullable[GetAtsJobsPositiveResponseLocation] = UNSET
    r"""The location of the listed job."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "employment_type",
            "status",
            "visibility",
            "remote_work_status",
            "salary_period",
            "location",
        ]
        nullable_fields = [
            "name",
            "job_code",
            "description",
            "confidential",
            "weekly_hours",
            "employment_type",
            "status",
            "visibility",
            "category",
            "department",
            "post_url",
            "experience_level",
            "remote_work_status",
            "salary_amount",
            "salary_amount_from",
            "salary_amount_to",
            "salary_currency",
            "salary_period",
            "location",
            "custom_fields",
            "remote_url",
            "opened_at",
            "closed_at",
            "remote_created_at",
            "remote_updated_at",
            "contact_id",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsJobsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetAtsJobsPositiveResponseResultTypedDict]


class GetAtsJobsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetAtsJobsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsJobsPositiveResponseTypedDict(TypedDict):
    data: GetAtsJobsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetAtsJobsPositiveResponse(BaseModel):
    data: GetAtsJobsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
