"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal
from typing_extensions import Annotated, NotRequired, TypedDict


GetAtsOffersPositiveResponseStatus = Literal[
    "ACCEPTED",
    "DECLINED",
    "SENT",
    "APPROVED",
    "DRAFT",
    "ABANDONED",
]
r"""The offer’s current status. The usual flow of statuses is as follows:
`DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

- `ACCEPTED`: The offer was accepted by the candidate.
- `DECLINED`: The offer was declined by the candidate.
- `SENT`: The offer was sent to the candidate.
- `APPROVED`: The draft was approved.
- `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
- `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

"""


class GetAtsOffersPositiveResponseEmailAddressTypedDict(TypedDict):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""
    email_address: NotRequired[Nullable[str]]


class GetAtsOffersPositiveResponseEmailAddress(BaseModel):
    type: Nullable[str]
    r"""Kombo exposes type information through this field. If we don't get any information from the tool, we will set this to `null`."""

    email_address: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_address"]
        nullable_fields = ["email_address", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseCandidateTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""First name of the candidate."""
    last_name: Nullable[str]
    r"""Last name of the candidate."""
    email_addresses: NotRequired[
        Nullable[List[GetAtsOffersPositiveResponseEmailAddressTypedDict]]
    ]
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""


class GetAtsOffersPositiveResponseCandidate(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""First name of the candidate."""

    last_name: Nullable[str]
    r"""Last name of the candidate."""

    email_addresses: OptionalNullable[
        List[GetAtsOffersPositiveResponseEmailAddress]
    ] = UNSET
    r"""A list of email addresses of the candidate with an optional type. If an email address is invalid, it will be filtered out."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email_addresses"]
        nullable_fields = ["first_name", "last_name", "email_addresses"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseJobTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""Title of the job."""


class GetAtsOffersPositiveResponseJob(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""Title of the job."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseApplicationTypedDict(TypedDict):
    candidate: Nullable[GetAtsOffersPositiveResponseCandidateTypedDict]
    job: Nullable[GetAtsOffersPositiveResponseJobTypedDict]


class GetAtsOffersPositiveResponseApplication(BaseModel):
    candidate: Nullable[GetAtsOffersPositiveResponseCandidate]

    job: Nullable[GetAtsOffersPositiveResponseJob]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["candidate", "job"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    status: Nullable[GetAtsOffersPositiveResponseStatus]
    r"""The offer’s current status. The usual flow of statuses is as follows:
    `DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

    Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

    - `ACCEPTED`: The offer was accepted by the candidate.
    - `DECLINED`: The offer was declined by the candidate.
    - `SENT`: The offer was sent to the candidate.
    - `APPROVED`: The draft was approved.
    - `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
    - `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

    """
    employment_start_date: Nullable[datetime]
    r"""The date when the employment described by the offer starts. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    application_id: Nullable[str]
    r"""The Kombo ID of the application this interview belongs to. The ID can be used to retrieve the application from the `get applications` endpoint."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    application: Nullable[GetAtsOffersPositiveResponseApplicationTypedDict]


class GetAtsOffersPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    status: Nullable[GetAtsOffersPositiveResponseStatus]
    r"""The offer’s current status. The usual flow of statuses is as follows:
    `DRAFT` -> `APPROVED` -> `SENT` -> `ACCEPTED` or `DECLINED`.

    Please note that not all systems will expose all statuses. For example, most systems do not include the `APPROVED` status

    - `ACCEPTED`: The offer was accepted by the candidate.
    - `DECLINED`: The offer was declined by the candidate.
    - `SENT`: The offer was sent to the candidate.
    - `APPROVED`: The draft was approved.
    - `DRAFT`: The offer is a draft and has not yet been sent to the candidate.
    - `ABANDONED`: The offer has expired or is no longer valid and should not be considered.

    """

    employment_start_date: Nullable[datetime]
    r"""The date when the employment described by the offer starts. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    application_id: Nullable[str]
    r"""The Kombo ID of the application this interview belongs to. The ID can be used to retrieve the application from the `get applications` endpoint."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_updated_at: Nullable[datetime]
    r"""A timestamp retrieved from the remote system, describing when the resource was last updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    application: Nullable[GetAtsOffersPositiveResponseApplication]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "remote_id",
            "status",
            "employment_start_date",
            "application_id",
            "custom_fields",
            "remote_deleted_at",
            "remote_created_at",
            "remote_updated_at",
            "application",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetAtsOffersPositiveResponseResultTypedDict]


class GetAtsOffersPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetAtsOffersPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetAtsOffersPositiveResponseTypedDict(TypedDict):
    data: GetAtsOffersPositiveResponseDataTypedDict
    status: Literal["success"]


class GetAtsOffersPositiveResponse(BaseModel):
    data: GetAtsOffersPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
