"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gethrisabsencespositiveresponse import (
    GetHrisAbsencesPositiveResponse,
    GetHrisAbsencesPositiveResponseTypedDict,
)
from datetime import datetime
from kombo.types import BaseModel
from kombo.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Awaitable, Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GetHrisAbsencesGlobalsTypedDict(TypedDict):
    integration_id: NotRequired[str]
    r"""ID of the integration you want to interact with."""


class GetHrisAbsencesGlobals(BaseModel):
    integration_id: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Integration-Id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""ID of the integration you want to interact with."""


class GetHrisAbsencesRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""
    page_size: NotRequired[int]
    r"""The number of results to return per page. Maximum is 250."""
    updated_after: NotRequired[datetime]
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """
    include_deleted: NotRequired[bool]
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""
    ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""
    remote_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of remote IDs."""
    date_from: NotRequired[datetime]
    r"""Filter for all the absences that either start _or_ haven't ended yet on/after this day. If you imagine a calendar displaying absences, this defines the left-most visible day. This is a plain date (i.e., `yyyy-MM-dd`), all time information is discarded."""
    date_until: NotRequired[datetime]
    r"""Filter for absences that start on or before this day (but might continue after). If you imagine a calendar displaying absences, this defines the right-most visible day. This is a plain date (i.e., `yyyy-MM-dd`), all time information is discarded."""
    type_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of absence type IDs."""
    employee_id: NotRequired[str]
    r"""Filter by a specific employee using their ID."""


class GetHrisAbsencesRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""

    page_size: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""The number of results to return per page. Maximum is 250."""

    updated_after: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """

    include_deleted: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""

    ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""

    remote_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of remote IDs."""

    date_from: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter for all the absences that either start _or_ haven't ended yet on/after this day. If you imagine a calendar displaying absences, this defines the left-most visible day. This is a plain date (i.e., `yyyy-MM-dd`), all time information is discarded."""

    date_until: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter for absences that start on or before this day (but might continue after). If you imagine a calendar displaying absences, this defines the right-most visible day. This is a plain date (i.e., `yyyy-MM-dd`), all time information is discarded."""

    type_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of absence type IDs."""

    employee_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by a specific employee using their ID."""


class GetHrisAbsencesResponseTypedDict(TypedDict):
    result: GetHrisAbsencesPositiveResponseTypedDict


class GetHrisAbsencesResponse(BaseModel):
    next: Union[
        Callable[[], Optional[GetHrisAbsencesResponse]],
        Callable[[], Awaitable[Optional[GetHrisAbsencesResponse]]],
    ]

    result: GetHrisAbsencesPositiveResponse
