"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gethrisemployeespositiveresponse import (
    GetHrisEmployeesPositiveResponse,
    GetHrisEmployeesPositiveResponseTypedDict,
)
from datetime import datetime
from kombo.types import BaseModel
from kombo.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from typing import Awaitable, Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GetHrisEmployeesGlobalsTypedDict(TypedDict):
    integration_id: NotRequired[str]
    r"""ID of the integration you want to interact with."""


class GetHrisEmployeesGlobals(BaseModel):
    integration_id: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Integration-Id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""ID of the integration you want to interact with."""


class GetHrisEmployeesRequestTypedDict(TypedDict):
    cursor: NotRequired[str]
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""
    page_size: NotRequired[int]
    r"""The number of results to return per page. Maximum is 250."""
    updated_after: NotRequired[datetime]
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """
    include_deleted: NotRequired[bool]
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""
    ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""
    remote_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of remote IDs."""
    employment_statuses: NotRequired[List[str]]
    r"""Filter by a comma-separated list of `ACTIVE`, `PENDING`, `INACTIVE`, `LEAVE`
    * `ACTIVE`: the employee is **actively employed**
    * `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    * `INACTIVE`: a full-time employee is no longer employed, or, for a contract worker when their contract runs out
    * `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)


    Leave this blank to get results matching all values.
    """
    group_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of group IDs. We will only return employees that are members of _any_ of the groups."""
    legal_entity_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of legal entity IDs. We will only return employees that are members of _any_ of the legal entities."""
    work_location_ids: NotRequired[List[str]]
    r"""Filter by a comma-separated list of work location IDs. We will only return employees who are at _any_ of the work locations."""
    work_emails: NotRequired[List[str]]
    r"""Filter by a comma-separated list of work emails. We will only return employees who have _any_ of the work emails. The format of the emails is case-insensitive."""
    personal_emails: NotRequired[List[str]]
    r"""Filter by a comma-separated list of personal emails. We will only return employees who have _any_ of the personal emails. The format of the emails is case-insensitive."""
    custom_fields: NotRequired[str]
    r"""A JSON string with a single key-value pair like {\"fieldKey\":\"fieldValue\"} to filter employees by a specific custom field value. Note that the value must be a string, number, boolean or null and the key must be a valid custom field key. Custom fields with a value of type array or object are not supported."""


class GetHrisEmployeesRequest(BaseModel):
    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""An optional cursor string used for pagination. This can be retrieved from the `next` property of the previous page response."""

    page_size: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""The number of results to return per page. Maximum is 250."""

    updated_after: Annotated[
        Optional[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the entries based on the modification date in format `YYYY-MM-DDTHH:mm:ss.sssZ`. Returns records where either the record itself **OR** its nested data has been updated since this timestamp, even if the record's own `changed_at` field remains unchanged.

    If you want to track entry deletion, also set the `include_deleted=true` query parameter, because otherwise, deleted entries will be hidden.

    For more details, see [Understanding changed_at vs updated_after Behavior](https://docs.kombo.dev/ats/getting-started/fetching-data#understanding-changed_at-vs-updated_after-behavior).
    """

    include_deleted: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""By default, deleted entries are not returned. Use the `include_deleted` query param to include deleted entries too."""

    ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of IDs such as `222k7eCGyUdgt2JWZDNnkDs3,B5DVmypWENfU6eMe6gYDyJG3`."""

    remote_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of remote IDs."""

    employment_statuses: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of `ACTIVE`, `PENDING`, `INACTIVE`, `LEAVE`
    * `ACTIVE`: the employee is **actively employed**
    * `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    * `INACTIVE`: a full-time employee is no longer employed, or, for a contract worker when their contract runs out
    * `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)


    Leave this blank to get results matching all values.
    """

    group_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of group IDs. We will only return employees that are members of _any_ of the groups."""

    legal_entity_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of legal entity IDs. We will only return employees that are members of _any_ of the legal entities."""

    work_location_ids: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of work location IDs. We will only return employees who are at _any_ of the work locations."""

    work_emails: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of work emails. We will only return employees who have _any_ of the work emails. The format of the emails is case-insensitive."""

    personal_emails: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Filter by a comma-separated list of personal emails. We will only return employees who have _any_ of the personal emails. The format of the emails is case-insensitive."""

    custom_fields: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A JSON string with a single key-value pair like {\"fieldKey\":\"fieldValue\"} to filter employees by a specific custom field value. Note that the value must be a string, number, boolean or null and the key must be a valid custom field key. Custom fields with a value of type array or object are not supported."""


class GetHrisEmployeesResponseTypedDict(TypedDict):
    result: GetHrisEmployeesPositiveResponseTypedDict


class GetHrisEmployeesResponse(BaseModel):
    next: Union[
        Callable[[], Optional[GetHrisEmployeesResponse]],
        Callable[[], Awaitable[Optional[GetHrisEmployeesResponse]]],
    ]

    result: GetHrisEmployeesPositiveResponse
