"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from kombo.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


GetHrisEmployeesPositiveResponseGender = Union[
    Literal[
        "MALE",
        "FEMALE",
        "NON_BINARY",
        "NOT_SPECIFIED",
    ],
    UnrecognizedStr,
]


Ethnicity = Union[
    Literal[
        "WHITE",
        "ASIAN",
        "HISPANIC_LATINO",
        "HAWAIIAN",
        "NATIVE_AMERICAN",
        "BLACK_AFRICAN_AMERICAN",
        "MULTIPLE_ETHNICITIES",
        "DECLINE_TO_SPECIFY",
    ],
    UnrecognizedStr,
]


MaritalStatus = Union[
    Literal[
        "SINGLE",
        "MARRIED",
        "DOMESTIC_PARTNERSHIP",
        "WIDOWED",
        "DIVORCED",
        "SEPARATED",
        "NOT_MARRIED",
    ],
    UnrecognizedStr,
]


EmploymentStatus = Union[
    Literal[
        "ACTIVE",
        "PENDING",
        "INACTIVE",
        "LEAVE",
    ],
    UnrecognizedStr,
]


GetHrisEmployeesPositiveResponseEmploymentType = Union[
    Literal[
        "FULL_TIME",
        "PART_TIME",
        "CONTRACT",
        "INTERNSHIP",
        "FREELANCE",
        "WORKING_STUDENT",
        "APPRENTICESHIP",
        "TRAINING",
    ],
    UnrecognizedStr,
]


class HomeAddressTypedDict(TypedDict):
    r"""The employee’s home address."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class HomeAddress(BaseModel):
    r"""The employee’s home address."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


DomesticBankRoutingType = Literal[
    "GB_SORT_CODE",
    "DE_BANKLEITZAHL",
    "US_ABA_ROUTING_TRANSIT_NUMBER",
    "CA_ROUTING_NUMBER",
    "AU_BSB_CODE",
    "FR_RIB",
]
r"""Enum of the routing type, prefixed with the iso-3166-1-alpha-2 banks origin country. If there is uncertainty about the type, it will be set to null."""


class DomesticBankRoutingTypedDict(TypedDict):
    number: str
    r"""Bank routing number (e.g. DE Bankleitzahl, GB Sort Code, US ABA routing number, AU BSB code). This field is not formatted and therefore might contain delimiters (eg. 01-23-45)."""
    type: Nullable[DomesticBankRoutingType]
    r"""Enum of the routing type, prefixed with the iso-3166-1-alpha-2 banks origin country. If there is uncertainty about the type, it will be set to null."""


class DomesticBankRouting(BaseModel):
    number: str
    r"""Bank routing number (e.g. DE Bankleitzahl, GB Sort Code, US ABA routing number, AU BSB code). This field is not formatted and therefore might contain delimiters (eg. 01-23-45)."""

    type: Nullable[DomesticBankRoutingType]
    r"""Enum of the routing type, prefixed with the iso-3166-1-alpha-2 banks origin country. If there is uncertainty about the type, it will be set to null."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BankAccountTypedDict(TypedDict):
    iban: NotRequired[Nullable[str]]
    r"""The internationally unique IBAN identifying this account. If we detect a valid IBAN from the account number and this field would otherwise be empty, we will automatically populate this field."""
    bic: NotRequired[Nullable[str]]
    r"""The internationally unique BIC/SWIFT code identifying the bank behind this account. If we detect a valid BIC from the domestic bank routing number and this field would otherwise be empty, we will automatically populate this field."""
    account_number: NotRequired[Nullable[str]]
    r"""The bank-specific account number. Some companies use the account number field to put the IBAN here."""
    holder_name: NotRequired[Nullable[str]]
    r"""The name of the holder of this account."""
    bank_name: NotRequired[Nullable[str]]
    r"""The name of the bank behind this account."""
    domestic_bank_routing: NotRequired[Nullable[DomesticBankRoutingTypedDict]]


class BankAccount(BaseModel):
    iban: OptionalNullable[str] = UNSET
    r"""The internationally unique IBAN identifying this account. If we detect a valid IBAN from the account number and this field would otherwise be empty, we will automatically populate this field."""

    bic: OptionalNullable[str] = UNSET
    r"""The internationally unique BIC/SWIFT code identifying the bank behind this account. If we detect a valid BIC from the domestic bank routing number and this field would otherwise be empty, we will automatically populate this field."""

    account_number: OptionalNullable[str] = UNSET
    r"""The bank-specific account number. Some companies use the account number field to put the IBAN here."""

    holder_name: OptionalNullable[str] = UNSET
    r"""The name of the holder of this account."""

    bank_name: OptionalNullable[str] = UNSET
    r"""The name of the bank behind this account."""

    domestic_bank_routing: OptionalNullable[DomesticBankRouting] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "iban",
            "bic",
            "account_number",
            "holder_name",
            "bank_name",
            "domestic_bank_routing",
        ]
        nullable_fields = [
            "iban",
            "bic",
            "account_number",
            "holder_name",
            "bank_name",
            "domestic_bank_routing",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetHrisEmployeesPositiveResponsePayPeriod = Union[
    Literal[
        "HOUR",
        "DAY",
        "WEEK",
        "TWO_WEEKS",
        "HALF_MONTH",
        "MONTH",
        "TWO_MONTHS",
        "QUARTER",
        "HALF_YEAR",
        "YEAR",
    ],
    UnrecognizedStr,
]


GetHrisEmployeesPositiveResponsePayFrequency = Union[
    Literal[
        "DAILY",
        "WEEKLY",
        "BIWEEKLY",
        "MONTHLY",
        "SEMIMONTHLY",
        "QUARTERLY",
        "SEMIANNUALLY",
        "ANNUALLY",
        "PRO_RATA",
    ],
    UnrecognizedStr,
]


EmploymentEmploymentType = Union[
    Literal[
        "FULL_TIME",
        "PART_TIME",
        "CONTRACT",
        "INTERNSHIP",
        "FREELANCE",
        "WORKING_STUDENT",
        "APPRENTICESHIP",
        "TRAINING",
    ],
    UnrecognizedStr,
]


class EmploymentTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_id: str
    r"""The Kombo ID of the employment’s employee. The ID can be used to retrieve the employee from the `get employees` endpoint."""
    job_title: Nullable[str]
    r"""This field can contain historic job titles. Please use the `job_title` field on the employee for the active job title of an employee."""
    pay_rate: Nullable[float]
    r"""The monetary amount paid to an employee."""
    pay_currency: Nullable[str]
    r"""The currency that the employee is paid in. Usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""
    effective_date: Nullable[datetime]
    r"""The date of when the employment started.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    pay_period: NotRequired[Nullable[GetHrisEmployeesPositiveResponsePayPeriod]]
    r"""The time interval which the `pay_rate` is describing.

    A `pay_rate` value of `12000` with a `pay_period` of `YEAR` would indicate that the employee receives 12000 over the course of a year. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    pay_frequency: NotRequired[Nullable[GetHrisEmployeesPositiveResponsePayFrequency]]
    r"""The time interval at which the employee receives payment.

    A `pay_rate` of `12000`, with a `pay_period` of `YEAR`, and a `pay_frequency` of `MONTHLY` would indicate that the employee is paid 1000 every month. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    employment_type: NotRequired[Nullable[EmploymentEmploymentType]]
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """


class Employment(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_id: str
    r"""The Kombo ID of the employment’s employee. The ID can be used to retrieve the employee from the `get employees` endpoint."""

    job_title: Nullable[str]
    r"""This field can contain historic job titles. Please use the `job_title` field on the employee for the active job title of an employee."""

    pay_rate: Nullable[float]
    r"""The monetary amount paid to an employee."""

    pay_currency: Nullable[str]
    r"""The currency that the employee is paid in. Usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""

    effective_date: Nullable[datetime]
    r"""The date of when the employment started.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    pay_period: Annotated[
        OptionalNullable[GetHrisEmployeesPositiveResponsePayPeriod],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The time interval which the `pay_rate` is describing.

    A `pay_rate` value of `12000` with a `pay_period` of `YEAR` would indicate that the employee receives 12000 over the course of a year. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    pay_frequency: Annotated[
        OptionalNullable[GetHrisEmployeesPositiveResponsePayFrequency],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The time interval at which the employee receives payment.

    A `pay_rate` of `12000`, with a `pay_period` of `YEAR`, and a `pay_frequency` of `MONTHLY` would indicate that the employee is paid 1000 every month. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    employment_type: Annotated[
        OptionalNullable[EmploymentEmploymentType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["pay_period", "pay_frequency", "employment_type"]
        nullable_fields = [
            "remote_id",
            "job_title",
            "pay_rate",
            "pay_period",
            "pay_frequency",
            "employment_type",
            "pay_currency",
            "effective_date",
            "remote_deleted_at",
            "custom_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetHrisEmployeesPositiveResponseBalanceUnit = Literal[
    "HOURS",
    "DAYS",
]
r"""The time-unit of the balance."""


GetHrisEmployeesPositiveResponseUsedUnit = Literal[
    "HOURS",
    "DAYS",
]
r"""The time-unit of the used time."""


class TimeOffBalanceTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_id: str
    r"""The Kombo ID of the employee to which the balance belongs to. The ID can be used to retrieve the employee from the `get employees` endpoint."""
    type_id: str
    balance: Nullable[float]
    r"""The amount of time available to the employee."""
    balance_unit: Nullable[GetHrisEmployeesPositiveResponseBalanceUnit]
    r"""The time-unit of the balance."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    used: Nullable[float]
    r"""The amount of time used by the employee."""
    used_unit: Nullable[GetHrisEmployeesPositiveResponseUsedUnit]
    r"""The time-unit of the used time."""


class TimeOffBalance(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_id: str
    r"""The Kombo ID of the employee to which the balance belongs to. The ID can be used to retrieve the employee from the `get employees` endpoint."""

    type_id: str

    balance: Nullable[float]
    r"""The amount of time available to the employee."""

    balance_unit: Nullable[GetHrisEmployeesPositiveResponseBalanceUnit]
    r"""The time-unit of the balance."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    used: Nullable[float]
    r"""The amount of time used by the employee."""

    used_unit: Nullable[GetHrisEmployeesPositiveResponseUsedUnit]
    r"""The time-unit of the used time."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "remote_id",
            "balance",
            "balance_unit",
            "remote_deleted_at",
            "used",
            "used_unit",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


ManagerEmploymentStatus = Union[
    Literal[
        "ACTIVE",
        "PENDING",
        "INACTIVE",
        "LEAVE",
    ],
    UnrecognizedStr,
]


class ManagerTypedDict(TypedDict):
    first_name: Nullable[str]
    r"""The employee’s first name."""
    last_name: Nullable[str]
    r"""The employee’s last name."""
    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    employee_number: Nullable[str]
    r"""The employee’s organization-internal employee number."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    termination_date: Nullable[datetime]
    r"""The date when the employment ends. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    work_email: NotRequired[Nullable[str]]
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""
    employment_status: NotRequired[Nullable[ManagerEmploymentStatus]]
    r"""The employee’s current employment status:

    - `ACTIVE`: the employee is **actively employed**
    - `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    - `INACTIVE`: the employee is **not actively employed** anymore
    - `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """


class Manager(BaseModel):
    first_name: Nullable[str]
    r"""The employee’s first name."""

    last_name: Nullable[str]
    r"""The employee’s last name."""

    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""

    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    employee_number: Nullable[str]
    r"""The employee’s organization-internal employee number."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    termination_date: Nullable[datetime]
    r"""The date when the employment ends. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    work_email: OptionalNullable[str] = UNSET
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""

    employment_status: Annotated[
        OptionalNullable[ManagerEmploymentStatus],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The employee’s current employment status:

    - `ACTIVE`: the employee is **actively employed**
    - `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    - `INACTIVE`: the employee is **not actively employed** anymore
    - `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["work_email", "employment_status"]
        nullable_fields = [
            "first_name",
            "last_name",
            "display_full_name",
            "employee_number",
            "work_email",
            "employment_status",
            "termination_date",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupType = Literal[
    "DEPARTMENT",
    "TEAM",
    "COST_CENTER",
]
r"""Type of the group."""


class GroupTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The name of the group."""
    type: Nullable[GroupType]
    r"""Type of the group."""


class Group(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The name of the group."""

    type: Nullable[GroupType]
    r"""Type of the group."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LegalEntityAddressTypedDict(TypedDict):
    r"""The legal entity’s address."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class LegalEntityAddress(BaseModel):
    r"""The legal entity’s address."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LegalEntityTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The legal entity’s name."""
    address: NotRequired[Nullable[LegalEntityAddressTypedDict]]
    r"""The legal entity’s address."""


class LegalEntity(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The legal entity’s name."""

    address: OptionalNullable[LegalEntityAddress] = UNSET
    r"""The legal entity’s address."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address"]
        nullable_fields = ["remote_id", "name", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class WorkLocationAddressTypedDict(TypedDict):
    r"""The work location’s address"""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class WorkLocationAddress(BaseModel):
    r"""The work location’s address"""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class WorkLocationTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The work location’s name"""
    type: Nullable[str]
    r"""The work location’s type. A freeform string."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    address: NotRequired[Nullable[WorkLocationAddressTypedDict]]
    r"""The work location’s address"""


class WorkLocation(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The work location’s name"""

    type: Nullable[str]
    r"""The work location’s type. A freeform string."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    address: OptionalNullable[WorkLocationAddress] = UNSET
    r"""The work location’s address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address"]
        nullable_fields = ["remote_id", "name", "address", "type", "remote_deleted_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisEmployeesPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_number: Nullable[str]
    r"""The employee’s organization-internal employee number."""
    first_name: Nullable[str]
    r"""The employee’s first name."""
    last_name: Nullable[str]
    r"""The employee’s last name."""
    nationality: Nullable[str]
    r"""The employee’s nationality."""
    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""
    job_title: Nullable[str]
    r"""The employee’s job title."""
    mobile_phone_number: Nullable[str]
    r"""The employee’s mobile phone number."""
    ssn: Nullable[str]
    r"""The employee’s social security number"""
    tax_id: Nullable[str]
    r"""The employee’s tax ID."""
    weekly_hours: Nullable[float]
    r"""The employee’s weekly working hours."""
    avatar: Nullable[str]
    r"""URL to the employee’s avatar. This is either the raw URL from the HR system (in cases where it can be requested without short-lived authentication) _or_ a URL to a temporarily cached version of the file hosted by Kombo. Kombo will delete the cached file after its deletion in the source system."""
    work_location_id: Nullable[str]
    r"""The Kombo ID of the employee’s work location. The ID can be used to retrieve the work location from the `get work locations` endpoint."""
    legal_entity_id: Nullable[str]
    r"""The Kombo ID of the employee’s legal entity. The ID can be used to retrieve the legal entity from the `get legal entities` endpoint."""
    manager_id: Nullable[str]
    r"""The Kombo ID of the employee’s manager. The ID can be used to retrieve the manager from the `get employees` endpoint."""
    date_of_birth: Nullable[datetime]
    r"""The employee’s date of birth.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    start_date: Nullable[datetime]
    r"""The date the employee started working for the organization.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    termination_date: Nullable[datetime]
    r"""The date when the employment ends. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    employments: List[EmploymentTypedDict]
    time_off_balances: List[TimeOffBalanceTypedDict]
    manager: Nullable[ManagerTypedDict]
    groups: List[GroupTypedDict]
    legal_entity: Nullable[LegalEntityTypedDict]
    work_location: Nullable[WorkLocationTypedDict]
    work_email: NotRequired[Nullable[str]]
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""
    personal_email: NotRequired[Nullable[str]]
    r"""The employee’s personal email address. If the email address is invalid, we will set this to `null`."""
    gender: NotRequired[Nullable[GetHrisEmployeesPositiveResponseGender]]
    r"""The employee’s gender."""
    ethnicity: NotRequired[Nullable[Ethnicity]]
    r"""The employee’s ethnicity. In rare cases where we can’t find a clear mapping, the original string is passed through."""
    marital_status: NotRequired[Nullable[MaritalStatus]]
    r"""The employee’s current marital status. In rare cases where we can’t find a clear mapping, the original string is passed through."""
    employment_status: NotRequired[Nullable[EmploymentStatus]]
    r"""The employee’s current employment status:

    - `ACTIVE`: the employee is **actively employed**
    - `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    - `INACTIVE`: the employee is **not actively employed** anymore
    - `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    employment_type: NotRequired[
        Nullable[GetHrisEmployeesPositiveResponseEmploymentType]
    ]
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    home_address: NotRequired[Nullable[HomeAddressTypedDict]]
    r"""The employee’s home address."""
    bank_accounts: NotRequired[Nullable[List[BankAccountTypedDict]]]
    r"""The employee’s bank accounts."""


class GetHrisEmployeesPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_number: Nullable[str]
    r"""The employee’s organization-internal employee number."""

    first_name: Nullable[str]
    r"""The employee’s first name."""

    last_name: Nullable[str]
    r"""The employee’s last name."""

    nationality: Nullable[str]
    r"""The employee’s nationality."""

    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""

    job_title: Nullable[str]
    r"""The employee’s job title."""

    mobile_phone_number: Nullable[str]
    r"""The employee’s mobile phone number."""

    ssn: Nullable[str]
    r"""The employee’s social security number"""

    tax_id: Nullable[str]
    r"""The employee’s tax ID."""

    weekly_hours: Nullable[float]
    r"""The employee’s weekly working hours."""

    avatar: Nullable[str]
    r"""URL to the employee’s avatar. This is either the raw URL from the HR system (in cases where it can be requested without short-lived authentication) _or_ a URL to a temporarily cached version of the file hosted by Kombo. Kombo will delete the cached file after its deletion in the source system."""

    work_location_id: Nullable[str]
    r"""The Kombo ID of the employee’s work location. The ID can be used to retrieve the work location from the `get work locations` endpoint."""

    legal_entity_id: Nullable[str]
    r"""The Kombo ID of the employee’s legal entity. The ID can be used to retrieve the legal entity from the `get legal entities` endpoint."""

    manager_id: Nullable[str]
    r"""The Kombo ID of the employee’s manager. The ID can be used to retrieve the manager from the `get employees` endpoint."""

    date_of_birth: Nullable[datetime]
    r"""The employee’s date of birth.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    start_date: Nullable[datetime]
    r"""The date the employee started working for the organization.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    termination_date: Nullable[datetime]
    r"""The date when the employment ends. Can be in the past or future.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_created_at: Nullable[datetime]
    r"""The date and time the object was created in the remote system.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    employments: List[Employment]

    time_off_balances: List[TimeOffBalance]

    manager: Nullable[Manager]

    groups: List[Group]

    legal_entity: Nullable[LegalEntity]

    work_location: Nullable[WorkLocation]

    work_email: OptionalNullable[str] = UNSET
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""

    personal_email: OptionalNullable[str] = UNSET
    r"""The employee’s personal email address. If the email address is invalid, we will set this to `null`."""

    gender: Annotated[
        OptionalNullable[GetHrisEmployeesPositiveResponseGender],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The employee’s gender."""

    ethnicity: Annotated[
        OptionalNullable[Ethnicity], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The employee’s ethnicity. In rare cases where we can’t find a clear mapping, the original string is passed through."""

    marital_status: Annotated[
        OptionalNullable[MaritalStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The employee’s current marital status. In rare cases where we can’t find a clear mapping, the original string is passed through."""

    employment_status: Annotated[
        OptionalNullable[EmploymentStatus], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The employee’s current employment status:

    - `ACTIVE`: the employee is **actively employed**
    - `PENDING`: the employee is **not actively employed yet** (but they signed their contract or are part of an onboarding process)
    - `INACTIVE`: the employee is **not actively employed** anymore
    - `LEAVE`: the employee is still employed but **currently on leave** (note that not all HR systems support this status — use our absences API for detailed information)

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    employment_type: Annotated[
        OptionalNullable[GetHrisEmployeesPositiveResponseEmploymentType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    home_address: OptionalNullable[HomeAddress] = UNSET
    r"""The employee’s home address."""

    bank_accounts: OptionalNullable[List[BankAccount]] = UNSET
    r"""The employee’s bank accounts."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "work_email",
            "personal_email",
            "gender",
            "ethnicity",
            "marital_status",
            "employment_status",
            "employment_type",
            "home_address",
            "bank_accounts",
        ]
        nullable_fields = [
            "employee_number",
            "first_name",
            "last_name",
            "nationality",
            "display_full_name",
            "job_title",
            "work_email",
            "personal_email",
            "mobile_phone_number",
            "ssn",
            "tax_id",
            "gender",
            "ethnicity",
            "marital_status",
            "employment_status",
            "employment_type",
            "weekly_hours",
            "avatar",
            "work_location_id",
            "legal_entity_id",
            "manager_id",
            "home_address",
            "bank_accounts",
            "date_of_birth",
            "start_date",
            "termination_date",
            "remote_created_at",
            "remote_deleted_at",
            "custom_fields",
            "manager",
            "legal_entity",
            "work_location",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisEmployeesPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetHrisEmployeesPositiveResponseResultTypedDict]


class GetHrisEmployeesPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetHrisEmployeesPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisEmployeesPositiveResponseTypedDict(TypedDict):
    data: GetHrisEmployeesPositiveResponseDataTypedDict
    status: Literal["success"]


class GetHrisEmployeesPositiveResponse(BaseModel):
    data: GetHrisEmployeesPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
