"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from kombo.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


GetHrisEmploymentsPositiveResponsePayPeriod = Union[
    Literal[
        "HOUR",
        "DAY",
        "WEEK",
        "TWO_WEEKS",
        "HALF_MONTH",
        "MONTH",
        "TWO_MONTHS",
        "QUARTER",
        "HALF_YEAR",
        "YEAR",
    ],
    UnrecognizedStr,
]


GetHrisEmploymentsPositiveResponsePayFrequency = Union[
    Literal[
        "DAILY",
        "WEEKLY",
        "BIWEEKLY",
        "MONTHLY",
        "SEMIMONTHLY",
        "QUARTERLY",
        "SEMIANNUALLY",
        "ANNUALLY",
        "PRO_RATA",
    ],
    UnrecognizedStr,
]


GetHrisEmploymentsPositiveResponseEmploymentType = Union[
    Literal[
        "FULL_TIME",
        "PART_TIME",
        "CONTRACT",
        "INTERNSHIP",
        "FREELANCE",
        "WORKING_STUDENT",
        "APPRENTICESHIP",
        "TRAINING",
    ],
    UnrecognizedStr,
]


class GetHrisEmploymentsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_id: str
    r"""The Kombo ID of the employment’s employee. The ID can be used to retrieve the employee from the `get employees` endpoint."""
    job_title: Nullable[str]
    r"""This field can contain historic job titles. Please use the `job_title` field on the employee for the active job title of an employee."""
    pay_rate: Nullable[float]
    r"""The monetary amount paid to an employee."""
    pay_currency: Nullable[str]
    r"""The currency that the employee is paid in. Usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""
    effective_date: Nullable[datetime]
    r"""The date of when the employment started.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    pay_period: NotRequired[Nullable[GetHrisEmploymentsPositiveResponsePayPeriod]]
    r"""The time interval which the `pay_rate` is describing.

    A `pay_rate` value of `12000` with a `pay_period` of `YEAR` would indicate that the employee receives 12000 over the course of a year. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    pay_frequency: NotRequired[Nullable[GetHrisEmploymentsPositiveResponsePayFrequency]]
    r"""The time interval at which the employee receives payment.

    A `pay_rate` of `12000`, with a `pay_period` of `YEAR`, and a `pay_frequency` of `MONTHLY` would indicate that the employee is paid 1000 every month. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """
    employment_type: NotRequired[
        Nullable[GetHrisEmploymentsPositiveResponseEmploymentType]
    ]
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """


class GetHrisEmploymentsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_id: str
    r"""The Kombo ID of the employment’s employee. The ID can be used to retrieve the employee from the `get employees` endpoint."""

    job_title: Nullable[str]
    r"""This field can contain historic job titles. Please use the `job_title` field on the employee for the active job title of an employee."""

    pay_rate: Nullable[float]
    r"""The monetary amount paid to an employee."""

    pay_currency: Nullable[str]
    r"""The currency that the employee is paid in. Usually returned in [ISO 4217 currency codes](https://www.iso.org/iso-4217-currency-codes.html)."""

    effective_date: Nullable[datetime]
    r"""The date of when the employment started.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    pay_period: Annotated[
        OptionalNullable[GetHrisEmploymentsPositiveResponsePayPeriod],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The time interval which the `pay_rate` is describing.

    A `pay_rate` value of `12000` with a `pay_period` of `YEAR` would indicate that the employee receives 12000 over the course of a year. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    pay_frequency: Annotated[
        OptionalNullable[GetHrisEmploymentsPositiveResponsePayFrequency],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The time interval at which the employee receives payment.

    A `pay_rate` of `12000`, with a `pay_period` of `YEAR`, and a `pay_frequency` of `MONTHLY` would indicate that the employee is paid 1000 every month. In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    employment_type: Annotated[
        OptionalNullable[GetHrisEmploymentsPositiveResponseEmploymentType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The employee’s current employment type:

    - `FULL_TIME`: the employee is actively employed
    - `PART_TIME`: the employee is working only part of the usual working hours
    - `CONTRACT`: the employee is working temporarily under a contract
    - `INTERNSHIP`: the employee is working as an intern
    - `FREELANCE`: the employee is working as a freelancer
    - `WORKING_STUDENT`: the employee is working as a working student
    - `APPRENTICESHIP`: the employee is working in an apprenticeship
    - `TRAINING`: the employee is working in a training program

    In rare cases where we can’t find a clear mapping, the original string is passed through.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["pay_period", "pay_frequency", "employment_type"]
        nullable_fields = [
            "remote_id",
            "job_title",
            "pay_rate",
            "pay_period",
            "pay_frequency",
            "employment_type",
            "pay_currency",
            "effective_date",
            "remote_deleted_at",
            "custom_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisEmploymentsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetHrisEmploymentsPositiveResponseResultTypedDict]


class GetHrisEmploymentsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetHrisEmploymentsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisEmploymentsPositiveResponseTypedDict(TypedDict):
    data: GetHrisEmploymentsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetHrisEmploymentsPositiveResponse(BaseModel):
    data: GetHrisEmploymentsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
