"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


GetHrisPerformanceReviewsPositiveResponseType = Literal[
    "MANAGER",
    "DIRECT_REPORT",
    "PEER",
    "SELF",
]
r"""The relationship between the reviewee and reviewer. Manager: The reviewer is the manager of the reviewee. Direct Report: The reviewer is a direct report of the reviewee (reverse MANAGER). Peer: The reviewer is a peer of the reviewee. Self: The reviewer is the reviewee himself/herself. null: The relationship cannot be determined or the reviewer is missing."""


class SummaryRatingSingleSelectTypedDict(TypedDict):
    ordered_options: Nullable[List[str]]
    r"""The options of the summary rating. Ordered from bad to good."""
    value: Nullable[str]
    r"""The text value of the summary rating."""
    type: Literal["SINGLE_SELECT"]


class SummaryRatingSingleSelect(BaseModel):
    ordered_options: Nullable[List[str]]
    r"""The options of the summary rating. Ordered from bad to good."""

    value: Nullable[str]
    r"""The text value of the summary rating."""

    TYPE: Annotated[
        Annotated[
            Literal["SINGLE_SELECT"], AfterValidator(validate_const("SINGLE_SELECT"))
        ],
        pydantic.Field(alias="type"),
    ] = "SINGLE_SELECT"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["ordered_options", "value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SummaryRatingNumericTypedDict(TypedDict):
    min: Nullable[float]
    r"""The minimum value of the summary rating."""
    max: Nullable[float]
    r"""The maximum value of the summary rating."""
    value: Nullable[float]
    r"""The numeric value of the summary rating."""
    type: Literal["NUMERIC"]


class SummaryRatingNumeric(BaseModel):
    min: Nullable[float]
    r"""The minimum value of the summary rating."""

    max: Nullable[float]
    r"""The maximum value of the summary rating."""

    value: Nullable[float]
    r"""The numeric value of the summary rating."""

    TYPE: Annotated[
        Annotated[Literal["NUMERIC"], AfterValidator(validate_const("NUMERIC"))],
        pydantic.Field(alias="type"),
    ] = "NUMERIC"

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["min", "max", "value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SummaryRatingTypedDict = TypeAliasType(
    "SummaryRatingTypedDict",
    Union[SummaryRatingSingleSelectTypedDict, SummaryRatingNumericTypedDict],
)
r"""The summary rating of the performance review."""


SummaryRating = TypeAliasType(
    "SummaryRating", Union[SummaryRatingSingleSelect, SummaryRatingNumeric]
)
r"""The summary rating of the performance review."""


class RevieweeTypedDict(TypedDict):
    r"""The employee receiving the review."""

    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""The employee’s first name."""
    last_name: Nullable[str]
    r"""The employee’s last name."""
    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    work_email: NotRequired[Nullable[str]]
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""


class Reviewee(BaseModel):
    r"""The employee receiving the review."""

    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""The employee’s first name."""

    last_name: Nullable[str]
    r"""The employee’s last name."""

    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    work_email: OptionalNullable[str] = UNSET
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["work_email"]
        nullable_fields = [
            "first_name",
            "last_name",
            "display_full_name",
            "work_email",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ReviewerTypedDict(TypedDict):
    r"""The employee giving/writing the review."""

    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    first_name: Nullable[str]
    r"""The employee’s first name."""
    last_name: Nullable[str]
    r"""The employee’s last name."""
    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    work_email: NotRequired[Nullable[str]]
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""


class Reviewer(BaseModel):
    r"""The employee giving/writing the review."""

    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    first_name: Nullable[str]
    r"""The employee’s first name."""

    last_name: Nullable[str]
    r"""The employee’s last name."""

    display_full_name: Nullable[str]
    r"""The employee’s full name, including any middle names. Not all HR systems provide an explicit display name, so we recommend falling back to `first_name` and `last_name`."""

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    work_email: OptionalNullable[str] = UNSET
    r"""The employee’s work email address. If the email address is invalid, we will set this to `null`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["work_email"]
        nullable_fields = [
            "first_name",
            "last_name",
            "display_full_name",
            "work_email",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ReviewCycleTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    name: Nullable[str]
    r"""The name of the performance review cycle."""
    review_period_start_date: Nullable[datetime]
    r"""The start date of the review period of the performance review cycle. It is the start date of the evaluation timeframe and the earliest date reviews can be submitted for this cycle.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """


class ReviewCycle(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    name: Nullable[str]
    r"""The name of the performance review cycle."""

    review_period_start_date: Nullable[datetime]
    r"""The start date of the review period of the performance review cycle. It is the start date of the evaluation timeframe and the earliest date reviews can be submitted for this cycle.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "review_period_start_date", "remote_deleted_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisPerformanceReviewsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    type: Nullable[GetHrisPerformanceReviewsPositiveResponseType]
    r"""The relationship between the reviewee and reviewer. Manager: The reviewer is the manager of the reviewee. Direct Report: The reviewer is a direct report of the reviewee (reverse MANAGER). Peer: The reviewer is a peer of the reviewee. Self: The reviewer is the reviewee himself/herself. null: The relationship cannot be determined or the reviewer is missing."""
    summary_comment: Nullable[str]
    r"""The summary comment of the performance review."""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    reviewee: RevieweeTypedDict
    r"""The employee receiving the review."""
    reviewer: Nullable[ReviewerTypedDict]
    r"""The employee giving/writing the review."""
    review_cycle: Nullable[ReviewCycleTypedDict]
    summary_rating: NotRequired[Nullable[SummaryRatingTypedDict]]
    r"""The summary rating of the performance review."""


class GetHrisPerformanceReviewsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: str
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    type: Nullable[GetHrisPerformanceReviewsPositiveResponseType]
    r"""The relationship between the reviewee and reviewer. Manager: The reviewer is the manager of the reviewee. Direct Report: The reviewer is a direct report of the reviewee (reverse MANAGER). Peer: The reviewer is a peer of the reviewee. Self: The reviewer is the reviewee himself/herself. null: The relationship cannot be determined or the reviewer is missing."""

    summary_comment: Nullable[str]
    r"""The summary comment of the performance review."""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    reviewee: Reviewee
    r"""The employee receiving the review."""

    reviewer: Nullable[Reviewer]
    r"""The employee giving/writing the review."""

    review_cycle: Nullable[ReviewCycle]

    summary_rating: OptionalNullable[SummaryRating] = UNSET
    r"""The summary rating of the performance review."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["summary_rating"]
        nullable_fields = [
            "type",
            "summary_comment",
            "summary_rating",
            "remote_deleted_at",
            "reviewer",
            "review_cycle",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisPerformanceReviewsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetHrisPerformanceReviewsPositiveResponseResultTypedDict]


class GetHrisPerformanceReviewsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetHrisPerformanceReviewsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisPerformanceReviewsPositiveResponseTypedDict(TypedDict):
    data: GetHrisPerformanceReviewsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetHrisPerformanceReviewsPositiveResponse(BaseModel):
    data: GetHrisPerformanceReviewsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
