"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, List, Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class BreakTypedDict(TypedDict):
    ended_at: datetime
    r"""End time of the break."""
    paid: bool
    r"""Whether the break is paid or unpaid."""
    started_at: datetime
    r"""Start time of the break."""


class Break(BaseModel):
    ended_at: datetime
    r"""End time of the break."""

    paid: bool
    r"""Whether the break is paid or unpaid."""

    started_at: datetime
    r"""Start time of the break."""


class GetHrisTimesheetsPositiveResponseResultTypedDict(TypedDict):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""
    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""
    employee_id: str
    r"""The Kombo ID of the employee to which the timesheet belongs. The ID can be used to retrieve the employee from the `get employees` endpoint."""
    started_at: Nullable[datetime]
    r"""Start time of the shift, converted into UTC time zone.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    ended_at: Nullable[datetime]
    r"""End time of the shift, converted into UTC time zone.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    timezone: Nullable[str]
    r"""The ISO 8601 numeric UTC offset of the timesheet location in the format ±HH:MM (e.g., \"+02:00\", \"-05:30\"). If null, the original offset information was not available. You can use this to display the right timezone for the timesheet in the UI."""
    payable_hours: Nullable[float]
    r"""Payable hours including grace periods - only if available in the HRIS. Won't be calculated through Kombo."""
    unpaid_break_minutes: Nullable[float]
    r"""Unpaid break in minutes - will be from the HRIS or calculated by Kombo if we have concrete unpaid break times."""
    approval_status: Nullable[str]
    r"""Approval status of the shift. Can be PENDING, APPROVED, REJECTED, or null."""
    approved_at: Nullable[datetime]
    r"""The time when the shift was approved.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    comment: Nullable[str]
    r"""Comment on the shift."""
    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""
    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    breaks: NotRequired[Nullable[List[BreakTypedDict]]]
    r"""Concrete times of the breaks."""


class GetHrisTimesheetsPositiveResponseResult(BaseModel):
    id: str
    r"""The globally unique ID of this object generated by Kombo. We recommend using this as a stable primary key for syncing."""

    remote_id: Nullable[str]
    r"""The raw ID of the object in the remote system. We don't recommend using this as a primary key on your side as it might sometimes be compromised of multiple identifiers if a system doesn't provide a clear primary key."""

    employee_id: str
    r"""The Kombo ID of the employee to which the timesheet belongs. The ID can be used to retrieve the employee from the `get employees` endpoint."""

    started_at: Nullable[datetime]
    r"""Start time of the shift, converted into UTC time zone.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    ended_at: Nullable[datetime]
    r"""End time of the shift, converted into UTC time zone.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    timezone: Nullable[str]
    r"""The ISO 8601 numeric UTC offset of the timesheet location in the format ±HH:MM (e.g., \"+02:00\", \"-05:30\"). If null, the original offset information was not available. You can use this to display the right timezone for the timesheet in the UI."""

    payable_hours: Nullable[float]
    r"""Payable hours including grace periods - only if available in the HRIS. Won't be calculated through Kombo."""

    unpaid_break_minutes: Nullable[float]
    r"""Unpaid break in minutes - will be from the HRIS or calculated by Kombo if we have concrete unpaid break times."""

    approval_status: Nullable[str]
    r"""Approval status of the shift. Can be PENDING, APPROVED, REJECTED, or null."""

    approved_at: Nullable[datetime]
    r"""The time when the shift was approved.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    comment: Nullable[str]
    r"""Comment on the shift."""

    custom_fields: Nullable[Dict[str, Any]]
    r"""A key-value store of fields not covered by the schema. [Read more](/custom-fields)"""

    changed_at: datetime
    r"""The timestamp when this specific record was last modified. This field only updates when properties directly on this record change, NOT when related or nested models change. For filtering that considers nested data changes, use the `updated_after` parameter which will return records when either the record itself OR its related models have been updated.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    remote_deleted_at: Nullable[datetime]
    r"""The date and time the object was deleted in the remote system. Objects are automatically marked as deleted when Kombo can't retrieve them from the remote system anymore. Kombo will also anonymize entries 14 days after they disappear.
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    breaks: OptionalNullable[List[Break]] = UNSET
    r"""Concrete times of the breaks."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["breaks"]
        nullable_fields = [
            "remote_id",
            "started_at",
            "ended_at",
            "timezone",
            "payable_hours",
            "unpaid_break_minutes",
            "breaks",
            "approval_status",
            "approved_at",
            "comment",
            "custom_fields",
            "remote_deleted_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisTimesheetsPositiveResponseDataTypedDict(TypedDict):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""
    results: List[GetHrisTimesheetsPositiveResponseResultTypedDict]


class GetHrisTimesheetsPositiveResponseData(BaseModel):
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    results: List[GetHrisTimesheetsPositiveResponseResult]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetHrisTimesheetsPositiveResponseTypedDict(TypedDict):
    data: GetHrisTimesheetsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetHrisTimesheetsPositiveResponse(BaseModel):
    data: GetHrisTimesheetsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
