"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal
from typing_extensions import Annotated, TypedDict


GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseType = Literal[
    "DEFAULT",
    "CUSTOM",
]
r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseResultTypedDict(
    TypedDict
):
    id: str
    r"""The unique ID of the field."""
    key: str
    r"""The key of the field in the remote system."""
    model: str
    r"""The model the field is associated with."""
    type: GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseType
    r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""
    label: Nullable[str]
    r"""The label of the field in the remote system."""
    is_passthrough_enabled: bool
    r"""Whether the field is included in the integrations_fields array of the corresponding model."""
    is_writable: Literal[False]
    r"""This field is related to a deprecated feature and means nothing, but is kept for backwards compatibility."""


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseResult(BaseModel):
    id: str
    r"""The unique ID of the field."""

    key: str
    r"""The key of the field in the remote system."""

    model: str
    r"""The model the field is associated with."""

    type: GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseType
    r"""The type of the integration field. There is a type to avoid collisions between DEFAULT fields and CUSTOM fields with the same key."""

    label: Nullable[str]
    r"""The label of the field in the remote system."""

    is_passthrough_enabled: bool
    r"""Whether the field is included in the integrations_fields array of the corresponding model."""

    IS_WRITABLE: Annotated[
        Annotated[Literal[False], AfterValidator(validate_const(False))],
        pydantic.Field(alias="is_writable"),
    ] = False
    r"""This field is related to a deprecated feature and means nothing, but is kept for backwards compatibility."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["label"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseDataTypedDict(
    TypedDict
):
    results: List[
        GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseResultTypedDict
    ]
    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseData(BaseModel):
    results: List[GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseResult]

    next: Nullable[str]
    r"""Cursor string that can be passed to the `cursor` query parameter to get the next page. If this is `null`, then there are no more pages."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseTypedDict(TypedDict):
    data: GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseDataTypedDict
    status: Literal["success"]


class GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponse(BaseModel):
    data: GetIntegrationsIntegrationIDIntegrationFieldsPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
