"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal
from typing_extensions import Annotated, TypedDict


class GetIntegrationsIntegrationIDPositiveResponseToolTypedDict(TypedDict):
    id: str
    r"""The ID of the connected tool in Kombo (e.g. `factorial`)."""
    label: str
    internal_label: Nullable[str]
    r"""Internal label that can help you debug specific variants of the integration. Only show the `label` to your users."""
    logo_url: str
    r"""URL to an SVG logo of the connected tool. The logo usually contains the tool name."""
    icon_url: str
    r"""URL to a square SVG icon of the connected tool."""


class GetIntegrationsIntegrationIDPositiveResponseTool(BaseModel):
    id: str
    r"""The ID of the connected tool in Kombo (e.g. `factorial`)."""

    label: str

    internal_label: Nullable[str]
    r"""Internal label that can help you debug specific variants of the integration. Only show the `label` to your users."""

    logo_url: str
    r"""URL to an SVG logo of the connected tool. The logo usually contains the tool name."""

    icon_url: str
    r"""URL to a square SVG icon of the connected tool."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["internal_label"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetIntegrationsIntegrationIDPositiveResponseCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]


GetIntegrationsIntegrationIDPositiveResponseStatus = Literal[
    "ACTIVE",
    "INVALID",
    "INACTIVE",
]
r"""The current status of the integration.

- `ACTIVE`: The integration is syncing data as expected.
- `INVALID`: The integration has stopped syncing data because of invalid credentials. To fix this, reach out to your customer to [reconnect the integration](../guides/integration-states#credentials-invalid).
- `INACTIVE`: The integration has stopped syncing as it's been manually set to inactive. You can [enable it again](../guides/integration-states#inactive) in the integration's page.
"""


GetIntegrationsIntegrationIDPositiveResponseSetupStatus = Literal[
    "INCOMPLETE",
    "FINAL_SYNC_PENDING",
    "COMPLETED",
]
r"""The setup_status is used in conjunction with the filtering and field mapping features. If these are enabled in the connection flow, the integration will start in an \"INCOMPLETE\" state and move to \"COMPLETE\" once all steps are finished.

- `INCOMPLETE`: Setup is still in progress. Some steps aren’t finished, so no data is available yet. Syncs only run as needed for setup.
- `FINAL_SYNC_PENDING`: Setup is complete, and the final sync is running. Data will be available after this sync is done.
- `COMPLETED`: Setup is fully finished, and the integration is ready to use.
"""


class GetIntegrationsIntegrationIDPositiveResponseEndUserTypedDict(TypedDict):
    organization_name: str
    creator_email: Nullable[str]
    origin_id: Nullable[str]
    r"""The ID you have passed initially to the connection flow to create this integration."""


class GetIntegrationsIntegrationIDPositiveResponseEndUser(BaseModel):
    organization_name: str

    creator_email: Nullable[str]

    origin_id: Nullable[str]
    r"""The ID you have passed initially to the connection flow to create this integration."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["creator_email", "origin_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ScopeConfigTypedDict(TypedDict):
    id: str
    name: Nullable[str]


class ScopeConfig(BaseModel):
    id: str

    name: Nullable[str]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetIntegrationsIntegrationIDPositiveResponseCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


ScopeConfigSetting = Literal[
    "ENABLED",
    "DISABLED",
    "OPTIONAL",
]
r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""


GetIntegrationsIntegrationIDPositiveResponseFieldCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


FieldScopeConfigSetting = Literal[
    "ENABLED",
    "DISABLED",
    "OPTIONAL",
]
r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""


class GetIntegrationsIntegrationIDPositiveResponseFieldTypedDict(TypedDict):
    id: str
    r"""Key of the field in the API (e.g. first_name)."""
    is_available: bool
    r"""Whether the datapoint is available and enabled and not opted out of."""
    coverage_status: GetIntegrationsIntegrationIDPositiveResponseFieldCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """
    scope_config_setting: FieldScopeConfigSetting
    r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""
    opted_out_by_customer: bool
    r"""Whether the datapoint is opted out by your customer in the connection flow."""


class GetIntegrationsIntegrationIDPositiveResponseField(BaseModel):
    id: str
    r"""Key of the field in the API (e.g. first_name)."""

    is_available: bool
    r"""Whether the datapoint is available and enabled and not opted out of."""

    coverage_status: GetIntegrationsIntegrationIDPositiveResponseFieldCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """

    scope_config_setting: FieldScopeConfigSetting
    r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""

    opted_out_by_customer: bool
    r"""Whether the datapoint is opted out by your customer in the connection flow."""


class GetIntegrationsIntegrationIDPositiveResponseReadModelTypedDict(TypedDict):
    id: str
    r"""ID of the model (e.g. hris_employees)."""
    label: str
    r"""Label of the model (e.g. Employees)."""
    is_available: bool
    r"""Whether the datapoint is available and enabled and not opted out of."""
    coverage_status: GetIntegrationsIntegrationIDPositiveResponseCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """
    scope_config_setting: ScopeConfigSetting
    r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""
    opted_out_by_customer: bool
    r"""Whether the datapoint is opted out by your customer in the connection flow."""
    fields: List[GetIntegrationsIntegrationIDPositiveResponseFieldTypedDict]


class GetIntegrationsIntegrationIDPositiveResponseReadModel(BaseModel):
    id: str
    r"""ID of the model (e.g. hris_employees)."""

    label: str
    r"""Label of the model (e.g. Employees)."""

    is_available: bool
    r"""Whether the datapoint is available and enabled and not opted out of."""

    coverage_status: GetIntegrationsIntegrationIDPositiveResponseCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """

    scope_config_setting: ScopeConfigSetting
    r"""The setting of the datapoint in the scope config that you configured in the Kombo dashboard."""

    opted_out_by_customer: bool
    r"""Whether the datapoint is opted out by your customer in the connection flow."""

    fields: List[GetIntegrationsIntegrationIDPositiveResponseField]


class GetIntegrationsIntegrationIDPositiveResponseDataTypedDict(TypedDict):
    id: str
    tool: GetIntegrationsIntegrationIDPositiveResponseToolTypedDict
    category: GetIntegrationsIntegrationIDPositiveResponseCategory
    status: GetIntegrationsIntegrationIDPositiveResponseStatus
    r"""The current status of the integration.

    - `ACTIVE`: The integration is syncing data as expected.
    - `INVALID`: The integration has stopped syncing data because of invalid credentials. To fix this, reach out to your customer to [reconnect the integration](../guides/integration-states#credentials-invalid).
    - `INACTIVE`: The integration has stopped syncing as it's been manually set to inactive. You can [enable it again](../guides/integration-states#inactive) in the integration's page.
    """
    setup_status: GetIntegrationsIntegrationIDPositiveResponseSetupStatus
    r"""The setup_status is used in conjunction with the filtering and field mapping features. If these are enabled in the connection flow, the integration will start in an \"INCOMPLETE\" state and move to \"COMPLETE\" once all steps are finished.

    - `INCOMPLETE`: Setup is still in progress. Some steps aren’t finished, so no data is available yet. Syncs only run as needed for setup.
    - `FINAL_SYNC_PENDING`: Setup is complete, and the final sync is running. Data will be available after this sync is done.
    - `COMPLETED`: Setup is fully finished, and the integration is ready to use.
    """
    end_user: GetIntegrationsIntegrationIDPositiveResponseEndUserTypedDict
    scope_config: ScopeConfigTypedDict
    created_at: datetime
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """
    beta: bool
    read_models: List[GetIntegrationsIntegrationIDPositiveResponseReadModelTypedDict]


class GetIntegrationsIntegrationIDPositiveResponseData(BaseModel):
    id: str

    tool: GetIntegrationsIntegrationIDPositiveResponseTool

    category: GetIntegrationsIntegrationIDPositiveResponseCategory

    status: GetIntegrationsIntegrationIDPositiveResponseStatus
    r"""The current status of the integration.

    - `ACTIVE`: The integration is syncing data as expected.
    - `INVALID`: The integration has stopped syncing data because of invalid credentials. To fix this, reach out to your customer to [reconnect the integration](../guides/integration-states#credentials-invalid).
    - `INACTIVE`: The integration has stopped syncing as it's been manually set to inactive. You can [enable it again](../guides/integration-states#inactive) in the integration's page.
    """

    setup_status: GetIntegrationsIntegrationIDPositiveResponseSetupStatus
    r"""The setup_status is used in conjunction with the filtering and field mapping features. If these are enabled in the connection flow, the integration will start in an \"INCOMPLETE\" state and move to \"COMPLETE\" once all steps are finished.

    - `INCOMPLETE`: Setup is still in progress. Some steps aren’t finished, so no data is available yet. Syncs only run as needed for setup.
    - `FINAL_SYNC_PENDING`: Setup is complete, and the final sync is running. Data will be available after this sync is done.
    - `COMPLETED`: Setup is fully finished, and the integration is ready to use.
    """

    end_user: GetIntegrationsIntegrationIDPositiveResponseEndUser

    scope_config: ScopeConfig

    created_at: datetime
    r"""YYYY-MM-DDTHH:mm:ss.sssZ
    https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString
    """

    beta: bool

    read_models: List[GetIntegrationsIntegrationIDPositiveResponseReadModel]


class GetIntegrationsIntegrationIDPositiveResponseTypedDict(TypedDict):
    data: GetIntegrationsIntegrationIDPositiveResponseDataTypedDict
    status: Literal["success"]


class GetIntegrationsIntegrationIDPositiveResponse(BaseModel):
    data: GetIntegrationsIntegrationIDPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
