"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from kombo.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal
from typing_extensions import Annotated, TypedDict


class AssetsTypedDict(TypedDict):
    logo_url: str
    icon_url: str
    icon_black_url: str


class Assets(BaseModel):
    logo_url: str

    icon_url: str

    icon_black_url: str


GetToolsCategoryPositiveResponseReadModelCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


GetToolsCategoryPositiveResponseFieldCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


class GetToolsCategoryPositiveResponseFieldTypedDict(TypedDict):
    id: str
    r"""Key of the field in the model (e.g. first_name)."""
    coverage_status: GetToolsCategoryPositiveResponseFieldCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


class GetToolsCategoryPositiveResponseField(BaseModel):
    id: str
    r"""Key of the field in the model (e.g. first_name)."""

    coverage_status: GetToolsCategoryPositiveResponseFieldCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


class GetToolsCategoryPositiveResponseReadModelTypedDict(TypedDict):
    r"""List of models we can read for this tool."""

    id: str
    r"""ID of the model (e.g. hris_employees)."""
    label: str
    r"""Label of the model (e.g. Employees)."""
    coverage_status: GetToolsCategoryPositiveResponseReadModelCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """
    fields: List[GetToolsCategoryPositiveResponseFieldTypedDict]


class GetToolsCategoryPositiveResponseReadModel(BaseModel):
    r"""List of models we can read for this tool."""

    id: str
    r"""ID of the model (e.g. hris_employees)."""

    label: str
    r"""Label of the model (e.g. Employees)."""

    coverage_status: GetToolsCategoryPositiveResponseReadModelCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """

    fields: List[GetToolsCategoryPositiveResponseField]


WriteActionCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


class WriteActionTypedDict(TypedDict):
    r"""List of supported write actions for this tool."""

    id: str
    label: str
    coverage_status: WriteActionCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


class WriteAction(BaseModel):
    r"""List of supported write actions for this tool."""

    id: str

    label: str

    coverage_status: WriteActionCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


FeatureCoverageStatus = Literal[
    "SUPPORTED",
    "UNSUPPORTED",
    "NOT_IMPLEMENTED",
    "UNKNOWN",
]
r"""The status of a datapoint of an integrated tool:

- `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
- `UNSUPPORTED`: the tool does not support the datapoint.
- `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
- `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
"""


class FeatureTypedDict(TypedDict):
    id: str
    label: str
    coverage_status: FeatureCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


class Feature(BaseModel):
    id: str

    label: str

    coverage_status: FeatureCoverageStatus
    r"""The status of a datapoint of an integrated tool:

    - `SUPPORTED`: the tool supports the datapoint and it can be used through Kombo.
    - `UNSUPPORTED`: the tool does not support the datapoint.
    - `NOT_IMPLEMENTED`: tool supports the datapoint but it was not integrated by Kombo for a given reason (see coverage grid).
    - `UNKNOWN`: the datapoint is not integrated yet and Kombo has no information about it's availability in the tool.
    """


class CoverageTypedDict(TypedDict):
    r"""This describes the supported models and actions of this tool."""

    read_models: List[GetToolsCategoryPositiveResponseReadModelTypedDict]
    write_actions: List[WriteActionTypedDict]
    features: List[FeatureTypedDict]


class Coverage(BaseModel):
    r"""This describes the supported models and actions of this tool."""

    read_models: List[GetToolsCategoryPositiveResponseReadModel]

    write_actions: List[WriteAction]

    features: List[Feature]


class GetToolsCategoryPositiveResponseToolTypedDict(TypedDict):
    id: str
    label: str
    internal_label: Nullable[str]
    r"""Internal label that can help you debug specific variants of the integration. Only show the `label` to your users."""
    assets: AssetsTypedDict
    paid_api_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes details about the paid API. `null` if the tool is not paid."""
    fast_track_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes details about the fast track process. `null` if the fast track process is not available."""
    partner_only_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes partnership requirements. `null` if the tool does not require a partnership."""
    connection_guide_url: Nullable[str]
    r"""URL to the connection guide for this tool. `null` if no connection guide is available."""
    coverage: CoverageTypedDict
    r"""This describes the supported models and actions of this tool."""


class GetToolsCategoryPositiveResponseTool(BaseModel):
    id: str

    label: str

    internal_label: Nullable[str]
    r"""Internal label that can help you debug specific variants of the integration. Only show the `label` to your users."""

    assets: Assets

    paid_api_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes details about the paid API. `null` if the tool is not paid."""

    fast_track_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes details about the fast track process. `null` if the fast track process is not available."""

    partner_only_details_markdown: Nullable[str]
    r"""Markdown formatted text that describes partnership requirements. `null` if the tool does not require a partnership."""

    connection_guide_url: Nullable[str]
    r"""URL to the connection guide for this tool. `null` if no connection guide is available."""

    coverage: Coverage
    r"""This describes the supported models and actions of this tool."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "internal_label",
            "paid_api_details_markdown",
            "fast_track_details_markdown",
            "partner_only_details_markdown",
            "connection_guide_url",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetToolsCategoryPositiveResponseDataTypedDict(TypedDict):
    tools: List[GetToolsCategoryPositiveResponseToolTypedDict]


class GetToolsCategoryPositiveResponseData(BaseModel):
    tools: List[GetToolsCategoryPositiveResponseTool]


class GetToolsCategoryPositiveResponseTypedDict(TypedDict):
    data: GetToolsCategoryPositiveResponseDataTypedDict
    status: Literal["success"]


class GetToolsCategoryPositiveResponse(BaseModel):
    data: GetToolsCategoryPositiveResponseData

    STATUS: Annotated[
        Annotated[Literal["success"], AfterValidator(validate_const("success"))],
        pydantic.Field(alias="status"),
    ] = "success"
