"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Literal
from typing_extensions import NotRequired, TypedDict


InlineAssessmentOrderReceivedWebhookPayloadType = Literal[
    "inline-assessment:order-received",
]
r"""Type of the webhook event"""


InlineAssessmentOrderReceivedWebhookPayloadStatus = Literal[
    "OPEN",
    "COMPLETED",
    "CANCELLED",
    "REJECTED",
]
r"""The current status of the assessment order."""


class InlineAssessmentOrderReceivedWebhookPayloadCandidateTypedDict(TypedDict):
    r"""Information about the candidate taking the assessment."""

    email: str
    r"""The candidate's email address."""
    first_name: NotRequired[Nullable[str]]
    r"""The candidate's first name."""
    last_name: NotRequired[Nullable[str]]
    r"""The candidate's last name."""
    phone: NotRequired[Nullable[str]]
    r"""The candidate's phone number."""
    remote_id: NotRequired[Nullable[str]]
    r"""The candidate's identifier in the integrated system."""


class InlineAssessmentOrderReceivedWebhookPayloadCandidate(BaseModel):
    r"""Information about the candidate taking the assessment."""

    email: str
    r"""The candidate's email address."""

    first_name: OptionalNullable[str] = UNSET
    r"""The candidate's first name."""

    last_name: OptionalNullable[str] = UNSET
    r"""The candidate's last name."""

    phone: OptionalNullable[str] = UNSET
    r"""The candidate's phone number."""

    remote_id: OptionalNullable[str] = UNSET
    r"""The candidate's identifier in the integrated system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["first_name", "last_name", "phone", "remote_id"]
        nullable_fields = ["first_name", "last_name", "phone", "remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InlineAssessmentOrderReceivedWebhookPayloadApplicationTypedDict(TypedDict):
    r"""Information about the job application."""

    remote_id: NotRequired[Nullable[str]]
    r"""The application's identifier in the integrated system."""


class InlineAssessmentOrderReceivedWebhookPayloadApplication(BaseModel):
    r"""Information about the job application."""

    remote_id: OptionalNullable[str] = UNSET
    r"""The application's identifier in the integrated system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["remote_id"]
        nullable_fields = ["remote_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InlineAssessmentOrderReceivedWebhookPayloadLocationTypedDict(TypedDict):
    r"""The job location information."""

    city: NotRequired[Nullable[str]]
    country: NotRequired[Nullable[str]]
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""
    raw: NotRequired[Nullable[str]]
    r"""If we have address data, this is filled with the raw address string."""
    state: NotRequired[Nullable[str]]
    street_1: NotRequired[Nullable[str]]
    r"""If we can parse the address data, this field contains the first part of the street information."""
    street_2: NotRequired[Nullable[str]]
    zip_code: NotRequired[Nullable[str]]


class InlineAssessmentOrderReceivedWebhookPayloadLocation(BaseModel):
    r"""The job location information."""

    city: OptionalNullable[str] = UNSET

    country: OptionalNullable[str] = UNSET
    r"""Contains the ISO2 country code if possible. If not, it contains the original value."""

    raw: OptionalNullable[str] = UNSET
    r"""If we have address data, this is filled with the raw address string."""

    state: OptionalNullable[str] = UNSET

    street_1: OptionalNullable[str] = UNSET
    r"""If we can parse the address data, this field contains the first part of the street information."""

    street_2: OptionalNullable[str] = UNSET

    zip_code: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        nullable_fields = [
            "city",
            "country",
            "raw",
            "state",
            "street_1",
            "street_2",
            "zip_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


InlineAssessmentOrderReceivedWebhookPayloadHiringTeamRole = Literal[
    "RECRUITER",
    "HIRING_MANAGER",
]


class InlineAssessmentOrderReceivedWebhookPayloadHiringTeamTypedDict(TypedDict):
    r"""A member of the hiring team."""

    remote_id: str
    r"""The team member's identifier in the integrated system."""
    email: Nullable[str]
    r"""The team member's email address."""
    first_name: Nullable[str]
    r"""The team member's first name."""
    last_name: Nullable[str]
    r"""The team member's last name."""
    hiring_team_roles: List[InlineAssessmentOrderReceivedWebhookPayloadHiringTeamRole]
    r"""Array of the roles of the user for this specific job. Currently only `RECRUITER` and `HIRING_MANAGER` are mapped into our unified schema."""


class InlineAssessmentOrderReceivedWebhookPayloadHiringTeam(BaseModel):
    r"""A member of the hiring team."""

    remote_id: str
    r"""The team member's identifier in the integrated system."""

    email: Nullable[str]
    r"""The team member's email address."""

    first_name: Nullable[str]
    r"""The team member's first name."""

    last_name: Nullable[str]
    r"""The team member's last name."""

    hiring_team_roles: List[InlineAssessmentOrderReceivedWebhookPayloadHiringTeamRole]
    r"""Array of the roles of the user for this specific job. Currently only `RECRUITER` and `HIRING_MANAGER` are mapped into our unified schema."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["email", "first_name", "last_name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InlineAssessmentOrderReceivedWebhookPayloadJobTypedDict(TypedDict):
    r"""Information about the job posting."""

    hiring_team: List[InlineAssessmentOrderReceivedWebhookPayloadHiringTeamTypedDict]
    r"""The hiring team allows you to sync users into your system who can access the job and its applications."""
    remote_id: NotRequired[Nullable[str]]
    r"""The job's identifier in the integrated system."""
    name: NotRequired[Nullable[str]]
    r"""The job title."""
    location: NotRequired[
        Nullable[InlineAssessmentOrderReceivedWebhookPayloadLocationTypedDict]
    ]
    r"""The job location information."""


class InlineAssessmentOrderReceivedWebhookPayloadJob(BaseModel):
    r"""Information about the job posting."""

    hiring_team: List[InlineAssessmentOrderReceivedWebhookPayloadHiringTeam]
    r"""The hiring team allows you to sync users into your system who can access the job and its applications."""

    remote_id: OptionalNullable[str] = UNSET
    r"""The job's identifier in the integrated system."""

    name: OptionalNullable[str] = UNSET
    r"""The job title."""

    location: OptionalNullable[InlineAssessmentOrderReceivedWebhookPayloadLocation] = (
        UNSET
    )
    r"""The job location information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["remote_id", "name", "location"]
        nullable_fields = ["remote_id", "name", "location"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InlineAssessmentOrderReceivedWebhookPayloadDataTypedDict(TypedDict):
    id: str
    r"""The unique identifier of the assessment order."""
    package_id: str
    r"""The identifier of the assessment package."""
    status: InlineAssessmentOrderReceivedWebhookPayloadStatus
    r"""The current status of the assessment order."""
    integration_id: str
    r"""The unique identifier of the integration."""
    candidate: InlineAssessmentOrderReceivedWebhookPayloadCandidateTypedDict
    r"""Information about the candidate taking the assessment."""
    application: InlineAssessmentOrderReceivedWebhookPayloadApplicationTypedDict
    r"""Information about the job application."""
    job: InlineAssessmentOrderReceivedWebhookPayloadJobTypedDict
    r"""Information about the job posting."""


class InlineAssessmentOrderReceivedWebhookPayloadData(BaseModel):
    id: str
    r"""The unique identifier of the assessment order."""

    package_id: str
    r"""The identifier of the assessment package."""

    status: InlineAssessmentOrderReceivedWebhookPayloadStatus
    r"""The current status of the assessment order."""

    integration_id: str
    r"""The unique identifier of the integration."""

    candidate: InlineAssessmentOrderReceivedWebhookPayloadCandidate
    r"""Information about the candidate taking the assessment."""

    application: InlineAssessmentOrderReceivedWebhookPayloadApplication
    r"""Information about the job application."""

    job: InlineAssessmentOrderReceivedWebhookPayloadJob
    r"""Information about the job posting."""


class InlineAssessmentOrderReceivedWebhookPayloadTypedDict(TypedDict):
    id: str
    r"""Unique identifier for this webhook event"""
    type: InlineAssessmentOrderReceivedWebhookPayloadType
    r"""Type of the webhook event"""
    data: InlineAssessmentOrderReceivedWebhookPayloadDataTypedDict


class InlineAssessmentOrderReceivedWebhookPayload(BaseModel):
    id: str
    r"""Unique identifier for this webhook event"""

    type: InlineAssessmentOrderReceivedWebhookPayloadType
    r"""Type of the webhook event"""

    data: InlineAssessmentOrderReceivedWebhookPayloadData
