"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import TypedDict


IntegrationStateChangedWebhookPayloadType = Literal["integration-state-changed",]
r"""Type of the webhook event"""


IntegrationStateChangedWebhookPayloadIntegrationCategory = Literal[
    "HRIS",
    "ATS",
    "ASSESSMENT",
]
r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""


class IntegrationStateChangedWebhookPayloadEndUserTypedDict(TypedDict):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""
    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""
    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""


class IntegrationStateChangedWebhookPayloadEndUser(BaseModel):
    r"""Information about the end user who created the integration."""

    organization_name: str
    r"""The name of the organization that owns the integration."""

    creator_email: Nullable[str]
    r"""The email address of the user who created the integration."""

    origin_id: Nullable[str]
    r"""The unique identifier of the organization in the integrated system."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["creator_email", "origin_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


QaStatus = Literal[
    "PENDING",
    "FAILED",
    "PASSED",
]
r"""The quality assurance status of the integration."""


State = Literal[
    "ACTIVE",
    "INVALID",
    "INACTIVE",
]
r"""The current state of the integration."""


class IntegrationStateChangedWebhookPayloadDataTypedDict(TypedDict):
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""
    integration_id: str
    r"""The unique identifier of the integration."""
    integration_category: IntegrationStateChangedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""
    end_user: IntegrationStateChangedWebhookPayloadEndUserTypedDict
    r"""Information about the end user who created the integration."""
    qa_status: QaStatus
    r"""The quality assurance status of the integration."""
    state: State
    r"""The current state of the integration."""
    updated_at: datetime
    r"""ISO 8601 timestamp when the integration state was last updated."""


class IntegrationStateChangedWebhookPayloadData(BaseModel):
    integration_tool: str
    r"""The name of the integrated tool (e.g., \"personio\", \"greenhouse\")."""

    integration_id: str
    r"""The unique identifier of the integration."""

    integration_category: IntegrationStateChangedWebhookPayloadIntegrationCategory
    r"""The category of the integration (HRIS, ATS, or ASSESSMENT)."""

    end_user: IntegrationStateChangedWebhookPayloadEndUser
    r"""Information about the end user who created the integration."""

    qa_status: QaStatus
    r"""The quality assurance status of the integration."""

    state: State
    r"""The current state of the integration."""

    updated_at: datetime
    r"""ISO 8601 timestamp when the integration state was last updated."""


class IntegrationStateChangedWebhookPayloadTypedDict(TypedDict):
    id: str
    r"""Unique identifier for this webhook event"""
    type: IntegrationStateChangedWebhookPayloadType
    r"""Type of the webhook event"""
    data: IntegrationStateChangedWebhookPayloadDataTypedDict


class IntegrationStateChangedWebhookPayload(BaseModel):
    id: str
    r"""Unique identifier for this webhook event"""

    type: IntegrationStateChangedWebhookPayloadType
    r"""Type of the webhook event"""

    data: IntegrationStateChangedWebhookPayloadData
