"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Literal
from typing_extensions import TypedDict


KomboAtsErrorStatus = Literal["error",]


KomboAtsErrorCode = Literal[
    "PLATFORM.RATE_LIMIT_EXCEEDED",
    "PLATFORM.INTEGRATION_NOT_FOUND",
    "PLATFORM.INPUT_INVALID",
    "PLATFORM.UNKNOWN_ERROR",
    "PLATFORM.IP_NOT_WHITELISTED",
    "PLATFORM.AUTHENTICATION_INVALID",
    "INTEGRATION.PERMISSION_MISSING",
    "INTEGRATION.AUTHENTICATION_INVALID",
    "INTEGRATION.QA_FAILED",
    "INTEGRATION.SETUP_SYNC_PENDING",
    "INTEGRATION.SETUP_INCOMPLETE",
    "INTEGRATION.INACTIVE",
    "INTEGRATION.MODEL_NOT_AVAILABLE",
    "INTEGRATION.MODEL_DISABLED",
    "INTEGRATION.ACTION_NOT_AVAILABLE",
    "INTEGRATION.ACTION_DISABLED",
    "REMOTE.SERVICE_UNAVAILABLE",
    "REMOTE.RATE_LIMIT_EXCEEDED",
    "REMOTE.INPUT_INVALID",
    "REMOTE.UNKNOWN_HTTP_ERROR",
    "ATS.JOB_CLOSED",
    "ATS.APPLICATION_ALREADY_EXISTS",
]
r"""Some errors include an error code that can be used to identify their cause. See the [Error Handling Docs](https://docs.kombo.dev/guides/errors) for more information. For your error handling logic please use the error `code` instead of other properties (e.g. message, http status code, ...)."""


class KomboAtsErrorErrorTypedDict(TypedDict):
    r"""Error details with structured code for programmatic handling."""

    code: Nullable[KomboAtsErrorCode]
    r"""Some errors include an error code that can be used to identify their cause. See the [Error Handling Docs](https://docs.kombo.dev/guides/errors) for more information. For your error handling logic please use the error `code` instead of other properties (e.g. message, http status code, ...)."""
    title: Nullable[str]
    r"""A static, human-readable label."""
    message: str
    r"""A dynamic, detailed description of what went wrong in this specific instance."""
    log_url: Nullable[str]
    r"""The log page in the Kombo UI lists every interaction with full details. If you need assistance, share that link with our support team."""


class KomboAtsErrorError(BaseModel):
    r"""Error details with structured code for programmatic handling."""

    code: Nullable[KomboAtsErrorCode]
    r"""Some errors include an error code that can be used to identify their cause. See the [Error Handling Docs](https://docs.kombo.dev/guides/errors) for more information. For your error handling logic please use the error `code` instead of other properties (e.g. message, http status code, ...)."""

    title: Nullable[str]
    r"""A static, human-readable label."""

    message: str
    r"""A dynamic, detailed description of what went wrong in this specific instance."""

    log_url: Nullable[str]
    r"""The log page in the Kombo UI lists every interaction with full details. If you need assistance, share that link with our support team."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["code", "title", "log_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
