"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ContentType = Literal["PLAIN_TEXT",]
r"""Content type of the note. Currently only `PLAIN_TEXT` is supported."""


class PostAtsApplicationsApplicationIDNotesRequestBodyTeamtailorTypedDict(TypedDict):
    r"""Teamtailor specific remote fields for the note."""

    user_id: NotRequired[str]
    r"""ID of the user that created the note. Defaults to the first admin user found."""


class PostAtsApplicationsApplicationIDNotesRequestBodyTeamtailor(BaseModel):
    r"""Teamtailor specific remote fields for the note."""

    user_id: Optional[str] = None
    r"""ID of the user that created the note. Defaults to the first admin user found."""


class PostAtsApplicationsApplicationIDNotesRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsApplicationsApplicationIDNotesRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsApplicationsApplicationIDNotesRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDNotesRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[
        PostAtsApplicationsApplicationIDNotesRequestBodyPostHeaders
    ] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDNotesRequestBodyRecruiteeTypedDict(TypedDict):
    r"""Recruitee specific remote fields for the note."""

    visibility: NotRequired[Any]
    r"""Visibility of the created note."""
    is_json: NotRequired[bool]
    r"""Whether the note is in a stringified JSON format. If true, content should contain a valid JSON as per the [Recruitee API documentation](https://docs.recruitee.com/reference/candidatesidnotes) (body_json field). If false we add the note as a plain text."""


class PostAtsApplicationsApplicationIDNotesRequestBodyRecruitee(BaseModel):
    r"""Recruitee specific remote fields for the note."""

    visibility: Optional[Any] = None
    r"""Visibility of the created note."""

    is_json: Optional[bool] = None
    r"""Whether the note is in a stringified JSON format. If true, content should contain a valid JSON as per the [Recruitee API documentation](https://docs.recruitee.com/reference/candidatesidnotes) (body_json field). If false we add the note as a plain text."""


class PostAtsApplicationsApplicationIDNotesRequestBodyBullhornTypedDict(TypedDict):
    r"""Bullhorn specific remote fields for the note."""

    action: NotRequired[str]
    r"""The action (or type) associated with a Note. You can find all available note actions in a Bullhorn instance under System Settings > commentActionList. The default action is `Note`."""


class PostAtsApplicationsApplicationIDNotesRequestBodyBullhorn(BaseModel):
    r"""Bullhorn specific remote fields for the note."""

    action: Optional[str] = None
    r"""The action (or type) associated with a Note. You can find all available note actions in a Bullhorn instance under System Settings > commentActionList. The default action is `Note`."""


class PostAtsApplicationsApplicationIDNotesRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDNotesRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDNotesRequestBodyRemoteFieldsTypedDict(TypedDict):
    r"""Tool specific remote fields for the note."""

    teamtailor: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyTeamtailorTypedDict
    ]
    r"""Teamtailor specific remote fields for the note."""
    greenhouse: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyGreenhouseTypedDict
    ]
    r"""Fields specific to Greenhouse."""
    recruitee: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyRecruiteeTypedDict
    ]
    r"""Recruitee specific remote fields for the note."""
    bullhorn: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyBullhornTypedDict
    ]
    r"""Bullhorn specific remote fields for the note."""
    workable: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyWorkableTypedDict
    ]
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDNotesRequestBodyRemoteFields(BaseModel):
    r"""Tool specific remote fields for the note."""

    teamtailor: Optional[PostAtsApplicationsApplicationIDNotesRequestBodyTeamtailor] = (
        None
    )
    r"""Teamtailor specific remote fields for the note."""

    greenhouse: Optional[PostAtsApplicationsApplicationIDNotesRequestBodyGreenhouse] = (
        None
    )
    r"""Fields specific to Greenhouse."""

    recruitee: Optional[PostAtsApplicationsApplicationIDNotesRequestBodyRecruitee] = (
        None
    )
    r"""Recruitee specific remote fields for the note."""

    bullhorn: Optional[PostAtsApplicationsApplicationIDNotesRequestBodyBullhorn] = None
    r"""Bullhorn specific remote fields for the note."""

    workable: Optional[PostAtsApplicationsApplicationIDNotesRequestBodyWorkable] = None
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDNotesRequestBodyTypedDict(TypedDict):
    content: str
    r"""UTF-8 content of the note."""
    content_type: ContentType
    r"""Content type of the note. Currently only `PLAIN_TEXT` is supported."""
    remote_fields: NotRequired[
        PostAtsApplicationsApplicationIDNotesRequestBodyRemoteFieldsTypedDict
    ]
    r"""Tool specific remote fields for the note."""


class PostAtsApplicationsApplicationIDNotesRequestBody(BaseModel):
    content: str
    r"""UTF-8 content of the note."""

    content_type: ContentType
    r"""Content type of the note. Currently only `PLAIN_TEXT` is supported."""

    remote_fields: Optional[
        PostAtsApplicationsApplicationIDNotesRequestBodyRemoteFields
    ] = None
    r"""Tool specific remote fields for the note."""
