"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PostAtsApplicationsApplicationIDRejectRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsApplicationsApplicationIDRejectRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsApplicationsApplicationIDRejectRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsApplicationsApplicationIDRejectRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDRejectRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[
        PostAtsApplicationsApplicationIDRejectRequestBodyPostHeaders
    ] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDRejectRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDRejectRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDRejectRequestBodyRemoteFieldsTypedDict(TypedDict):
    r"""Additional fields that we will pass through to specific ATS systems."""

    greenhouse: NotRequired[
        PostAtsApplicationsApplicationIDRejectRequestBodyGreenhouseTypedDict
    ]
    r"""Fields specific to Greenhouse."""
    workable: NotRequired[
        PostAtsApplicationsApplicationIDRejectRequestBodyWorkableTypedDict
    ]
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDRejectRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    greenhouse: Optional[
        PostAtsApplicationsApplicationIDRejectRequestBodyGreenhouse
    ] = None
    r"""Fields specific to Greenhouse."""

    workable: Optional[PostAtsApplicationsApplicationIDRejectRequestBodyWorkable] = None
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDRejectRequestBodyTypedDict(TypedDict):
    rejection_reason_id: str
    r"""The Kombo ID of the rejection reason."""
    note: NotRequired[str]
    r"""A optional free text rejection note. Passed through if possible."""
    remote_fields: NotRequired[
        PostAtsApplicationsApplicationIDRejectRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PostAtsApplicationsApplicationIDRejectRequestBody(BaseModel):
    rejection_reason_id: str
    r"""The Kombo ID of the rejection reason."""

    note: Optional[str] = None
    r"""A optional free text rejection note. Passed through if possible."""

    remote_fields: Optional[
        PostAtsApplicationsApplicationIDRejectRequestBodyRemoteFields
    ] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
