"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PostAtsApplicationsApplicationIDResultLinksRequestBodyAttributeTypedDict(
    TypedDict
):
    key: str
    r"""The name of the attribute"""
    value: str
    r"""The value of the attribute"""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyAttribute(BaseModel):
    key: str
    r"""The name of the attribute"""

    value: str
    r"""The value of the attribute"""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyDetailsTypedDict(TypedDict):
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    custom_field_name_prefix: str
    r"""That will be added to the attribute labels if they are used for custom fields. If you specify `Acme:` as the prefix, the custom field will be named `Acme: Score`. Putting in the name of your company/product is a good idea."""
    attributes: List[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyAttributeTypedDict
    ]


class PostAtsApplicationsApplicationIDResultLinksRequestBodyDetails(BaseModel):
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    custom_field_name_prefix: str
    r"""That will be added to the attribute labels if they are used for custom fields. If you specify `Acme:` as the prefix, the custom field will be named `Acme: Score`. Putting in the name of your company/product is a good idea."""

    attributes: List[PostAtsApplicationsApplicationIDResultLinksRequestBodyAttribute]


class PostAtsApplicationsApplicationIDResultLinksRequestBodyIcimsTypedDict(TypedDict):
    r"""Fields specific to iCIMS."""

    assessment_package_id: NotRequired[str]
    r"""The package ID of the assessment that the result link will be added to."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyIcims(BaseModel):
    r"""Fields specific to iCIMS."""

    assessment_package_id: Optional[str] = None
    r"""The package ID of the assessment that the result link will be added to."""


PostAtsApplicationsApplicationIDResultLinksRequestBodyOverrideDocumentCategory = (
    Literal[
        "IRC_CANDIDATE_RESUME",
        "IRC_CANDIDATE_COVERLETTER",
        "MISC",
        "IRC_INTERNAL",
    ]
)
r"""Allows you to override the document category for the url. (Default: MISC)"""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyOracleTypedDict(TypedDict):
    r"""Fields specific to Oracle."""

    override_document_category: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyOverrideDocumentCategory
    ]
    r"""Allows you to override the document category for the url. (Default: MISC)"""
    multi_post_to_all_current_applications: NotRequired[bool]
    r"""If true, the result link will be posted to all current applications for the candidate."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyOracle(BaseModel):
    r"""Fields specific to Oracle."""

    override_document_category: Optional[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyOverrideDocumentCategory
    ] = None
    r"""Allows you to override the document category for the url. (Default: MISC)"""

    multi_post_to_all_current_applications: Optional[bool] = None
    r"""If true, the result link will be posted to all current applications for the candidate."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyPostHeadersTypedDict(
    TypedDict
):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsApplicationsApplicationIDResultLinksRequestBodyGreenhouseTypedDict(
    TypedDict
):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyPostHeaders
    ] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyWorkableTypedDict(
    TypedDict
):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyRemoteFieldsTypedDict(
    TypedDict
):
    r"""Additional fields that we will pass through to specific ATS systems."""

    icims: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyIcimsTypedDict
    ]
    r"""Fields specific to iCIMS."""
    oracle: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyOracleTypedDict
    ]
    r"""Fields specific to Oracle."""
    greenhouse: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyGreenhouseTypedDict
    ]
    r"""Fields specific to Greenhouse."""
    workable: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyWorkableTypedDict
    ]
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    icims: Optional[PostAtsApplicationsApplicationIDResultLinksRequestBodyIcims] = None
    r"""Fields specific to iCIMS."""

    oracle: Optional[PostAtsApplicationsApplicationIDResultLinksRequestBodyOracle] = (
        None
    )
    r"""Fields specific to Oracle."""

    greenhouse: Optional[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyGreenhouse
    ] = None
    r"""Fields specific to Greenhouse."""

    workable: Optional[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyWorkable
    ] = None
    r"""Workable specific remote fields for ATS actions."""


class PostAtsApplicationsApplicationIDResultLinksRequestBodyTypedDict(TypedDict):
    label: str
    r"""If we can display a display name for the link, we will use this label."""
    url: str
    r"""URL of the link."""
    details: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyDetailsTypedDict
    ]
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """
    remote_fields: NotRequired[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PostAtsApplicationsApplicationIDResultLinksRequestBody(BaseModel):
    label: str
    r"""If we can display a display name for the link, we will use this label."""

    url: str
    r"""URL of the link."""

    details: Optional[PostAtsApplicationsApplicationIDResultLinksRequestBodyDetails] = (
        None
    )
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    remote_fields: Optional[
        PostAtsApplicationsApplicationIDResultLinksRequestBodyRemoteFields
    ] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
