"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PostAtsCandidatesCandidateIDAttachmentsRequestBodyType = Literal[
    "CV",
    "COVER_LETTER",
    "OTHER",
]
r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyAttachmentTypedDict(TypedDict):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""
    type: PostAtsCandidatesCandidateIDAttachmentsRequestBodyType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""
    content_type: NotRequired[str]
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """
    data_url: NotRequired[str]
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """
    data: NotRequired[str]
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyAttachment(BaseModel):
    name: str
    r"""File name of the file you want to upload. We recommend providing something human-readable with a valid file extension (like `Resume.pdf`), as this might be shown in your customer's system."""

    type: PostAtsCandidatesCandidateIDAttachmentsRequestBodyType
    r"""Type of the attachment in the ATS. This may affect where the uploaded file will be shown in your customer's system."""

    content_type: Optional[str] = None
    r"""Content/MIME type of the file (e.g., `application/pdf`).

    If you provide `data`, this is required. If you provide `data_url`, this is optional and we'll attempt to use the `Content-Type` header of the response.

    **Note:** Please validate that the content type you provide is actually meaningful (and not something generic like [`application/octet-stream`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/MIME_types#applicationoctet-stream)). Especially when using object storage (like AWS S3), it's easy to accidentally discard the content types of user-provided files, so make sure to explicitly persist them when processing uploads from your users (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#SysMetadata), [Google Cloud](https://cloud.google.com/storage/docs/metadata#content-type), and [Azure](https://learn.microsoft.com/en-us/rest/api/storageservices/put-blob#request-headers-all-blob-types)).
    """

    data_url: Optional[str] = None
    r"""URL to the file you want to upload that can be accessed without authentication headers. We will download the content immediately when receiving the request, so the URL can be short-lived.

    If you're using an object storage provider (like AWS S3), we strongly recommend providing a signed URL for secure access (see guides for [AWS](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ShareObjectPreSignedURL.html), [Google Cloud](https://cloud.google.com/storage/docs/access-control/signed-urls), and [Azure](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """

    data: Optional[str] = None
    r"""Base64-encoded contents of the file you want to upload.

    **Note:** You must provide either this or `data_url`. We recommend `data_url` over `data` for most cases.
    """


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyPostHeaders
    ] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyRemoteFieldsTypedDict(
    TypedDict
):
    r"""Additional fields that we will pass through to specific ATS systems."""

    greenhouse: NotRequired[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyGreenhouseTypedDict
    ]
    r"""Fields specific to Greenhouse."""
    workable: NotRequired[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyWorkableTypedDict
    ]
    r"""Workable specific remote fields for ATS actions."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    greenhouse: Optional[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyGreenhouse
    ] = None
    r"""Fields specific to Greenhouse."""

    workable: Optional[PostAtsCandidatesCandidateIDAttachmentsRequestBodyWorkable] = (
        None
    )
    r"""Workable specific remote fields for ATS actions."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBodyTypedDict(TypedDict):
    attachment: PostAtsCandidatesCandidateIDAttachmentsRequestBodyAttachmentTypedDict
    remote_fields: NotRequired[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PostAtsCandidatesCandidateIDAttachmentsRequestBody(BaseModel):
    attachment: PostAtsCandidatesCandidateIDAttachmentsRequestBodyAttachment

    remote_fields: Optional[
        PostAtsCandidatesCandidateIDAttachmentsRequestBodyRemoteFields
    ] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
