"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from kombo.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PostAtsCandidatesCandidateIDResultLinksRequestBodyAttributeTypedDict(TypedDict):
    key: str
    r"""The name of the attribute"""
    value: str
    r"""The value of the attribute"""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyAttribute(BaseModel):
    key: str
    r"""The name of the attribute"""

    value: str
    r"""The value of the attribute"""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyDetailsTypedDict(TypedDict):
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    custom_field_name_prefix: str
    r"""That will be added to the attribute labels if they are used for custom fields. If you specify `Acme:` as the prefix, the custom field will be named `Acme: Score`. Putting in the name of your company/product is a good idea."""
    attributes: List[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyAttributeTypedDict
    ]


class PostAtsCandidatesCandidateIDResultLinksRequestBodyDetails(BaseModel):
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    custom_field_name_prefix: str
    r"""That will be added to the attribute labels if they are used for custom fields. If you specify `Acme:` as the prefix, the custom field will be named `Acme: Score`. Putting in the name of your company/product is a good idea."""

    attributes: List[PostAtsCandidatesCandidateIDResultLinksRequestBodyAttribute]


class PostAtsCandidatesCandidateIDResultLinksRequestBodyIcimsTypedDict(TypedDict):
    r"""Fields specific to iCIMS."""

    assessment_package_id: NotRequired[str]
    r"""The package ID of the assessment that the result link will be added to."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyIcims(BaseModel):
    r"""Fields specific to iCIMS."""

    assessment_package_id: Optional[str] = None
    r"""The package ID of the assessment that the result link will be added to."""


PostAtsCandidatesCandidateIDResultLinksRequestBodyOverrideDocumentCategory = Literal[
    "IRC_CANDIDATE_RESUME",
    "IRC_CANDIDATE_COVERLETTER",
    "MISC",
    "IRC_INTERNAL",
]
r"""Allows you to override the document category for the url. (Default: MISC)"""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyOracleTypedDict(TypedDict):
    r"""Fields specific to Oracle."""

    override_document_category: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyOverrideDocumentCategory
    ]
    r"""Allows you to override the document category for the url. (Default: MISC)"""
    multi_post_to_all_current_applications: NotRequired[bool]
    r"""If true, the result link will be posted to all current applications for the candidate."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyOracle(BaseModel):
    r"""Fields specific to Oracle."""

    override_document_category: Optional[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyOverrideDocumentCategory
    ] = None
    r"""Allows you to override the document category for the url. (Default: MISC)"""

    multi_post_to_all_current_applications: Optional[bool] = None
    r"""If true, the result link will be posted to all current applications for the candidate."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyPostHeadersTypedDict(TypedDict):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: NotRequired[Nullable[str]]
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyPostHeaders(BaseModel):
    r"""Headers we will pass with `POST` requests to Greenhouse."""

    on_behalf_of: Annotated[
        OptionalNullable[str], pydantic.Field(alias="On-Behalf-Of")
    ] = UNSET
    r"""ID of the the user that will show up as having performed the action in Greenhouse. We already pass a value by default, but you can use this to override it."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["On-Behalf-Of"]
        nullable_fields = ["On-Behalf-Of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostAtsCandidatesCandidateIDResultLinksRequestBodyGreenhouseTypedDict(TypedDict):
    r"""Fields specific to Greenhouse."""

    post_headers: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyPostHeadersTypedDict
    ]
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyGreenhouse(BaseModel):
    r"""Fields specific to Greenhouse."""

    post_headers: Optional[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyPostHeaders
    ] = None
    r"""Headers we will pass with `POST` requests to Greenhouse."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyWorkableTypedDict(TypedDict):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: NotRequired[str]
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyWorkable(BaseModel):
    r"""Workable specific remote fields for ATS actions."""

    on_behalf_of_user_remote_id: Optional[str] = None
    r"""The remote ID of the user that will be displayed in the UI as the one that performed the action."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyRemoteFieldsTypedDict(
    TypedDict
):
    r"""Additional fields that we will pass through to specific ATS systems."""

    icims: NotRequired[PostAtsCandidatesCandidateIDResultLinksRequestBodyIcimsTypedDict]
    r"""Fields specific to iCIMS."""
    oracle: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyOracleTypedDict
    ]
    r"""Fields specific to Oracle."""
    greenhouse: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyGreenhouseTypedDict
    ]
    r"""Fields specific to Greenhouse."""
    workable: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyWorkableTypedDict
    ]
    r"""Workable specific remote fields for ATS actions."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyRemoteFields(BaseModel):
    r"""Additional fields that we will pass through to specific ATS systems."""

    icims: Optional[PostAtsCandidatesCandidateIDResultLinksRequestBodyIcims] = None
    r"""Fields specific to iCIMS."""

    oracle: Optional[PostAtsCandidatesCandidateIDResultLinksRequestBodyOracle] = None
    r"""Fields specific to Oracle."""

    greenhouse: Optional[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyGreenhouse
    ] = None
    r"""Fields specific to Greenhouse."""

    workable: Optional[PostAtsCandidatesCandidateIDResultLinksRequestBodyWorkable] = (
        None
    )
    r"""Workable specific remote fields for ATS actions."""


class PostAtsCandidatesCandidateIDResultLinksRequestBodyTypedDict(TypedDict):
    label: str
    r"""If the system allows us to display a display name for the link, we will use this label."""
    url: str
    r"""URL of the link."""
    details: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyDetailsTypedDict
    ]
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """
    remote_fields: NotRequired[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyRemoteFieldsTypedDict
    ]
    r"""Additional fields that we will pass through to specific ATS systems."""


class PostAtsCandidatesCandidateIDResultLinksRequestBody(BaseModel):
    label: str
    r"""If the system allows us to display a display name for the link, we will use this label."""

    url: str
    r"""URL of the link."""

    details: Optional[PostAtsCandidatesCandidateIDResultLinksRequestBodyDetails] = None
    r"""Additional details with attributes that will be added to the result. This can be percentages, scores, or any text.

    We generally recommend using short attribute keys and a short custom_field_name_prefix to avoid overflowing the ATS UI.
    """

    remote_fields: Optional[
        PostAtsCandidatesCandidateIDResultLinksRequestBodyRemoteFields
    ] = None
    r"""Additional fields that we will pass through to specific ATS systems."""
